unit optbaseu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, ExtCtrls;

type
  TOptForm = class(TForm)
    lbMain       : TListBox;
    Panel1       : TPanel;
      btnAdd     : TButton;
      btnRemove  : TButton;
      btnOK      : TButton;
      btnCancel  : TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    Opt : String;
  public
    { Public declarations }
  end;

var
  OptForm: TOptForm;

implementation
uses IniFiles, in4Share;

{$R *.DFM}

procedure TOptForm.FormCreate(Sender: TObject);
begin
  Opt := Name+ ' Settings';
  WITH TIniFile.Create(iniName) DO
  try
    Width  := ReadInteger(Opt, 'Width', Constraints.MinWidth);
    IF Width < Constraints.MinWidth THEN   //!!0.4
      Width := Constraints.MinWidth;       //!!0.4
    Height := ReadInteger(Opt, 'Height', Constraints.MinHeight);
    IF Height < Constraints.MinHeight THEN //!!0.4
      Height := Constraints.MinHeight;     //!!0.4
    Left   := ReadInteger(Opt, 'Left', (Screen.Width - Width) DIV 2);
    IF Left + Width > Screen.Width THEN
      Left := Screen.Width - Width;
    Top    := ReadInteger(Opt, 'Top', (Screen.Height -Height) DIV 2);
    IF Top + Height > Screen.Height THEN
      Top := Screen.Height - Height;
  finally
    Free;
  end;
end;

procedure TOptForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(iniName) DO
  try
    WriteInteger(Opt, 'Width',  Width);
    WriteInteger(Opt, 'Height', Height);
    WriteInteger(Opt, 'Left',   Left);
    WriteInteger(Opt, 'Top',    Top);
  finally
    Free;
  end;
end;

procedure TOptForm.btnRemoveClick(Sender: TObject);
VAR idx : Integer;
begin
  WITH lbMain DO
    begin
      IF ItemIndex = Items.Count - 1 THEN
        Idx := Items.Count-2
      ELSE Idx := ItemIndex;
      IF ItemIndex > -1 THEN
        Items.Delete(ItemIndex);
      ItemIndex := Idx;
      lbMain.Perform(LB_SETCURSEL, Idx, 0);
    end;
end;

procedure TOptForm.FormActivate(Sender: TObject);
begin
  lbMain.Perform(LB_SETCURSEL, 0, 0);
end;

end.
     