;---------------------------------------------------------------    
;Ctrltrap.asm - VxD which assists Inctrl4 utility              |
;--------------------------------------------------------------|
;Copyright (c) 1999
;Ziff-Davis Publishing Company
;All rights reserved.
;First Published in PC Magazine, US Edition, January 19, 1999
;Written by Rick Knoblaugh
;--------------------------------------------------------------|
; 08/07/98 - initial development                               |
;                                                              |
;                                                              |
;                                                              |
;--------------------------------------------------------------|
.386p
;---------------------------------------------------------------
;               Include Files                                  |
;---------------------------------------------------------------
.list
		include	vmm.inc
MASM=1       
                include ifs.inc
                include ifsmgr.inc
		include	vwin32.inc
		include	vmmreg.inc
                include ctequ.inc
                include ctstruc.inc

;---------------------------------------------------------------
;               Initialization Data                            |
;---------------------------------------------------------------

VXD_IDATA_SEG
VXD_IDATA_ENDS

;---------------------------------------------------------------
;               Data                                           |
;---------------------------------------------------------------
VXD_LOCKED_DATA_SEG

; Jump table for commands initiated by accessing Windows application
Service_Table	label	dword
		dd	offset32	ctdioc_getversion  
		dd	offset32	getversion
                dd	offset32	register_callback
                dd	offset32	give_back_node
                dd	offset32	update_callback
                dd	offset32	give_back_extnode
                dd	offset32	get_obfuscator

SERVICE_TABLE_SIZE	equ	($ - Service_Table) / 4

prev_ifs_hooker dd      ?       ;holds ptr to address of previous IFSMgr hooker

trap_conditions trap_criteria   MAX_TRAP_FUNCTIONS dup(<>)

list_handle     dd      ?       ;used with linked list services
ext_list_handle dd      ?       ;used with linked list services
num_conditions  dw      ?
ot_find_data    _WIN32_FIND_DATA        <>              


;if bit is set in the following variable, function uses a path (i.e., it's
;an OPEN, etc.).
path_bit_map    dd      01011101111b    ;(function # - IFSFN_CONNECT) = bit

reqfile_bit_map dd      00000000010b    ;DELETE (add others if needed)
entry_count     dd      0               ;detect hook being reentered
reg_busy        dd      0               ;detect registry functions being reentered

OpenKey         dd      0               ;these contain addresses of registry
CloseKey        dd      0               ;functions we have hooked
CreateKey       dd      0               ;init these to zero indicating that
DeleteKey       dd      0               ;haven't hooked any yet
EnumKey         dd      0
QueryValue      dd      0
SetValue        dd      0
DeleteValue     dd      0
EnumValue       dd      0
QueryValueEx    dd      0
SetValueEx      dd      0


;Note: Reg_OpenKey must always be first entry in table
                                             
reg_func_table  reg_func        <REG_OPEN_KEY, @@_RegOpenKey, OpenKey, CtOpenKey >              
                reg_func        <REG_CLOSE_KEY, @@_RegCloseKey, CloseKey, CtCloseKey >              
                reg_func        <REG_CREATE_KEY, @@_RegCreateKey, CreateKey, CtCreateKey >              
                reg_func        <REG_DELETE_KEY, @@_RegDeleteKey, DeleteKey, CtDeleteKey >              
                reg_func        <REG_CHANGE_VALUE , @@_RegSetValue, SetValue, CtSetValue> 
                reg_func        <REG_CHANGE_VALUE , @@_RegSetValueEx, SetValueEx, CtSetValueEx> 
                reg_func        <REG_QUERY_VALUE , @@_RegQueryValue, QueryValue, CtQueryValue> 
                reg_func        <REG_QUERY_VALUE , @@_RegQueryValueEx, QueryValueEx, CtQueryValueEx> 
                reg_func        <REG_DELETE_VALUE , @@_RegDeleteValue, DeleteValue, CtDeleteValue> 
REG_TABLE_ENTRIES equ	($ - reg_func_table) / (size reg_func)

predefined_table predefined_struc <HKEY_CLASSES_ROOT, hkey_classes_root_str>
                 predefined_struc <HKEY_CURRENT_USER, hkey_currentu_str>
                 predefined_struc <HKEY_LOCAL_MACHINE, hkey_localm_str>
                 predefined_struc <HKEY_USERS, hkey_users_str>
                 predefined_struc <HKEY_CURRENT_CONFIG, hkey_currentc_str>
                 predefined_struc <HKEY_DYN_DATA, hkey_dyndata_str>
PREDEFINED_ENTRIES equ ($- predefined_table) / (size predefined_struc)


hkey_classes_root_str   db      'HKEY_CLASSES_ROOT', 0
hkey_currentu_str       db      'HKEY_CURRENT_USER', 0
hkey_localm_str         db      'HKEY_LOCAL_MACHINE', 0
hkey_users_str          db      'HKEY_USERS',0
hkey_currentc_str       db      'HKEY_CURRENT_CONFIG',0 
hkey_dyndata_str        db      'HKEY_DYN_DATA', 0

handle_count    dw      0

work_key        dd      ?       ;used for attempting to open keys 
work_type       dd      ?       
work_data       db      (16 * 1024) dup(?)
work_length     dd      ?            
work_res_zero   dd      0

handle_table    hkey_track  MAX_HANDLES_TO_TRACK dup(<0,0,,0>)

work_key_str    db      MAX_VMM_REG_KEY_LEN+1 dup(?)


VXD_LOCKED_DATA_ENDS

;---------------------------------------------------------------
;               Device Declaration                             |
;---------------------------------------------------------------

VXD_LOCKED_CODE_SEG

DECLARE_VIRTUAL_DEVICE CTRLTRAP,	\
	CTMAJOR_VERSION, 	\
	CTMINOR_VERSION,	\
	_CT_Control,,		\
	UNDEFINED_INIT_ORDER	\
	,,,

;--------------------------------------------------------------
;CT_Control - Device control procedure.  Dispatches           |
;             messages sent to this Vxd.                      |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;                 CY - If failure in handling message         |
;                                                             |
;--------------------------------------------------------------
public 		_CT_Control
_CT_Control 	proc 	near 
		Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, ct_dynamic_init
		Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, ct_dynamic_exit
		Control_Dispatch W32_DEVICEIOCONTROL, ctioctl
		clc
		ret
_CT_Control 	endp

;--------------------------------------------------------------
;ctifs_mgrproc - Hook of the Installable File System Mgr's    |
;                API.  Look for calls we're interested in     |
;                and report them to our application           |
;                counterpart.                                 |
;                                                             |
;                                                             |
;          Enter:                                             |
;                prev_ifs_hooker = ptr to address of previous |
;                                  hook                       |
;           Exit:                                             |
;                                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       ctifs_mgrproc
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp
                inc     entry_count             ;indicate we're in here

;-------                                        ;this section is only 
                cmp     entry_count, 1          ;for checking reentrancy
                je      ctifs_m100              ;issues
;;;;;;;         int     1                      
                nop
                nop
;------


ctifs_m100:
                mov     [ebp].active_hook, IFSMgr_Device_ID     ;got control on IFSmgr hook
                mov     [ebp].log_flag, FALSE           ;not logging it yet  
                call    test_for_log                    ;see if we log this
                jnc     ctifs_m700                      ;if not, go pass through
                pusha
                pushf

                call    get_prog_info

                mov     edx, [ebp].fs_func_num
                call    record_io                       ;put into our buffer 

ctifs_m600:
                popf
                popa       


ctifs_m700:

;setup the stack for previous hooker

                push    [ebp].fs_pioreq
                push    [ebp].fs_code_page
                push    [ebp].fs_res_flags
                push    [ebp].fs_drive
                push    [ebp].fs_func_num
                push    [ebp].fs_fnaddr
                
                mov     eax, prev_ifs_hooker  ;get ptr to adress previous hooker
                call    dword ptr [eax]       ;call hooker

                test    [ebp].log_flag, TRUE            ;logging this one?
                jz      ctifs_m900
          
                pusha      

                ;put error code of completed operation into buffer
                ;also store handle (valid field when doing OPENs or
                ;find first file functions) 

                mov     esi, [ebp].fs_pioreq            ;get ptr to ioreq
                mov     dx, [esi].ir_error              ;pull out error code
                mov     edi, [ebp].rec_buffer           ;get ptr to buffer
                mov     [edi].tr_error, dx              ;put in error code
                mov     edx, [esi].ir_fh                ;get file handle too
                mov     [edi].tr_handle, edx            ;and store it

                ;report to our application counterpart


                call    report_io                       ;go tell app about it
                    
ctifs_m800:

;Could alter code to go and ckeck for more callbacks here. However,
;we are supporting only one client, INCTRL4, to make things simpler.

                popa

ctifs_m900:
                add     esp, FSAPI_PARMS_SIZE           ;take off the parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                dec     entry_count                     ;we're out of here
		ret     
EndProc         ctifs_mgrproc

;--------------------------------------------------------------
;get_prog_info - Retrieve and store program name for process  |
;                that's performing the hooked functions.      |
;                This routine called by IFSMGR function and   |
;                registry function hooks.                     |
;                                                             |
;          Enter:                                             |
;   cur_process_hand = handle for current process             |
;    cur_thread_hand = handle for current thread              |
;                                                             |
;           Exit:                                             |
;               ESI = handle for current process              |
;          mod_name filled with program name                  |
;No registers saved  except fs                                |
;--------------------------------------------------------------
BeginProc       get_prog_info
                push    fs
                or      [ebp].log_flag, TRUE            ;want to log this one

                mov     esi, [ebp].cur_process_hand     ;get process handle
                mov     edi, [ebp].cur_thread_hand      ;and thread  handle
                mov     edi, [edi].TCB_VMHandle         ;get VM control block

                mov     ecx, [edi].CB_VMID
                cmp     ecx, 1                          ;DOS box?
                je      get_prog_i400                   ;if not, can get TDB selector

                mov     dword ptr [ebp].mod_name, 0
                jmp     short get_prog_i500

get_prog_i400:

                mov     bx, [esi].PDB_TDB_SEL_OFF       ;get TDB selector
                mov     fs, bx                          

                mov     ebx, TDB_MODNAME_OFF

                ;have 8 character module name offset in ebx
                                
                mov     eax, fs:[ebx]                   ;get first 4 chars
                mov     dword ptr [ebp].mod_name, eax                   
                mov     eax, fs:[ebx+4]                 ;get last 4 chars
                mov     dword ptr [ebp].mod_name+4, eax                   


get_prog_i500:
                pop     fs
                ret
EndProc         get_prog_info

;--------------------------------------------------------------
;test_for_log - Determine if the function being               |
;               processed meets the logging conditions        |
;               specifed by our application counterpart.      |
;                                                             |
;                                                             |
;          Enter:                                             |
;                EBP = IFS hook function stack frame          |
;    trap_conditions = array of logging conditions            |
;     num_conditions = number of things to test for           |
;  [EBP].active_hook = indicates the hook (either file sys    |
;                      or registry) that got control          |
;  [EBP].active_function = registry function being checked    |
;                                                             |
;                                                             |
;           Exit:                                             |
;                CY set if this one is to be logged           |
;      condition_ptr = set to condition record that matched   |
;   cur_process_hand = handle for current process             |
;    cur_thread_hand = handle for current thread              |
;                                                             |
;All registers saved                                          |
;--------------------------------------------------------------
BeginProc       test_for_log 
                push    eax
                push    ebx
                push    ecx
                push    edx
                push    edi
                push    esi


;
;Get process handle, as it may be part of the logging criteria.  Also,
;will need it later (since it actually points to the process
;database that helps us get to the module name), so save it.
;

                VxdCall VWIN32_GetCurrentProcessHandle

                mov     [ebp].cur_process_hand, eax    ;save it

;                
;same thing with thread handle
;

                VxdCall Get_cur_thread_handle
                mov     [ebp].cur_thread_hand, edi
                mov     esi, [edi].TCB_VMHandle         ;get VM control block

                movzx   ecx, num_conditions
                jcxz    test_for_l900                   ;if have no conditions

                mov     edi, OFFSET32 trap_conditions


test_for_l100:

                bt      [edi].tc_misc_flags, disable_log ;condition disabled?
                jc      test_for_l800

                mov     edx, [edi].tc_category      ;type of hook 
                cmp     edx, [ebp].active_hook
                jne     test_for_l800
               

;handle conditions for registry functions

                cmp     [ebp].active_hook, REG_FUNCTIONS  
                jne     test_for_l110
                mov     ebx, [ebp].active_function
                cmp     ebx, [edi].tc_func_num	
                jne     test_for_l800
                jmp     short test_for_l200

test_for_l110:
                mov     ebx, [ebp].fs_func_num
                cmp     ebx, [edi].tc_func_num	
                jne     test_for_l800

                cmp     [edi].tc_flags, NO_FLAGS_SPECIFIED  
                je      test_for_l150


                mov     edx, [ebp].fs_pioreq    ;get flags field in I/O request
                mov     dl, [edx].ir_flags

                cmp     [edi].tc_flag_mask, 0   ;mask flags first?
                je      test_for_l130
                and     dl, [edi].tc_flag_mask 
test_for_l130:

                cmp     dl, [edi].tc_flags 
                jne     test_for_l800

test_for_l150:

                mov     edx, [edi].tc_drive	
                cmp     edx, -1                 ;all drives?
                je      test_for_l200           ;if so, continue

                cmp     edx, [ebp].fs_drive     ;check for drive match
                jne     test_for_l800           ;if != try next condition

test_for_l200:
                
                lea     edx, [edi].tc_proc_handle
                push    ecx
                mov     ecx, MAX_PROCESSES  

test_for_l250:

                ;get process handle from array of handles to match on 
                mov     eax, [edx]              
                cmp     eax, 0                  ;no process indicated?
                je      test_for_l300

                cmp     eax, -1                 ;all processes
                je      test_for_l450          
                cmp     eax, [ebp].cur_process_hand ;check for process match
                je      test_for_l450          

test_for_l300:
                add     edx, sizeof tc_proc_handle / MAX_PROCESSES
                loop    test_for_l250
                pop     ecx
                jmp     short test_for_l800     ;no match on process, go try another condition record


test_for_l450:
                pop     ecx
                jmp     short test_for_l950

test_for_l800:
                add     edi, (size trap_criteria) ;advance to next condition
                loop    test_for_l100
test_for_l900:
                
                clc                             ;don't log
                jcxz    test_for_l999

test_for_l950:
                stc
                mov     [ebp].condition_ptr, edi
test_for_l999:

                pop     esi
                pop     edi
                pop     edx
                pop     ecx
                pop     ebx
                pop     eax
                ret
EndProc         test_for_log 

;--------------------------------------------------------------
;record_reg_func - Allocate a log record and load it with     |
;                  registry function informaton.              |
;                                                             |
;          Enter:                                             |
;                ESI = Process handle for process doing I/O   |
;                EBP = ptr to hooker function stack frame     |
;                EDI = ptr to VM control block                |
;        list_handle = handle for linked list services        |
;           mod_name = module name (if VM=1) from TDB         |
;                ECX = VM number                              |
;           Exit:                                             |
;                                                             |
;         rec_buffer = ptr to allocated log buffer            |
;     remain_reg_buf = bytes available past fixed area of     |
;                      registry trap buffer                   |
;        reg_buf_ptr = ptr to start of this area              |
;                                                             |
;                                                             |
;                 CY set if can't allocate record (also       |
;                    log_flag=FALSE)                          |
;                                                             |
; No registers saved                                          |
;--------------------------------------------------------------
BeginProc       record_reg_func
                push    esi
                mov     esi, list_handle
                VMMcall List_Allocate           ;return eax=&allocated node
                pop     esi
                jnc     record_reg100
                mov     [ebp].log_flag, FALSE   ;can't log if no record
                ret                             ;return with CY set
record_reg100:

;Load the report buffer record that was just allocated

                mov     [ebp].rec_buffer, eax           ;save address of buffer

;Total fixed length record minus fixed amount of registry function trap record
;will leave the portion of the record available for variable length registry
;keys and data. Pointers in the fixed portion of the registry functions
;trap record will point to this area past the fixed fields.

                mov     [ebp].remain_reg_buf, (TRAP_REC_LEN - size reg_trap_record)
                mov     [ebp].reg_buf_ptr, eax          ;start of buffer
;Ptr to the location within the record where variable length data can
;start.
                add     [ebp].reg_buf_ptr, (size reg_trap_record)

                mov     [eax].rtr_proc_handle, esi      ;process handle

                mov     ecx, [ebp].active_hook          ;report registry function 
                mov     [eax].rtr_category, ecx   

                mov     edx, [ebp].active_function 
                mov     [eax].rtr_function, edx         ;function
                mov     ebx, eax                        ;buffer ptr        

;
;The following fields are used to point to extra allocated buffers in the
;event that the normal trap record can't hold fields and data related
;to the registry function being logged. Initialize to zero for now.
;
                xor     eax, eax
                mov     [ebx].rtr_extra_rec1, eax       ;no extra allocation (yet)
                mov     [ebx].rtr_extra_rec2, eax
                mov     [ebx].rtr_extra_rec3, eax

;Init other fields in registry function trap record as well

                mov     [ebx].rtr_lp_key_name, eax
                mov     [ebx].rtr_lp_subkey, eax
                mov     [ebx].rtr_lp_val_name, eax
                mov     [ebx].rtr_value_type, eax
                mov     [ebx].rtr_lp_value, eax 
                mov     [ebx].rtr_len_value, eax
                mov     [ebx].rtr_lp_prev_value, eax
                mov     [ebx].rtr_len_prev_value, eax

                lea     esi, [ebp].mod_name     ;module name taken from TDB
                
record_reg700:
                lea     edi, [ebx].rtr_program
                mov     ecx, 8                  ;len(module name)
                pushf
                cld
record_reg750:
                lodsb
;
;Note: module names not zero terminated if full 8 chars
;
                stosb
                or      al, al                  ;end?
                jz      record_reg999

                loop    record_reg750
                xor     al, al                  ;ensure module name is
                stosb                           ;terminated
                
record_reg999:
                popf
                clc                             ;successfully logged 
                ret
EndProc         record_reg_func


;--------------------------------------------------------------
;record_io - Allocate a log record and load it.               |
;                                                             |
;          Enter:                                             |
;                ESI = Process handle for process doing I/O   |
;                 DX = IFS function being requested           |
;                EBP = ptr to IFS hooker function stack frame |
;                EDI = ptr to VM control block                |
;                ESI = process handle                         |
;        list_handle = handle for linked list services        |
;           mod_name = module name (if VM=1) from TDB         |
;                ECX = VM number                              |
;           Exit:                                             |
;                                                             |
;         rec_buffer = ptr to allocated log buffer            |
;                                                             |
;                 CY set if can't allocate record (also       |
;                    log_flag=FALSE)                          |
;                                                             |
; No registers saved  (directon flag cleared)                 |
;--------------------------------------------------------------
BeginProc       record_io               
                push    esi
                mov     esi, list_handle
                VMMcall List_Allocate           ;return eax=&allocated node
                pop     esi
                jnc     record_io100
                mov     [ebp].log_flag, FALSE   ;can't log if no record
                ret                             ;return with CY set
record_io100:

;Load the report buffer record that was just allocated
                

                mov     [ebp].rec_buffer, eax           ;save address of buffer
                mov     [eax].tr_proc_handle, esi       ;process handle

                mov     [eax].tr_function, edx          ;function

                mov     [eax].tr_drv_context, ebp       ;context for this function

                mov     ecx, [ebp].active_hook          ;report ifs or reg function 
                mov     [eax].tr_category, ecx   

                mov     ecx, [ebp].condition_ptr

                push    ecx                             ;save condition ptr

                mov     cx, [ecx].tc_misc_flags         ;report back the flags associated
                mov     [eax].tr_drv_miscflag, cx       ;with the condition


                mov     ecx, [ebp].fs_drive	        ;drive number
                movzx   ebx, cx                         ;ensure drive and null
                mov     [eax].tr_drive, ecx         

                mov     ecx, [ebp].fs_res_flags	
                mov     [eax].tr_res_type, ecx         

                mov     ecx, eax
                add     ecx, tr_file1           ;address of path in report buffer
          
                add     bl, ('A'- 1)            ;convert 3 to "C", etc.
                mov     bh, ':'                 ;e.g., have "C:", 0, 0
                mov     dword ptr [ecx], ebx    ;start stored path with drive
                add     ecx, 2                  ;get past drive letter & ":"


                ;see if need to load up file2 also (rename has 2 filenames)

                cmp     dx,  IFSFN_RENAME	
                jne     record_io170
                mov     esi, eax
                add     esi, tr_file2           ;address of 2nd path in report buffer
          
                mov     dword ptr [esi], ebx    ;start stored path with drive
                add     esi, 2                  ;get past drive letter & ":"

record_io170:

                push    eax
                push    edx

                mov     edx, [ebp].fs_pioreq
                mov     bl, [edx].ir_flags
                mov     [eax].tr_ir_flags, bl
                mov     bx, [edx].ir_options 
                mov     [eax].tr_ir_options, bx

;
;Determine if this function uses a filename.  If it does, convert it
;from unicode and save it.  If this is to be a truly generic logger,
;should also look for rename command and store BOTH file names.
;
                mov     eax, [eax].tr_function  ;function 
                sub     eax, IFSFN_CONNECT      ;1st function that uses path
                jb      record_io200            
                bt      path_bit_map, eax       ;consult our bitmap
                jnc     record_io200            ;if no path, skip storing



                push    ecx
                mov     edx, [edx].ir_ppath
                add     edx, pp_elements
                VxdCall UniToBCSPath, <ecx, edx, (MAX_PATH - 1), BCS_OEM >
                pop     ecx
                add     ecx, eax                ;advance by returned length
                mov     word ptr [ecx], 0       ;ensure terminated        


                pop     edx                     ;need to see function number again
                push    edx
                                  
                cmp     dx, IFSFN_RENAME	
                jne     record_io200

                mov     edx, [ebp].fs_pioreq

                push    esi
                mov     edx, [edx].ir_ppath2
                add     edx, pp_elements
                VxdCall UniToBCSPath, <esi, edx, (MAX_PATH - 1), BCS_OEM >
                pop     esi
                add     esi, eax                ;advance by returned length
                mov     word ptr [esi], 0       ;ensure terminated        


record_io200:
                pop     edx                     ;IFS function
                pop     ebx                     ;record buffer ptr (was eax)



                lea     esi, [ebp].mod_name  ;module name taken from TDB
                
record_io700:
                lea     edi, [ebx].tr_program
                mov     ecx, 8                  ;len(module name)
                cld
record_io750:
                lodsb
;
;Note: module names not zero terminated if full 8 chars
;
                stosb
                or      al, al                  ;end?
                jz      record_io999

                loop    record_io750
                xor     al, al                  ;ensure module name is
                stosb                           ;terminated
                
record_io999:

                pop     edi                     ;condition ptr


;Special handling -- if app has requested to see open for write
;operations, it may want to know if the file is being created. Or,
;if file exists, app may want to know the current date/time and size.
;Retrieve this data and store it for reporting back to the application.

                bt      [edi].tc_misc_flags, rep_open_writes
                jnc     record_io1000

                mov     [ebx].tr_create_flag, TRUE
                mov     [ebx].tr_low_size, 0
                mov     [ebx].tr_high_size, 0
                mov     [ebx].tr_low_datetime, 0    
                mov     [ebx].tr_high_datetime, 0   

                lea     esi, [ebx].tr_file1
                mov     edx, OFFSET32 ot_find_data
                mov     ecx, FILE_ATTRIBUTE_EVERYTHING	
                mov     eax, R0_FINDFIRSTFILE
                VxDCall IFSMgr_Ring0_FileIO
                jc      record_io1000           ;it doesn't exist

                mov     [ebx].tr_create_flag, FALSE

                mov     eax, [edx].nFileSizeHigh
                mov     [ebx].tr_high_size, eax

                mov     eax, [edx].nFileSizeLow 
                mov     [ebx].tr_low_size, eax

                mov     eax, [edx].ftLastWriteTime.dwLowDateTime 
                mov     [ebx].tr_low_datetime, eax
                mov     eax, [edx].ftLastWriteTime.dwHighDateTime
                mov     [ebx].tr_high_datetime, eax

record_io1000:

                clc                             ;successfully logged 
                ret
EndProc         record_io                       


;--------------------------------------------------------------
;report_io - Perform callback to application.                 |
;                                                             |
;          Enter:                                             |
;                                                             |
;         rec_buffer = ptr to allocated log buffer            |
;      condition_ptr = set to condition record that matched   |
;       handle_count = number of hkeys currently stored       |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       report_io   
                mov     edx, [ebp].condition_ptr              
                mov     eax, [edx].tc_callback 
                mov     ecx, [edx].tc_thread
                mov     edx, [ebp].rec_buffer

                VxdCall _VWIN32_QueueUserApc <eax, edx, ecx>

                ret
EndProc         report_io               

;--------------------------------------------------------------
;move_hkey_str - Move string containing key into registry     |
;                trap record.                                 |
;                                                             |
;          Enter:                                             |
;               EDX=ptr to location in record that is to      |
;                   be filled in with a pointer.              |
;                                                             |
;               ESI=ptr to string.                            |
;                                                             |
;               ECX=length of string                          |
;                                                             |
;    remain_reg_buf=length of area remaining within           |
;                   record.                                   |
;                                                             |
;       reg_buf_ptr=ptr to this area                          |
;                                                             |
;           Exit:                                             |
;                                                             |
;    remain_reg_buf updated                                   |
;                                                             |
;       reg_buf_ptr updated                                   |
;                                                             |
;--------------------------------------------------------------
BeginProc       move_hkey_str
                cmp     esi, 0                          ;null pointer?
                je      move_hk999

                mov     edi, [ebp].reg_buf_ptr
                mov     [edx], edi                      ;store ptr to string
                add     [ebp].reg_buf_ptr, ecx
                sub     [ebp].remain_reg_buf, ecx
                pushf
                cld
                rep     movsb
                popf
move_hk999:
                ret
EndProc         move_hkey_str



;--------------------------------------------------------------
;move_value- Move value and any previous value into the       |
;            registry trap record.                            |
;                                                             |
;          Enter:                                             |
;               ESI=ptr to value data                         |
;                                                             |
;               ECX=length of data                            |
;                                                             |
;               EBX=ptr to previous value                     |
;                                                             |
;               EAX=length of pevious data                    |
;                                                             |
;               EDX=value type                                |
;                                                             |
;    remain_reg_buf=length of area remaining within           |
;                   record.                                   |
;                                                             |
;       reg_buf_ptr=ptr to this area                          |
;                                                             |
;           Exit:                                             |
;                                                             |
;    remain_reg_buf updated                                   |
;                                                             |
;       reg_buf_ptr updated                                   |
;                                                             |
;--------------------------------------------------------------
BeginProc       move_value
                pushf
                cld
                mov     edi, [ebp].rec_buffer   
                mov     [edi].rtr_value_type, edx   ;store type

                cmp     edx, REG_SZ
                jne     move_v050

;for strings, we'll be adding a terminator, so bump up the length

                inc     ecx                     ;we'll add it for them

move_v050:
                mov     edx, edi                ;ptr to reg record
                mov     edi, [ebp].reg_buf_ptr
                jcxz    move_v400               ;if no value 

                call    check_length
move_v100:
                mov     [edx].rtr_lp_value, edi
                mov     [edx].rtr_len_value, ecx
                sub     [ebp].remain_reg_buf, ecx
                
                rep     movsb                   ;move the value        

                cmp     [edx].rtr_value_type, REG_SZ
                jne     move_v200

;For strings, we're always increasing the length by 1 and sticking a
;terminating null in the logging buffer. However, don't report the
;extra byte -- just report what was actually supplied to the regsetvalue
;function.

                dec     [edx].rtr_len_value
                cmp byte ptr [edi - 1 ], 0     ;is it terminated?
                je      move_v200
                mov     byte ptr [edi - 1], 0
move_v200:

                mov     [ebp].reg_buf_ptr, edi
move_v400:
                
                mov     ecx, eax                ;previous length
                jcxz    move_v500               ;if no value 
                mov     esi, ebx                ;ptr to previous value
                call    check_length

                mov     [edx].rtr_lp_prev_value , edi
                mov     [edx].rtr_len_prev_value, ecx
                sub     [ebp].remain_reg_buf, ecx
                
                rep     movsb                   ;move the value        

                mov     [ebp].reg_buf_ptr, edi

move_v500:

                popf
                ret
EndProc         move_value


;--------------------------------------------------------------
;check_length - Determine if there is room in the trapping    |
;               record for storing the data. If there         |
;               isn't, allocate a big record, reset the       |
;               buffer ptr and remaining length. Also,        |
;               indicate that one of these big records has    |
;               been allocated (by placing the pointer in     |
;               the rtr_extra_rec1  - rtr_extra_rec3          |
;               fields).                                      |
;                                                             |
;          Enter:                                             |
;                                                             |
;               ECX=length of data                            |
;                                                             |
;               EDX=address of main logging record            |
;                                                             |
;                                                             |
;    remain_reg_buf=length of area remaining within           |
;                   record.                                   |
;                                                             |
;       reg_buf_ptr=ptr to this area                          |
;                                                             |
;           Exit:                                             |
;                                                             |
;    remain_reg_buf updated                                   |
;                                                             |
;       reg_buf_ptr updated  (also set EDI = this value)      |
;                                                             |
;    rtr_extra_rec1  - rtr_extra_rec3 potentially updated     |
;                                                             |
;--------------------------------------------------------------
BeginProc       check_length
                cmp     [ebp].remain_reg_buf, ecx
                jae     check_l900

                cmp     [edx].rtr_extra_rec3, 0 ;already used all extended room?
                je      check_l200

                ;Internal error if ever arrive here. Binary registry
                ;values can only be up to 16k. Worst case, we need
                ;space to hold two of these (previous and currently
                ;written values) and some really long value and subkey names.
                int     1
                xor     ecx, ecx
                ret

check_l200:
                push    eax
                push    esi
                mov     esi, ext_list_handle
                VMMcall List_Allocate           ;return eax=&allocated node
                jnc     check_l300
                int     1                       ;linked list services failed
                xor     ecx, ecx                ;can't store the data
                jmp     short check_l800

check_l300:
                cmp     [edx].rtr_extra_rec1, 0
                jne     check_l400
                mov     [edx].rtr_extra_rec1, eax
                jmp     short check_l600
check_l400:
                cmp     [edx].rtr_extra_rec2, 0
                jne     check_l450
                mov     [edx].rtr_extra_rec2, eax
                jmp     short check_l600
check_l450:
                mov     [edx].rtr_extra_rec3, eax
check_l600:

                mov     [ebp].reg_buf_ptr, eax          ;ptr to extended record
                mov     edi, eax                        ;setup in edi also
                mov     [ebp].remain_reg_buf, TRAP_EXTREC_LEN  ;extended record length

check_l800:

                pop     esi
                pop     eax

check_l900:
                ret
EndProc         check_length


;--------------------------------------------------------------
;get_all_hkey - Given an hkey, go back through all the hkeys  |
;               and build the full key path (when a key is    |
;               opened via RegCreateKey or RegOpenKey, the    |
;               key can be relative to currently open keys).  |
;               For example, "Shell Folders" may be opened    |
;               with an open handle to "Software\Microsoft\   |
;               Windows\CurrentVersion\Explorer" which may    |
;               have been opened with with a handle to        |
;               "HKEY_CURRENT_USER".                          |
;                                                             |
;          Enter:                                             |
;               EAX=hkey                                      |
;                                                             |
;           Exit:                                             |
;               ESI=ptr to string                             |
;               ECX=string length (including terminating 0)   |
;               CY - if can't find hkey                       |
;                                                             |
; No registers saved                                          |
;                                                             |
;--------------------------------------------------------------
BeginProc       get_all_hkey
                pushf
                cld
                mov     [ebp].key_elements, 0

get_all_h100:
                push    eax                     ;save hkey being looked up
                call    look_up_hkey 
                pop     ebx                     ;hkey looked up (was eax)
                jc      get_all_h500
                push    esi                     ;save ptr to key's name
                push    ecx                     ;and its length
                inc     [ebp].key_elements

;Note: this check shouldn't be necessary. But, if the system ever had
;      some problem where a duplicate handle somehow managed to exist,
;      it's pretty scary to think that there could be a cross link
;      in these tables such that we'd just keep pushing values
;      in a loop forever. So....

                cmp     eax, ebx                ;the same???!!!!!!!!!!!!
                jne     get_all_h200            ;good
                xor     eax, eax                ;emergency
get_all_h200:

                cmp     eax, 0                  ;at top level?
                jne     get_all_h100            ;if not, go get next element

get_all_h500:
                mov     edi, OFFSET32 work_key_str 
                mov     byte ptr [edi], 0       ;nothing in there yet
                xor     edx, edx
                cmp     [ebp].key_elements, 0   ;no key string?
                ja      get_all_h600
                popf
                stc
                ret                             ;no keys found!
get_all_h600:
                pop     ecx                     ;get length of key name
                pop     esi                     ;and pointer to it
                cmp     byte ptr [esi], 0       ;sub key was null?
                je      get_all_h650

                dec     ecx                     ;don't count terminating null        
                add     edx, ecx                ;keep track total length
                rep     movsb
get_all_h650:
                dec     [ebp].key_elements
                jz      get_all_h700
                cmp     byte ptr [edi -1], '\'
                je      get_all_h600
                inc     edx
                mov     byte ptr [edi], '\'
                inc     edi

                jmp     short get_all_h600
get_all_h700:
                sub     al, al
                stosb                           ;terminate the string
                inc     edx                     ;count it
                mov     esi, OFFSET32 work_key_str 
                mov     ecx, edx                ;total length

                popf
                clc
                ret
EndProc         get_all_hkey


;--------------------------------------------------------------
;look_up_hkey - Given an hkey, find and return its            |
;               corresponding string. If not found in table   |
;               of currently open keys, look in table of      |
;               predefined handles (HKEY_CLASSES_ROOT, etc.)  |
;                                                             |
;          Enter:                                             |
;               EAX=hkey                                      |
;      handle_table=ptr to lookup table                       |
;                                                             |
;           Exit:                                             |
;               ESI=ptr to string                             |
;               ECX=string length (including terminating 0)   |
;               EAX=Open key referenced when the hkey was     |
;                   assigned during open or create (0 if      |
;                   already at top level)                     |
;               CY - if can't find hkey                       |
;                                                             |
; No registers saved                                          |
;                                                             |
;--------------------------------------------------------------
BeginProc       look_up_hkey
                movzx   ecx, handle_count  
                jcxz    look_up_h500
                mov     ebx, OFFSET32 handle_table  
                jmp     short look_up_h150

look_up_h100:
                add     ebx, size hkey_track
look_up_h150:
                cmp     [ebx].ht_avail, FALSE   ;free spot
                je      look_up_h100
                cmp     eax, [ebx].ht_hkey      ;does hkey match?
                jne     look_up_h200
                lea     esi, [ebx].ht_key_name
;return in eax, the hkey of the open key that was referenced when this key
;was opened.
                mov     eax, [ebx].ht_ohkey    
                jmp     short look_up_h800
look_up_h200:
                loop    look_up_h100
look_up_h500:
                mov     ecx, PREDEFINED_ENTRIES
                mov     ebx, OFFSET32 predefined_table  
look_up_h600:
                cmp     eax, [ebx].predef_key                     
                jne     look_up_h650
                mov     esi, [ebx].predef_key_str             
                xor     eax, eax                        ;at top level
                jmp     short look_up_h800

look_up_h650:
                add     ebx, size predefined_struc
                loop    look_up_h600
                stc
                ret
look_up_h800:
                mov     ecx, esi
look_up_h850:
                cmp     byte ptr [ecx], 0       ;need length, look for terminating null
                je      look_up_h890
                inc     ecx
                jmp     short look_up_h850

look_up_h890:
                inc     ecx                     ;want 0 at end included in length
                sub     ecx, esi                ;ecx = length, esi = ptr to string
                clc
                ret
EndProc         look_up_hkey

;--------------------------------------------------------------
;store_hkey - Must save hkey and the string for the key.      |
;             This is called by CtOpenKey and CtCreateKey.    |
;             Values are still on the stack from calls to     |
;             the orginal functions from our hook. Retrieve   |
;             values from the stack and save them.            |
;                                                             |
;          Enter:                                             |
;                Stack looks like open_key_parms struc        |
;                                                             |
;     handle_count = number of hkeys currently stored         |
;                                                             |
;           Exit:                                             |
;     handle_count is updated                                 |
;                                                             |
;               CY - if can't store                           |
;                                                             |
;--------------------------------------------------------------
BeginProc       store_hkey

                cmp     handle_count, MAX_HANDLES_TO_TRACK  ;is there room?                         
                jb      store_hk050

                stc
                ret

store_hk050:

                push    ebp
                mov     ebp, esp
                pusha
                mov     esi, [ebp].ok_SubKey 

                movzx   ecx, handle_count  
                inc     ecx
                mov     ebx, OFFSET32 handle_table  

store_hk100:
                cmp     [ebx].ht_avail, 0       ;free spot
                je      store_hk500

                add     ebx, size hkey_track
                loop    store_hk100

                stc
                int     1                       ;should never get here
                jmp     short store_hk999       
                

store_hk500:
                pushf
                lea     edi, [ebx].ht_key_name    
                mov     ecx, MAX_VMM_REG_KEY_LEN
                cld
                cmp     esi, 0                  ;null pointer?
                je      store_hk650             ;if so, go store 0

store_hk600:
                lodsb
                or      al, al
                jz      store_hk700
                stosb
                loop    store_hk600
store_hk650:
                sub     al, al                  

store_hk700:
                stosb                           ;store terminator
                popf

;this parm can be a handle to one of the predefined keys or an hkey

                mov     eax, [ebp].ok_hKey  
                mov     [ebx].ht_ohkey, eax     ;save it

                mov     edx, [ebp].ok_phKey     ;ptr to key handle
                mov     edx, [edx]              ;get actual hkey value
                mov     [ebx].ht_hkey, edx   
                mov     [ebx].ht_avail, TRUE    ;this spot is now taken
                inc     handle_count  

                clc

store_hk999:

                popa

                pop     ebp
                ret
EndProc         store_hkey



;--------------------------------------------------------------
;unstore_hkey - A key is being closed. Remove it from our     |
;               table of open keys.                           |
;                                                             |
;          Enter:                                             |
;              EAX = hkey being closed                        |
;                                                             |
;     handle_count = number of hkeys currently stored         |
;                                                             |
;           Exit:                                             |
;                                                             |
;     handle_count is updated                                 |
;                                                             |
;               EBX = address of key description              |
;               ECX = length of key description (including    |
;                     terminator)                             |
;               EDX = handle that was open when this key      |
;                     was originally opened. This may be      |
;                     a built-in handle.                      |
;                                                             |
;                                                             |
;  If key is not found (e.g., if user is closing a built-in   |
;  handle that was never opened) ECX=0                        |
;                                                             |
;     All other registers saved                               |
;                                                             |
;--------------------------------------------------------------
BeginProc       unstore_hkey
                push    esi
                movzx   ecx, handle_count  
                jcxz    unstore_hk999
                mov     ebx, OFFSET32 handle_table  
                jmp     short unstore_hk150

unstore_hk100:
                add     ebx, size hkey_track
unstore_hk150:
                cmp     [ebx].ht_avail, FALSE   ;free spot
                je      unstore_hk100
                cmp     eax, [ebx].ht_hkey      ;does hkey match?
                jne     unstore_hk200
                mov     [ebx].ht_avail, FALSE   ;free up this spot
                dec     handle_count  
                jmp     short unstore_hk800

unstore_hk200:
                loop    unstore_hk100
                jmp     short unstore_hk999
unstore_hk800:
                mov     edx, [ebx].ht_ohkey      ;get previous open key handle
                lea     ebx, [ebx].ht_key_name   
                mov     esi, ebx
                xor     ecx, ecx
                dec     esi
unstore_hk810:
                inc     esi
                inc     ecx                     ;length count 
                cmp     byte ptr [esi], 0
                jne     short unstore_hk810
                

unstore_hk999:
                pop     esi
                ret
EndProc         unstore_hkey


;--------------------------------------------------------------
;unstore_dependents - when a registry is closed, it's possible|
;                     there may be references to that handle  |
;                     in our tables of open registry keys.    |
;                     Check for this and remove.              |
;                                                             |
;          Enter:                                             |
;               EAX = handle being closed                     |
;               EBX = address of key description corresponding|
;                     to key whose handle is being closed     |
;               ECX = length of key description (including    |
;                     terminator)                             |
;                                                             |
;               EDX = handle that was open (may be a built    |
;                     in handle) when key was opened          |
;                                                             |
;                                                             |
;     handle_count = number of hkeys currently stored         |
;                                                             |
;           Exit:                                             |
;                                                             |
;     entries in handle_table may be updated.                 |
;                                                             |
;--------------------------------------------------------------
BeginProc       unstore_dependents  
                pushad
                mov     edi, ecx                ;length of description        
                movzx   ecx, handle_count
                jcxz    unstore_d_800

                mov     esi, ebx                ;address of description

                mov     ebx, OFFSET32 handle_table  
                jmp     short unstore_d_200

unstore_d_100:
                add     ebx, size hkey_track

unstore_d_200:
                cmp     [ebx].ht_avail, FALSE   ;free?
                je      unstore_d_100

                cmp     eax, [ebx].ht_ohkey     ;open handle same?
                jne     unstore_d_500


;replace reference to open handle with handle of key that was
;open at the next higher level


                mov     [ebx].ht_ohkey, edx     
                call    adjust_string
unstore_d_500:
                loop    unstore_d_100


unstore_d_800:

                popad
                ret
EndProc         unstore_dependents  



BeginProc       adjust_string
                push    eax
                push    ecx
                push    esi
                push    edi
                pushf
                cld
                                        
;see if there's room to put in previous element in registry path

                push    ebx

                lea     ebx, [ebx].ht_key_name   
                xor     ecx, ecx
                dec     ebx
adjust_s100:
                inc     ebx
                inc     ecx
                cmp     byte ptr [ebx], 0
                jne     adjust_s100

adjust_s200:
                pop     ebx

;Since key that was open when this key was opened is going away, we
;want to change description of this key to have description of
;previously open key propended to it. Must see if it will fit.



                mov     eax, edi                ;length previous
                add     eax, ecx                ;plus this one
                inc     eax                     ;count '\' that we'll put in too
                cmp     eax, MAX_VMM_REG_KEY_LEN+1 
                ja      adjust_s300

                push    ecx                     ;save length one in table
                mov     eax, edi                ;save length previous

                push    esi                     ;save previous string address
                lea     esi, [ebx].ht_key_name   
                mov     edi, OFFSET32 work_key_str 
                rep movsb   
                pop     esi                     ;address of previous

                mov     ecx, eax                ;length previous
                dec     ecx                     ;don't want terminator        
                lea     edi, [ebx].ht_key_name   
                rep     movsb
                mov     al, '\'
                stosb

;get back length (including terminator) of description of key that's being deleted

                pop     ecx            
                mov     esi, OFFSET32 work_key_str 
                rep     movsb

adjust_s300:
                
                popf
                pop     edi
                pop     esi

                pop     ecx
                pop     eax
                ret
EndProc         adjust_string

;--------------------------------------------------------------
;CtOpenKey -                                                  |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtOpenKey, HOOK_PROC, OpenKey, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp


ctok_100:
                push    [ebp + LOCAL_VAR_SIZE ].ok_phKey      
                push    [ebp + LOCAL_VAR_SIZE ].ok_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].ok_hKey       
                call    dword ptr reg_func_table.reg_old_handler
                cmp     eax, ERROR_SUCCESS
                jne     ctok_900

;Parms are still on stack. Go store hkey, and key info

                call    store_hkey

ctok_900:
                add     esp, OPEN_KEY_PARMS             ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                ret
EndProc         CtOpenKey               



;--------------------------------------------------------------
;CtCloseKey -                                                 |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtCloseKey, HOOK_PROC, CloseKey, LOCKED
		push	ebp
		mov	ebp, esp

                push    [ebp].ck_hKey       
                call    dword ptr CloseKey
                cmp     eax, ERROR_SUCCESS
                jne     ctclk_900

;Parms are still on stack. Go remove closed key from table of open keys

                push    eax
                push    ebx
                push    ecx
                push    edx
                mov     eax, [ebp].ck_hKey   
                call    unstore_hkey            ;take key out of our table
                jcxz    ctclk_800               ;if key wasn't in the table
                call    unstore_dependents      ;remove any references to key
ctclk_800:
                pop     edx
                pop     ecx
                pop     ebx
                pop     eax

ctclk_900:
                add     esp, CLOSE_KEY_PARMS             ;take off parm
		pop	ebp                

                ret
EndProc         CtCloseKey               

;--------------------------------------------------------------
;CtCreateKey -                                                |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtCreateKey, HOOK_PROC, CreateKey, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp

                mov     [ebp].log_flag, TRUE             ;default to logging this request

ctck_100:

;First, check to see if this key already exists. Application may be
;using the RegCreateKey function just to open an existing key. We only
;want to report those calls that result in key creation (unless client
;sets rep_all_creates in tc_misc_flags field of logging conditions).


                push    OFFSET32 work_key               ;use our own work phkey
                push    [ebp + LOCAL_VAR_SIZE ].ok_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].ok_hKey       

                call    dword ptr reg_func_table.reg_old_handler
                add     esp, OPEN_KEY_PARMS             ;take off parms
                cmp     eax, ERROR_SUCCESS
                jne     ctck_200
                mov     eax, work_key
                push    eax
                call    dword ptr CloseKey
                add     esp, CLOSE_KEY_PARMS             ;take off parm
                mov     [ebp].log_flag, FALSE            ;don't want existing keys

ctck_200:

                push    [ebp + LOCAL_VAR_SIZE ].ok_phKey      
                push    [ebp + LOCAL_VAR_SIZE ].ok_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].ok_hKey       
                call    dword ptr CreateKey
                cmp     eax, ERROR_SUCCESS
                jne     ctck_900

;Parms are still on stack. Go store hkey and key info.


                call    store_hkey

;Now, check to see if this function meets logging conditions. If so, log
;the information and report it to the client.

                mov     [ebp].active_hook, REG_FUNCTIONS ;got control on Registry function hook
                mov     [ebp].active_function, REG_CREATE_KEY  

                call    test_for_log                     ;see if we log this
                jnc     ctck_900                         ;if not, go pass through


                pusha

;
;See if in the trapping conditions, client has requested that all
;create key functions be logged regardless of whether the key 
;already exists -- and this really just and open call
;
                mov     edi, [ebp].condition_ptr
                bt      [edi].tc_misc_flags, rep_all_creates
                jc      ctck_600                        ;log all calls

                cmp     [ebp].log_flag, TRUE             ;actually a create?
                jne     ctck_800


ctck_600:

                call    get_prog_info                   ;get process handle and program name
                call    record_reg_func                 ;fill record to send to client
                jc      ctck_800                        ;couldn't allocate for some unlikely reason
                mov     eax, [ebp + LOCAL_VAR_SIZE ].ok_hKey      
                        
                call    get_all_hkey
                jc      ctck_750

                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_key_name 
                call    move_hkey_str

                mov     edx, [ebp + LOCAL_VAR_SIZE ].ok_phKey      
                mov     eax, [edx]
                call    look_up_hkey
                jc      ctck_750


                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_subkey 
                call    move_hkey_str

ctck_750:
                call    report_io                       ;report record to client

ctck_800:
                popa
ctck_900:
                add     esp, OPEN_KEY_PARMS             ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                ret
EndProc         CtCreateKey               

;--------------------------------------------------------------
;CtDeleteKey -                                                |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtDeleteKey, HOOK_PROC, DeleteKey, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp

                mov     [ebp].log_flag, FALSE            ;default to not logging this function

                push    [ebp + LOCAL_VAR_SIZE ].dk_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].dk_hKey       
                call    dword ptr DeleteKey
                cmp     eax, ERROR_SUCCESS
                jne     ctdk_900

                mov     [ebp].active_hook, REG_FUNCTIONS ;got control on Registry function hook
                mov     [ebp].active_function, REG_DELETE_KEY  

                call    test_for_log                     ;see if we log this
                jnc     ctdk_900                         ;if not, go pass through


                pusha

ctdk_600:

                call    get_prog_info                   ;get process handle and program name
                call    record_reg_func                 ;fill record to send to client
                jc      ctdk_800                        ;couldn't allocate for some unlikely reason
                mov     eax, [ebp + LOCAL_VAR_SIZE ].dk_hKey      
                        
                call    get_all_hkey
                jc      ctdk_750

                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_key_name 
                call    move_hkey_str

                mov     esi, [ebp + LOCAL_VAR_SIZE ].dk_SubKey  
                cmp     esi, 0                  ;null pointer?
                je      ctdk_750                ;if so, nothing to move
                push    esi
                xor     ecx, ecx
ctdk_700:
                inc     ecx
                cmp     byte ptr [esi], 0
                je      ctdk_720
                cmp     ecx, MAX_VMM_REG_KEY_LEN+1      ;only a bad value would ever hit this
                je      ctdk_720
                inc     esi
                jmp     short ctdk_700

ctdk_720:
                pop     esi
                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_subkey 
                call    move_hkey_str

ctdk_750:
                call    report_io                       ;report record to client

ctdk_800:
                popa
ctdk_900:
                add     esp, DELETE_KEY_PARMS           ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                ret
EndProc         CtDeleteKey               


;--------------------------------------------------------------
;CtQueryValue  -                                              |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc      CtQueryValue, HOOK_PROC, QueryValue, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp


                push    [ebp + LOCAL_VAR_SIZE ].qv_lplen 
                push    [ebp + LOCAL_VAR_SIZE ].qv_lpdata
                push    [ebp + LOCAL_VAR_SIZE ].qv_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].qv_hKey       
                call    dword ptr QueryValue
                add     esp, QUERY_VALUE_PARMS              ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE                 ;take off our vars

                ret
EndProc         CtQueryValue

;--------------------------------------------------------------
;CtQueryValueEx  -                                            |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc      CtQueryValueEx, HOOK_PROC, QueryValueEx, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp


                push    [ebp + LOCAL_VAR_SIZE ].qvex_lplen 
                push    [ebp + LOCAL_VAR_SIZE ].qvex_lpdata
                push    [ebp + LOCAL_VAR_SIZE ].qvex_lptype  
                push    [ebp + LOCAL_VAR_SIZE ].qvex_lpdw_res   
                push    [ebp + LOCAL_VAR_SIZE ].qvex_ValueName
                push    [ebp + LOCAL_VAR_SIZE ].qvex_hKey       
                call    dword ptr QueryValueEx
                add     esp, QUERY_VALUE_EXPARMS        ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                ret
EndProc         CtQueryValueEx


;--------------------------------------------------------------
;CtSetValue  -                                                |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtSetValue, HOOK_PROC, SetValue, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp


ctsv_100:

;First, check to see if this value already exists. If it does, we want
;to retrieve and store the existing value.

                mov     work_data, 0                    ;default to no existing value

;
;Default to this being a change. If value isn't found to exist (by using
;the RegQueryValue function), we record this call as a REG_CREATE_VALUE.
;
                mov     [ebp].active_function, REG_CHANGE_VALUE

                mov     work_length, size work_data

                push    OFFSET32 work_length
                push    OFFSET32 work_data  
                push    [ebp + LOCAL_VAR_SIZE ].sv_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].sv_hKey       

                call    dword ptr QueryValue  
                add     esp, QUERY_VALUE_PARMS          ;take off parms
                cmp     eax, ERROR_SUCCESS
                je      ctsv_400                        ;Value exists
                mov     work_length, 0         

;
;Value doesn't exist yet -- classify this call as a "create" operation
;

                mov     [ebp].active_function, REG_CREATE_VALUE

ctsv_400:


                push    [ebp + LOCAL_VAR_SIZE ].sv_len    
                push    [ebp + LOCAL_VAR_SIZE ].sv_lpdata 
                push    [ebp + LOCAL_VAR_SIZE ].sv_Type  
                push    [ebp + LOCAL_VAR_SIZE ].sv_SubKey  
                push    [ebp + LOCAL_VAR_SIZE ].sv_hKey       
                call    dword ptr SetValue  
                cmp     eax, ERROR_SUCCESS
                jne     ctsv_900

;Now, check to see if this function meets logging conditions. If so, log
;the information and report it to the client.

                mov     [ebp].active_hook, REG_FUNCTIONS ;got control on registry function hook

                call    test_for_log                     ;see if we log this
                jnc     ctsv_900                         ;if not, exit


                pusha

ctsv_600:

                call    get_prog_info                   ;get process handle and program name
                call    record_reg_func                 ;fill record to send to client
                jc      ctsv_800                        ;couldn't allocate for some unlikely reason

                mov     eax, [ebp + LOCAL_VAR_SIZE ].sv_hKey      
                        
                call    get_all_hkey
                jc      ctsv_750

                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_key_name 
                call    move_hkey_str

                mov     esi, [ebp + LOCAL_VAR_SIZE ].sv_SubKey  
                cmp     esi, 0                          ;null pointer?
                je      ctsv_740                        ;if so, nothing to move
                push    esi
                xor     ecx, ecx
ctsv_700:
                inc     ecx
                cmp     byte ptr [esi], 0
                je      ctsv_720
                cmp     ecx, MAX_VMM_REG_KEY_LEN+1      ;only a bad value would ever hit this
                je      ctsv_720
                inc     esi
                jmp     short ctsv_700

ctsv_720:
                pop     esi
                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_subkey 
                call    move_hkey_str
ctsv_740:

;
;Get type, value, length, previous value, and length and go store
;


                mov     edx, [ebp + LOCAL_VAR_SIZE ].sv_Type  
                mov     esi, [ebp + LOCAL_VAR_SIZE ].sv_lpdata 
                mov     ecx, [ebp + LOCAL_VAR_SIZE ].sv_len    

                mov     ebx, OFFSET32 work_data
                mov     eax, work_length


                call    move_value


ctsv_750:

                call    report_io                       ;report record to client

ctsv_800:
                popa
ctsv_900:
                add     esp, SET_VALUE_PARMS            ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                ret
EndProc         CtSetValue




;--------------------------------------------------------------
;CtSetValueEx  -                                              |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtSetValueEx, HOOK_PROC, SetValueEx, LOCKED
                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp


ctsvex_100:

;First, check to see if this value already exists. If it does, we want
;to retrieve and store the existing value.

                mov     work_data, 0                    ;default to no existing value

;
;Default to this being a change. If value isn't found to exist (by using
;the RegQueryValueEx function), we record this call as a REG_CREATE_VALUE.
;
                mov     [ebp].active_function, REG_CHANGE_VALUE

                mov     work_length, size work_data

                push    OFFSET32 work_length
                push    OFFSET32 work_data  
                push    OFFSET32 work_type
                push    work_res_zero                      ;zero (reserved field)
                push    [ebp + LOCAL_VAR_SIZE ].svex_ValueName   
                push    [ebp + LOCAL_VAR_SIZE ].svex_hKey       

                call    dword ptr QueryValueEx
                add     esp, QUERY_VALUE_EXPARMS          ;take off parms
                cmp     eax, ERROR_SUCCESS
                je      ctsvex_400                        ;Value exists
                mov     work_length, 0         

;
;Value doesn't exist yet -- classify this call as a "create" operation
;

                mov     [ebp].active_function, REG_CREATE_VALUE

ctsvex_400:


                push    [ebp + LOCAL_VAR_SIZE ].svex_lplen    
                push    [ebp + LOCAL_VAR_SIZE ].svex_lpdata 
                push    [ebp + LOCAL_VAR_SIZE ].svex_Type  
                push    [ebp + LOCAL_VAR_SIZE ].svex_dw_res    
                push    [ebp + LOCAL_VAR_SIZE ].svex_ValueName   
                push    [ebp + LOCAL_VAR_SIZE ].svex_hKey       
                call    dword ptr SetValueEx
                cmp     eax, ERROR_SUCCESS
                jne     ctsvex_900

;Now, check to see if this function meets logging conditions. If so, log
;the information and report it to the client.

                mov     [ebp].active_hook, REG_FUNCTIONS ;got control on Registry function hook

                call    test_for_log                     ;see if we log this
                jnc     ctsvex_900                       ;if not, go pass through


                pusha

ctsvex_600:

                call    get_prog_info                   ;get process handle and program name
                call    record_reg_func                 ;fill record to send to client
                jc      ctsvex_800                      ;couldn't allocate for some unlikely reason

                mov     eax, [ebp + LOCAL_VAR_SIZE ].svex_hKey      
                        
                call    get_all_hkey
                jc      ctsvex_750

                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_key_name 
                call    move_hkey_str
                mov     esi, [ebp + LOCAL_VAR_SIZE ].svex_ValueName   
                cmp     esi, 0                          ;null pointer?
                je      ctsvex_740                      ;if so, nothing to move
                push    esi
                xor     ecx, ecx
ctsvex_700:
                inc     ecx
                cmp     byte ptr [esi], 0
                je      ctsvex_720
                cmp     ecx, MAX_VMM_REG_KEY_LEN+1      ;only a bad value would even hit this
                je      ctsvex_720
                inc     esi
                jmp     short ctsvex_700

ctsvex_720:
                pop     esi
                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_val_name 
                call    move_hkey_str
ctsvex_740:

;
;Get type, value, length, previous value, and length and go store
;

                mov     edx, [ebp + LOCAL_VAR_SIZE ].svex_Type  
                mov     esi, [ebp + LOCAL_VAR_SIZE ].svex_lpdata 
                mov     ecx, [ebp + LOCAL_VAR_SIZE ].svex_lplen    

                mov     ebx, OFFSET32 work_data
                mov     eax, work_length

                call    move_value


ctsvex_750:

                call    report_io                       ;report record to client

ctsvex_800:
                popa
ctsvex_900:
                add     esp, SET_VALUE_EXPARMS          ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars

                ret
EndProc         CtSetValueEx

;--------------------------------------------------------------
;CtDeleteValue  -                                             |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       CtDeleteValue, HOOK_PROC, DeleteValue, LOCKED
                cmp     reg_busy, 0
                je      ctdev_050
                jmp     dword ptr DeleteValue  

ctdev_050:
                inc     reg_busy

                sub     esp, LOCAL_VAR_SIZE 
		push	ebp
		mov	ebp, esp

ctdv_100:

;First, check to see if this value already exists. If it does, we want
;to retrieve and store the existing value.

                mov     work_data, 0                    ;default to no existing value

                mov     work_length, size work_data


                push    OFFSET32 work_length
                push    OFFSET32 work_data  
                push    OFFSET32 work_type
                push    work_res_zero                      ;zero (reserved field)
                push    [ebp + LOCAL_VAR_SIZE ].dv_ValueName   
                push    [ebp + LOCAL_VAR_SIZE ].dv_hKey       

                call    dword ptr QueryValueEx  
                add     esp, QUERY_VALUE_EXPARMS          ;take off parms

                push    [ebp + LOCAL_VAR_SIZE ].dv_ValueName   
                push    [ebp + LOCAL_VAR_SIZE ].dv_hKey       
                call    dword ptr DeleteValue  
                cmp     eax, ERROR_SUCCESS
                jne     ctdv_900

;Now, check to see if this function meets logging conditions. If so, log
;the information and report it to the client.

                mov     [ebp].active_hook, REG_FUNCTIONS ;got control on Registry function hook
                mov     [ebp].active_function, REG_DELETE_VALUE

                call    test_for_log                     ;see if we log this
                jnc     ctdv_900                         ;if not, go pass through

                pusha

ctdv_600:

                call    get_prog_info                   ;get process handle and program name
                call    record_reg_func                 ;fill record to send to client
                jc      ctdv_800                        ;couldn't allocate for some unlikely reason

                mov     eax, [ebp + LOCAL_VAR_SIZE ].dv_hKey      
                        
                call    get_all_hkey
                jc      ctdv_750

                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_key_name 
                call    move_hkey_str

                mov     esi, [ebp + LOCAL_VAR_SIZE ].dv_ValueName   
                cmp     esi, 0                          ;null pointer?
                je      ctdv_740                        ;if so, nothing to move
                push    esi
                xor     ecx, ecx
ctdv_700:
                inc     ecx
                cmp     byte ptr [esi], 0
                je      ctdv_720
                cmp     ecx, MAX_VMM_REG_KEY_LEN+1      ;only a bad value would even hit this
                je      ctdv_720
                inc     esi
                jmp     short ctdv_700

ctdv_720:
                pop     esi
                mov     ebx, [ebp].rec_buffer 
                lea     edx, [ebx].rtr_lp_val_name 
                call    move_hkey_str
ctdv_740:

;
;Get type, value, length, previous value, and length and go store
;

                mov     edx, work_type

                xor     ecx, ecx                        ;zero length -- no present value

;previous value prior to this delete

                mov     ebx, OFFSET32 work_data
                mov     eax, work_length

                call    move_value

ctdv_750:

                call    report_io                       ;report record to client

ctdv_800:
                popa
ctdv_900:
                add     esp, DELETE_VALUE_PARMS         ;take off parms
		pop	ebp                
                add     esp, LOCAL_VAR_SIZE             ;take off our vars
                dec     reg_busy

                ret
EndProc         CtDeleteValue

VXD_LOCKED_CODE_ENDS

;---------------------------------------------------------------
;               Pageable Code                                  |
;---------------------------------------------------------------
VXD_PAGEABLE_CODE_SEG

;--------------------------------------------------------------
;ctioctl - Device control procedure.  Dispatches              |
;             messages sent to this VxD.                      |
;                                                             |
;          Enter:                                             |
;                 si = ptr to IOCTL block                     |
;                                                             |
;           Exit:                                             |
;                eax=error code (success=0)                   |
;                 CY - If failure in handling message         |
;                                                             |
;--------------------------------------------------------------

BeginProc 	ctioctl
		mov	ecx, [esi].dwIoControlCode 	;get ioctl code
		xor	eax, eax			;default to success
	        cmp     ecx, -1                         ;close handle?
        	je      ctioctl_999     		;if so, exit ok
ctioctrl_100:
		cmp	ecx, SERVICE_TABLE_SIZE		;<=max services?
		jbe	ctioctrl_500 			;if so, continue   
		mov	eax, INVALID_IOCTL              ;else report error
		stc
		ret

ctioctrl_500:
	        cld
		call    Service_Table[ecx*4]		;index into table
ctioctl_999:     
		ret
EndProc		ctioctl

;--------------------------------------------------------------
;ctdioc_getversion - Device IO control get version call.  This|
;                  is issued when VxD is being dynamically    |
;                  loaded.  Simply return success.            |
;                                                             |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;           Exit:                                             |
;                eax = (success)                              |
;                      NC                                     |
;--------------------------------------------------------------
BeginProc	ctdioc_getversion		
		xor	eax, eax
		ret
EndProc		ctdioc_getversion		


;--------------------------------------------------------------
;getversion - Get version call from application interfacing   |
;             with this VxD.  Return version of this VxD      |
;             to the application.                             |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;           Exit:                                             |
;                eax = 0 (success)                            |
;                      NC                                     |
;--------------------------------------------------------------
BeginProc	getversion		
		mov	ebx, [esi].lpvOutBuffer		;get ptr to out buffer
		mov	word ptr [ebx], ((CTMAJOR_VERSION shl 8 ) OR CTMINOR_VERSION)
		mov	ebx, [esi].lpcbBytesReturned
		mov	dword ptr [ebx], 2              ;2 bytes returned
		xor	eax, eax
		ret				
EndProc		getversion		


;--------------------------------------------------------------
;get_obfuscator - Retrieve from client application the        |
;                 obfuscated process ID for the client app.   |
;                 Issue the VWIN32 GetCurrentProcessID call   |
;                 and get the process ID that unobfuscated.   |
;                 XOR the two and return the actual           |
;                 resultant obfuscator.                       |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;           Exit:                                             |
;                eax = 0 (success)                            |
;                      NC                                     |
;--------------------------------------------------------------
BeginProc       get_obfuscator
		mov	edx, [esi].lpvInBuffer	;get ptr to app's process ID
                mov     edx, [edx]

                VxdCall VWIN32_GetCurrentProcessHandle

                xor     eax, edx                        ;xor raw ptr with obfuscated ID

		mov	ebx, [esi].lpvOutBuffer		;get ptr to out buffer
		mov	[ebx], eax                      ;return the obfuscator
		mov	ebx, [esi].lpcbBytesReturned
		mov	dword ptr [ebx], 2              ;2 bytes returned
		xor	eax, eax
		ret				
EndProc         get_obfuscator

;--------------------------------------------------------------
;register_callback - Receive callback address and logging     |
;                    conditions from application.             |
;                                                             |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;                                                             |
;           Exit:                                             |
;                                                             |
;     num_conditions = incremented (if haven't reused a       |
;                      previous logging condition array       |
;                      element).                              |
;                                                             |
; trap_conditions[n] = new array entry holding new logging    |
;                      conditions and callback address        |
;                                                             |
;                eax = 0 (success)                            |
;                      NC                                     |
;                                                             |
;                eax = MAX_COND_EXCEEDED if max logging       |
;                      conditions exceeded.                   |
;                      CY                                     |
;                                                             |
;--------------------------------------------------------------
BeginProc       register_callback
                push    ebp                             ;use for number of conditions

                movzx   ebp, num_conditions

                cmp     ebp, MAX_TRAP_FUNCTIONS         ;have room for it?
                jne     trap_cr300                      ;if so, continue
;
;Otherwise, try to find an entry that has been used by a program
;that used it, disabled it, and exited.  
;

                mov     edi, OFFSET trap_conditions
                mov     ecx, ebp      
                xor     ebp, ebp                        ;condition counter                  
trap_cr100:
                bt      [edi].tc_misc_flags, app_exited ;one we can reuse?
                jc      trap_cr300                      ;if so, go use it
                add     edi, (size trap_criteria) ;advance to next condition
                inc     ebp
                loop    trap_cr100

                pop     ebp
                jmp     short trap_cr999

                
trap_cr300:
                push    ebx
                push    ecx
                push    edx
                push    esi
                push    edi

	        mov	edi, [esi].lpcbBytesReturned  ;get ptr to return count

                mov     dword ptr [edi], 4      ;give back 4 bytes

                mov   eax, ebp                  ;entry number for condition
;
;Pass back a "handle" for this conditional logging and callback information
;to the application (application can use this later via an IOCTL if it wants
;to change the logging criteria).
;
	        mov	edi, [esi].lpvOutBuffer	 ;get ptr to return buffer
                mov     [edi], eax              ;return "handle" for condition

                mov     ecx, [esi].cbInBuffer	 ;length of callback info
		mov	esi, [esi].lpvInBuffer	 ;get ptr to callback info
                mov     ebx, (size trap_criteria)
                mul     ebx                      ;compute index into conditions
                mov     edi, OFFSET trap_conditions
                add     edi, eax                ;get to desired array entry
                mov     ebx, edi                


;Put in the thread ID.  Do this first because once the conditions are
;moved into our array, it's potentially available for comparison with
;any file system functions that may arrive at our hook.

                push    edi                     
                ;ensure that we have thread handle
                VMMCall Get_Cur_Thread_Handle
                mov     [ebx].tc_thread, edi    ;save thread handle      
                pop     edi

                cmp     ecx, LEN_USER_TRAPDAT   ;verify app passes ok length
                jbe     trap_cr500
                mov     ecx, LEN_USER_TRAPDAT
trap_cr500:
                pushf
                cld
                rep     movsb                   ;move condition data from
                                                ;app to our array
                popf

                pop     edi
                pop     esi
                pop     edx
                pop     ecx
                pop     ebx
                pop     ebp

;
;If we added a condition (versus reusing a previous one), bump the counter
;
                cmp     num_conditions, MAX_TRAP_FUNCTIONS   
                je      trap_cr900    
                inc     num_conditions
trap_cr900:
		xor	eax, eax
                ret

trap_cr999:
                mov     eax, MAX_COND_EXCEEDED 
                stc
                ret

EndProc         register_callback

;--------------------------------------------------------------
;update_callback - IOCTL via which application can update     |
;                  callback criteria.  App passes the         |
;                  index into the condition data for the      |
;                  callback record to be updated.             |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;                      lpvInBuffer in the block points to a   |
;                      struct which contains the record #,    |
;                      a ptr to the new data, and its length. |
;                                                             |
;           Exit:                                             |
;                                                             |
; trap_conditions[n] = updated.                               |
;                                                             |
;                eax = 0 (success)                            |
;                      NC                                     |
;                                                             |
;                eax = INVALID_CALLBACK_REC if  invalid       |
;                      callback record specified              |
;                      CY                                     |
;                                                             |
;--------------------------------------------------------------
BeginProc       update_callback
                push    ecx
                push    edx
                push    esi
                push    edi
		mov	esi, [esi].lpvInBuffer	;get ptr to callback info
                mov     eax, [esi].trap_rec_num  
                cmp     ax, num_conditions      ;valid record?
                jb      update_ca300
                mov     eax, INVALID_CALLBACK_REC ;if not, exit with error
                stc
                jmp     short update_ca999

update_ca300:
                mov     edx, (size trap_criteria)
                mul     edx                      ;compute index into conditions
                mov     edi, OFFSET trap_conditions
                add     edi, eax                 ;get to desired array entry

                movzx   ecx, [esi].trap_dat_len
                cmp     ecx, LEN_USER_TRAPDAT   ;verify app passes ok length
                jbe     update_ca500
                mov     ecx, LEN_USER_TRAPDAT
update_ca500:
                mov     esi, [esi].trap_dat_ptr 
                pushf
                cld
                rep     movsb                   ;move condition data from
                                                ;app to our array
                popf        

		xor	eax, eax

update_ca999:
                pop     edi
                pop     esi
                pop     edx
                pop     ecx
                ret
EndProc         update_callback


;--------------------------------------------------------------
;give_back_node - Application is done with the log buffer     |
;                 record.  Deallocate it.                     |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;        list_handle = handle for linked list services        |
;                                                             |
;           Exit:                                             |
;                                                             |
;                eax = 0 (success)                            |
;                      NC                                     |
;                                                             |
;--------------------------------------------------------------
BeginProc       give_back_node
                push    ebp
                push    esi
		mov	esi, [esi].lpvInBuffer	;get ptr to node address 
                mov     eax, [esi]              ;get node address


give_back999:
                mov     esi, list_handle
                
                VMMcall List_Deallocate         
        
                xor     eax, eax
                pop     esi
                pop     ebp
                ret
EndProc         give_back_node


;--------------------------------------------------------------
;give_back_extnode - Application is done with an extended     |
;                    record.  Deallocate it.                  |
;                                                             |
;                                                             |
;          Enter:                                             |
;                ecx = IOCTL command code                     |
;                esi = ptr to IOCTL block                     |
;        ext_list_handle = handle for linked list services    |
;                                                             |
;           Exit:                                             |
;                                                             |
;                eax = 0 (success)                            |
;                      NC                                     |
;                                                             |
;--------------------------------------------------------------
BeginProc       give_back_extnode
                push    ebp
                push    esi
		mov	esi, [esi].lpvInBuffer	;get ptr to node address 
                mov     eax, [esi]              ;get node address


                mov     esi, ext_list_handle
                
                VMMcall List_Deallocate         
        
                xor     eax, eax
                pop     esi
                pop     ebp
                ret
EndProc         give_back_extnode


;--------------------------------------------------------------
;ct_dynamic_exit - VxD is being unloaded --remove file system |
;                  API hook.                                  |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                clear carry flag                             |
;                                                             |
;--------------------------------------------------------------
BeginProc 	ct_dynamic_exit

                VxdCall IFSMgr_RemoveFileSystemApiHook, <OFFSET32 ctifs_mgrproc>
                call    unhook_reg

                mov     esi, list_handle
                VMMcall List_Destroy            ;done with list -- free handle 

                mov     esi, ext_list_handle
                VMMcall List_Destroy            ;done with list -- free handle 

		clc
		ret
EndProc 	ct_dynamic_exit

;--------------------------------------------------------------
;unhook_reg - Undo hooks of registry. Called upon exit (or    |
;             in the event of some failure during init)       |
;                                                             |
;          Enter:                                             |
;                                                             |
;    reg_func_table = has entries containing original         |
;                     registry function address (if zero      |
;                     didn't ever get hooked).                |
;                                                             |
;           Exit:                                             |
;                                                             |
;--------------------------------------------------------------
BeginProc       unhook_reg
                push    ecx
                push    esi
                push    ebx

                mov     ecx, REG_TABLE_ENTRIES 
                mov     ebx, OFFSET32 reg_func_table
unhook_r500:
                cmp     [ebx].reg_old_handler, 0        ;ever get hooked?
                je      unhook_r600
                mov     eax, [ebx].reg_service 
                mov     esi, [ebx].reg_ct_handler
                VMMCall UnHook_Device_Service

unhook_r600:
                add     ebx, (size reg_func)
                loop    unhook_r500

unhook_r700:
                pop     ebx
                pop     esi
                pop     ecx
                ret
EndProc         unhook_reg

VXD_PAGEABLE_CODE_ENDS

;---------------------------------------------------------------
;               Device Initialization Code                     |
;---------------------------------------------------------------

VXD_ICODE_SEG

;--------------------------------------------------------------
;ct_dynamic_init - We are being dynamically loaded.  Hook     |
;                  file system APIs.                          |
;                                                             |
;          Enter:                                             |
;                                                             |
;           Exit:                                             |
;                                                             |
;                 CY - If failure in initializing             |
;--------------------------------------------------------------

BeginProc       ct_dynamic_init
                push    ecx
                push    esi
                push    edi

                mov     num_conditions, 0       ;no trapping conditions yet
                mov     entry_count, 0          ;haven't entered hook yet
                mov     handle_count, 0         ;no hkeys tracked yet
                mov     reg_busy, 0             ;not in registry function yet


                mov     eax, (LF_ASYNC OR LF_ALLOC_ERROR) ;can use during ints
                mov     ecx, TRAP_REC_LEN     
                VMMcall List_Create
                mov     list_handle, esi
                jc      ct_dynam900             ;if error creating list


                mov     eax, (LF_USE_HEAP OR LF_ALLOC_ERROR) ;use heap for big nodes
                mov     ecx, TRAP_EXTREC_LEN     ;huge, but only need one or two
                VMMcall List_Create
                mov     ext_list_handle, esi
                jc      ct_dynam900             ;if error creating list


                VxdCall IFSMgr_InstallFileSystemApiHook, <offset32 ctifs_mgrproc>

                or      eax, eax                ;did the call succeed?
                jz      ct_dynam550

;returns eax = ptr to variable containing address of previous hooker
                mov     prev_ifs_hooker, eax    

                mov     ecx, REG_TABLE_ENTRIES 
                mov     edi, OFFSET32 reg_func_table
ct_dynam500:
                mov eax, [edi].reg_service 
                mov     esi, [edi].reg_ct_handler
                VMMCall Hook_Device_Service
                jnc     ct_dynam600
                call    unhook_reg              ;unhooks all that have been hooked
ct_dynam550:
                stc
                jmp     short ct_dynam900

ct_dynam600:
                mov     [edi].reg_old_handler, esi
                add     edi, (size reg_func)
                loop    ct_dynam500
ct_dynam800:
                clc                             ;indicate success

ct_dynam900:
                pop     edi
                pop     esi
                pop     ecx

		ret

EndProc         ct_dynamic_init


VXD_ICODE_ENDS

end
