;---------------------------------------------------------------    
;Ctstruc.inc - structures that support CTRLTRAP VxD            |
;--------------------------------------------------------------|
;Copyright (c) 1999
;Ziff-Davis Publishing Company
;All rights reserved.
;First Published in PC Magazine, US Edition, January 19, 1999
;Written by Rick Knoblaugh
;--------------------------------------------------------------|
; 08/07/98 - initial development                               |
;                                                              |
;                                                              |
;                                                              |
;                                                              |
;--------------------------------------------------------------|

;stack frame (with our local vars) for file system API hook function
fsapi_parms	struc
fs_ebp		dd	?
cur_process_hand dd     ?       ;current process handle
cur_thread_hand  dd     ?       ;current thread handle
rec_buffer      dd      ?       ;ptr to allocated buffer for logging an I/O
log_flag        dd      ?       ;bit in here set if operation is to be logged
func_status     dw      ?       ;status if app performs the function
hold_fnaddr	dd      ?       ;store address of actual IFS API handler
active_hook     dd      ?       ;indicate which hook (registry or IFSMgr) got control
active_function dd      ?       ;indicates which registry function is being processed
key_elements    dw      ?
mod_name        db      MAX_PROG_LEN dup(?) ;8 char module name taken from TDB
remain_reg_buf  dd      ?
reg_buf_ptr     dd      ?
condition_ptr   dd      ?       ;hold address of condition record that matched   

LOCAL_VAR_SIZE  equ     (fs_ret_addr - cur_process_hand)

fs_ret_addr   	dd	?		
fs_fnaddr	dd	?		;address of file system function
fs_func_num	dd	?		;function to be performed
fs_drive	dd	?
fs_res_flags	dd	?
fs_code_page	dd	?
fs_pioreq	dd	?		;ptr to IOREQ 

FSAPI_PARMS_SIZE equ   (fs_pioreq - fs_ret_addr)

fsapi_parms	ends

;stack frame for the actual file system function itself
func_parms      struc
func_ebp   	dd	?
func_ret_addr  	dd	?		
func_pioreq	dd	?		        ;ptr to IOREQ 
func_parms      ends

trap_record     struc
tr_category     dd      ?
tr_function     dd      ?
tr_drive        dd      ?
tr_ir_flags     db      ?                       ;ioreq ir_flags  field
tr_ir_options   dw      ?                       ;ioreq ir_option field
tr_res_type     dd      ?
tr_handle       dd      ?                       ;file handle        
tr_file1        db      MAX_PATH        dup(0)
tr_file2        db      MAX_PATH        dup(0)
tr_program      db      MAX_PROG_LEN+1  dup(0)  ;program name+zero terminator
tr_proc_handle  dd      ?                       ;process handle
tr_error        dw      ?                       ;status of I/O operation
tr_drv_context  dd      ?                       ;context of logging driver
tr_drv_status   dw      ?                       ;status returned to driver
tr_drv_miscflag dw      ?                       ;logging flags for this function  
tr_create_flag  db      ?                       ;TRUE if file is being created
tr_low_size     dd      ?
tr_high_size    dd      ?
tr_low_datetime dd      ?
tr_high_datetime dd     ?
trap_record     ends

reg_trap_record struc
rtr_category    dd      ?                       ;contains REG_FUNCTIONS  (0x1)
rtr_function    dd      ?
rtr_program     db      MAX_PROG_LEN+1  dup(0)
rtr_proc_handle dd      ?
rtr_lp_key_name dd      ?
rtr_lp_subkey   dd      ?
rtr_lp_val_name dd      ?
rtr_value_type  dd      ?
rtr_lp_value    dd      ?
rtr_len_value   dd      ?
rtr_lp_prev_value dd    ?
rtr_len_prev_value dd   ?
rtr_extra_rec1  dd      ?   
rtr_extra_rec2  dd      ?    
rtr_extra_rec3  dd      ?
reg_trap_record ends

trap_criteria   struc
tc_category     dd      ?               ;indicator of functional area (e.g. file system, registry, etc.)
tc_func_num	dd      ?               ;function app wants trapped (-1 = all)
tc_flags        db      ?               ;if function uses flags, can also specify here (zero if none)
tc_flag_mask    db      ?               ;if function uses flags, can mask before compare (zero if no mask)
tc_drive	dd      ?               ;drive (-1 = all drives)
tc_proc_handle  dd      MAX_PROCESSES dup (?)      ;process (-1 if all processes)
tc_callback     dd      ?               ;address to call back
tc_misc_flags   dw      ?               ;misc flags
;
;note: always keep thread at end (application passes us this exact
;      structure --minus the thread which we supply)
;
tc_thread       dd      ?               ;thread that wants call back

LEN_USER_TRAPDAT equ (tc_thread - tc_category)
trap_criteria   ends

up_call_        struc
trap_rec_num    dd      ?
trap_dat_ptr    dd      ?
trap_dat_len    dw      ?
up_call_        ends

reg_func        struc
reg_ct_code     dd      ?              ;code used by CntrlTrap for this function
reg_service     dd      ?
reg_old_handler dd      ?
reg_ct_handler  dd      ?
reg_func        ends

open_key_stack  struc
ok_ebp          dd      ?
ok_ret          dd      ?
ok_hKey         dd      ?
ok_SubKey       dd      ?
ok_phKey        dd      ?
OPEN_KEY_PARMS  equ     ($ - ok_hKey )
open_key_stack  ends

close_key_stack  struc
ck_ebp          dd      ?
ck_ret          dd      ?
ck_hKey         dd      ?
CLOSE_KEY_PARMS  equ     ($ - ck_hKey )
close_key_stack  ends

delete_key_stack  struc
dk_ebp          dd      ?
dk_ret          dd      ?
dk_hKey         dd      ?
dk_SubKey       dd      ?
DELETE_KEY_PARMS  equ     ($ - dk_hKey )
delete_key_stack  ends


set_value_stack   struc
sv_ebp          dd      ?
sv_ret          dd      ?
sv_hKey         dd      ?
sv_SubKey       dd      ?
sv_Type         dd      ?
sv_lpdata       dd      ?
sv_len          dd      ?
SET_VALUE_PARMS   equ     ($ - sv_hKey )
set_value_stack   ends

delete_value_stack   struc
dv_ebp          dd      ?
dv_ret          dd      ?
dv_hKey         dd      ?
dv_ValueName    dd      ?
DELETE_VALUE_PARMS   equ     ($ - dv_hKey )
delete_value_stack   ends

query_value_stack   struc
qv_ebp          dd      ?
qv_ret          dd      ?
qv_hKey         dd      ?
qv_SubKey       dd      ?
qv_lpdata       dd      ?
qv_lplen        dd      ?
QUERY_VALUE_PARMS   equ     ($ - qv_hKey )
query_value_stack   ends






query_value_exstack   struc
qvex_ebp          dd      ?
qvex_ret          dd      ?
qvex_hKey         dd      ?
qvex_ValueName    dd      ?
qvex_lpdw_res     dd      ?
qvex_lptype       dd      ?
qvex_lpdata       dd      ?
qvex_lplen        dd      ?
QUERY_VALUE_EXPARMS   equ     ($ - qvex_hKey )
query_value_exstack   ends

set_value_exstack   struc
svex_ebp          dd      ?
svex_ret          dd      ?
svex_hKey         dd      ?
svex_ValueName    dd      ?
svex_dw_res       dd      ?
svex_type         dd      ?
svex_lpdata       dd      ?
svex_lplen        dd      ?
SET_VALUE_EXPARMS   equ     ($ - svex_hKey )
set_value_exstack   ends

hkey_track      struc
ht_avail        db      ?
ht_ohkey        dd      ?
ht_key_name     db      MAX_VMM_REG_KEY_LEN+1 dup(?)
ht_hkey         dd      ?
hkey_track      ends


predefined_struc struc
predef_key      dd      ?
predef_key_str  dd      ?
predefined_struc ends

misc_flags_rec  record  rep_open_writes:1, rep_all_creates:1, unused1:7, skip_zero_len:1, app_canceled:1, app_exited:1, app_func_done:1, unused2:2, disable_log:1
