VERSION 2.00
Begin Form frmExtern 
   AutoRedraw      =   -1  'True
   Caption         =   "Demo Extern"
   ClientHeight    =   555
   ClientLeft      =   2595
   ClientTop       =   2745
   ClientWidth     =   2070
   ControlBox      =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   12
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   990
   Left            =   2520
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   555
   ScaleWidth      =   2070
   Top             =   2385
   Width           =   2220
   Begin Timer Timer1 
      Enabled         =   0   'False
      Left            =   420
      Top             =   60
   End
End
Option Explicit
Const GET_PATH = 0
Const GET_FULLFILENAME = 1
Const GET_FILENAME = 2
Const GET_FILEEXT = 3

Sub ExternAction ()
'*** BASIC PRICIPLES ***
'WinPack external programs work a bit like FBB PG programs.
'The program must run quickly and terminate after each call. It doesn't stay
'running during a session. The status is used to enable it to act
'intelligently. Any temporary data used during a session must be stored in a
'file.
'
'*** INPUT ***
'The program receives its input as command line arguments. It is up to the
'programmer to parse the arguments out of the command line. Very easy in
'C, ExtractArg() in this example gives you a way of doing it in VB.
'
'The command$ format is:
'
'status - a number starting at 0 for the first call this session, and
'         then whatever the external program returned on the previous call.
'pms_call - the callsign of the WinPack operator.
'first_name - the WinPack operator's first name.
'connected_station - the callsign, including SSID of the user.
'user_text - any text from the user. In 'C' this will be picked up as one
'word per argument.
'
'All arguments are mandatory except for user_text.
'
'*** OUTPUT ***
'Returns a reply in <extern>.REP in the EXTERN subdirectory.
'The first line is the status with which WinPack should call the program
'the next time in this session. This mechanism allows a program to act
'intelligently during a user session.
'The rest is text to return to the user.
'Just plain ASCII, with CR/LF newlines, please!
'If the status is less than 0 then WinPack regards it as terminating the
'external program session. So be sure to return less than 0 if an error
'occurs.
Dim a As String
Dim b As String
Dim fd As Integer
Dim rep_fname As String
Dim tmp_fname As String
Dim i As Integer
Dim pms_call As String
Dim status As Integer
Dim first_name As String
Dim connected_station As String
Dim user_text As String
Dim reply As String
Dim newline As String
Dim stupid_reply As String

newline = Chr$(13) & Chr$(10)
stupid_reply = "That is a pretty stupid reply!" & newline

'Make reply and temporary file names based on our EXE name.
a = GetPathBits(App.EXEName, GET_FILENAME)
a = App.Path & "\" & a
rep_fname = a & ".REP"
tmp_fname = a & ".TMP"

On Error GoTo extern_err

'Kill the reply file if it exists. If Winpack can't find a reply file then
'it regards the session as being over.
If Dir$(rep_fname) <> "" Then Kill rep_fname

'Parse the arguments out of command$
a = Trim(Command$)
If a = "" Then GoTo extern_err

'the status.
b = ExtractArg(a)
If a = "" Then GoTo extern_err
status = Val(b)

'the PMS callsign.
pms_call = ExtractArg(a)
If a = "" Then GoTo extern_err

'the operators first name.
first_name = ExtractArg(a)
If a = "" Then GoTo extern_err

'the callsign of the connected station.
connected_station = ExtractArg(a)
Print connected_station
DoEvents

'any user text.
user_text = a

'Act according to the status value.
Select Case status
    Case 0:
        reply = "Hello " & connected_station & ". This is a demo of a WinPack external program." & newline & "Please input your name:" & newline
        status = 1
    Case 1
        If user_text = "" Then
            reply = stupid_reply
            status = -1
        Else
            'tidy up and save the name
            user_text = MixCase(user_text)
            fd = FreeFile
            Open tmp_fname For Output As fd
            'save the name in the temporary file.
            Print #fd, user_text
            Close fd
            'Why do I set fd to 0 after each close? Well, nothing to do with
            'this particular program, I always do it! Helps in the error
            'exit - see below.
            fd = 0
            reply = "Thank you " & user_text & ". Please input your location:" & newline
            status = 2
        End If
    Case 2
        If user_text = "" Then
            reply = stupid_reply
            status = -1
        Else
            'read the name from the temporary file
            fd = FreeFile
            Open tmp_fname For Input As fd
            Line Input #fd, a
            Close fd
            fd = 0
            'tidy up and save the location
            user_text = MixCase(user_text)
            fd = FreeFile
            Open tmp_fname For Append As fd
            Print #fd, user_text
            Close fd
            fd = 0
            reply = "Thank you " & a & ". Please input your home BBS:" & newline
            status = 3
        End If
    Case 3
        If user_text = "" Then
            reply = stupid_reply
        Else
            fd = FreeFile
            Open tmp_fname For Input As fd
            'read the name from the temporary file
            Line Input #fd, a
            reply = "Thank you " & a & "." & newline & "I have your location as "
            'read the location from the temporary file
            Line Input #fd, a
            Close fd
            fd = 0
            Kill tmp_fname
            reply = reply & a & "." & newline & "I have your home BBS as " & UCase(user_text) & "." & newline
            reply = reply & "This information is not being saved, it is simply a demo." & newline
            reply = reply & "Have a good day!" & newline
        End If
        status = -1
End Select

'Write the reply file - WinPack reads this as soon as this program finishes.
fd = FreeFile
Open rep_fname For Binary As fd
a = Format(status) & newline
Put #fd, , a
Put #fd, , reply
Close fd
fd = 0
Exit Sub

extern_err:
On Error GoTo serv_out
'If an error occurred while a file was open, close it.
If fd <> 0 Then Close fd
fd = FreeFile
Open rep_fname For Output As fd
Print #fd, "-1"
Close fd

serv_out:
Exit Sub

End Sub

Function ExtractArg (a As String) As String
'Extract the next argument from a command$.
'NB, in worst VB style, the callers 'a' is altered by this function.
Dim i As Integer

If a = "" Then Exit Function

i = InStr(a, " ")
If i = 0 Then
    ExtractArg = a
    a = ""
Else
    ExtractArg = Left(a, i - 1)
    a = Mid(a, i + 1)
End If

End Function

Sub Form_Load ()

Move 0, screen.Height - Height
Show
DoEvents
timer1.Interval = 500
timer1.Enabled = True

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

End

End Sub

Function GetPathBits (ByVal TempPath As String, action As Integer) As String
'Hacked out of Microsoft Knowledge Base Article ID: Q113897.
'The programming style is that of the author!
'I simply added the ability to return different parts of the path according
'to the action argument.
Dim DriveLetter As String
Dim DirPath As String
Dim Filename As String
Dim Extension As String
Dim PathLength As Integer
Dim OffSet As Integer
Dim ThisLength As Integer
Dim FileNameFound As Integer

If Mid(TempPath$, 2, 1) = ":" Then     ' Find the drive letter.
    DriveLetter = Left(TempPath$, 2)
    TempPath$ = Mid(TempPath$, 3)
End If

PathLength% = Len(TempPath$)
For OffSet% = PathLength% To 1 Step -1  ' Find the next delimiter.
    Select Case Mid(TempPath$, OffSet%, 1)

    Case ".": ' This indicates either an extension or a . or a ..
    ThisLength% = Len(TempPath$) - OffSet%

    If ThisLength% >= 1 And ThisLength% <= 3 Then ' Extension
        Extension = Mid$(TempPath$, OffSet%, ThisLength% + 1)
    End If
    TempPath$ = Left(TempPath$, OffSet% - 1)

    Case "\": ' This indicates a path delimiter.
    ThisLength% = Len(TempPath$) - OffSet%
    If ThisLength% >= 1 And ThisLength% <= 8 Then ' Filename
        Filename = Mid$(TempPath$, OffSet% + 1, ThisLength%)
        TempPath$ = Left(TempPath$, OffSet%)

        FileNameFound% = True
        Exit For
    End If

    Case Else
    End Select
Next OffSet%

If FileNameFound% = False Then
    Filename = TempPath$
Else
    DirPath = TempPath$
End If

Select Case action
    Case GET_PATH
        GetPathBits = DriveLetter & DirPath
    Case GET_FULLFILENAME
        GetPathBits = Filename & Extension
    Case GET_FILENAME
        GetPathBits = Filename
    Case GET_FILEEXT
        GetPathBits = Extension
End Select

End Function

Function MixCase (ByVal a As String) As String
'Capitalise the first letter of each word.
Dim i As Integer

a = LCase(a)
Mid(a, 1, 1) = UCase(Mid(a, 1, 1))

i = InStr(a, " ")
Do While i <> 0
    Mid(a, i + 1, 1) = UCase(Mid(a, i + 1, 1))
    i = InStr(i + 1, a, " ")
Loop

MixCase = a

End Function

Sub Timer1_Timer ()

timer1.Enabled = False

Call ExternAction
Unload Me

End Sub

