
/*
   MCGALIB
   (c) 1993 D.G. Sureau

   These functions are for VGA 19,
   320 x 200, 256 colors screen
*/



/* Graphic window variables */

extern int XL;           /* Default = 0   */
extern int XR;           /* Default = 319 */
extern int YB;           /* Default = 0   */
extern int YT;           /* Default = 199 */

extern unsigned char COLOR256;  /* Color for pixels */

extern unsigned char TEXTCOLOR;     /* Color for text display */

extern unsigned long *SPVECTOR;     /* Pointer on sprites's adr. */
extern char *SPCODE;                /* Pointer on sprites's code */
extern unsigned int VGASCREEN;      /* Segment of VGA graphic screen */


void window19(int xl,int yb,int xr,int yt); /* Defines graphic window */
void cls19(int col);                        /* Clears graphic screen  */
void outtext(int x,int y,char *txt);        /* Displays text at x,y   */
					    /* with TEXTCOLOR color # */

void sprite256( int x,int y,char *ptr);
 /* Puts spr. over background, in graphical window */

void csprite256(int x,int y,char *ptr);
 /* Puts spr. erases background, without clipping */

void csprite256c(int x,int y,char *adr);
 /* Puts spr. erases background, in graphical window */

void xsprite256(int x,int y,char *adr);
  /* Display sprite in XOR mode */

void sprite(int number, int x,int y, unsigned char mode);
			     /* Puts sprite number #nn,
				valid modes in sprlib are:
				0 = copy
				4 = over background
			     */

/* Function for saving and restoring block of screen */

void putblock(int x,int y,char *ptr);
void getblock(int lft,int bottom,int rght,int hight,char *ptr);

char *getspadr(int number);          /* Gets absolute adr in table */


void icon19(int x,int y,char *ptr);  /* Put a 16 color icon on screen */

void writeRGB(char *adr);       /* Set 256 color palette from file */
void writecolor(int colnum,int r,int g,int b); /* Create a color */

void setpix256(int x,int y,unsigned char color); /* Put a pixel */
int getpix256(int x,int y);      /* Get color of pixel at x, y */
void line256(int x,int y,int x2,int y2, unsigned char color);
	    /* Draw a line from x, y to x2, y2 */
void fillblock(int l,int b,int r,int h,int color);
            /* Fill a rectangle with a color among 256 */




