; Factorial 5 is calculated repeatedly using a recursive algorithm.

; As 127 is the largest positive number that SMS can handle,  5 is the 

; largest factorial that can be correctly calculated. ( Answer = 120 )

; ----- THE MAIN PROGRAM ----------------------------------------------------
		
back9:					
	mov	al,5			; What is factorial 5 ???
	push	al			; Put 5 onto the stack
	call	10			; Call the procedure to find 5!
	pop	al			; Answer returned off stack into AL
	jmp	back9			; Back to the start
	
; ----- A RECURSIVE PROCEDURE TO FIND N! ------------------------------------

; If N is 0,  factorial N is 1
; Otherwise   factorial N is N * Factorial (N - 1)

	org	10			; Procedure starts at address 10
	pop	bl			; Return address : keep BL safe
	pop	cl			; Get input data off stack
	cmp	cl,0			; If cl == 0	( Stop condition )
	jz	HERE			; Forward 1Ah
	
	push 	cl			; Could be 5 for example
	push	bl			; Return address. 
	dec	cl			; n! = n * (n - 1)! (Work out (n - 1)
	push	cl			; Could be 4 for example
	call 	10			; Recursive call
	pop	cl			; Pop answer off the stack
	pop	bl			; Return address : Keep BL safe
	pop	al			; Is old answer
	mul	al,cl			; Do multiplication
	push	al			; Push back new answer
	push	bl			; Push back return address
	ret
HERE:	
	mov	cl,1			; 0! = 1
	push	cl			; Push 1 onto the stack
	push	bl			; Push the return address
	ret				; Stack pointer is correctly placed
	
	org	50			
	db	"Recursive"
	org	60			
	db	"Factorial 5"
	org	70			
	db	"Example Program"
	org	80			
	db	"Parameters"
	org	90			
	db	"passed on stack"
	
	end
	
-----------------------------------------------------------------------------
