{
  Public Domain  - Please leave this notice intact.
  Mike Caughran Cedar Island Software OCT 1994
  All the usual disclaimers apply.
  Implement the beginnings of a Telnet daemon using BPascal 7

  xtscmsc@mocha.state.ak.us
  71034.2371@compuserve.com
  907-789-9030 voice
  907-789-1694 bbs
}

{
  This code is based on Telnetd - part of a Telnet and Telnetd
  demo package distributed as PASOCK10.ZIP on sunsite.unc.edu
  and other places.
  Freeware by Mike Caughran Cedar Island Software.
  Telnetd resides on port 23.
}

(*  You will need to add the directory from which this gets executed to your path *)

{$M 16384,8192}

program Telnetd;

uses winsock, strings, wincrt, winprocs, wintypes, winDos;

var
  myVerReqd : word;
  myWSAData : WSADATA;
  s : String[255];
  i : integer;
  CharArray: array[0..255] of char;
  HostNameArray: array[0..255] of char;
  TelnetSocket, AcceptSocket : tSOCKET;
  err : integer;
  TelnetPort : word;
  Remote_Addr: sockaddr_in;
  Remote_Host: Phostent;
  CanWrite : Boolean;
  GotString : Boolean;
  GotEOF    : Boolean;
  Userid : String;

procedure CleanUp; Forward;
procedure SendUserWriteMessage; Forward;

{$I ERROR.INC}

{------------------------------------------- start interpreter ---}
var
  command : string;
  CurrentDir : String;

const
  Terminate : Boolean = False;
  StartUpDir : String = '';
var
  ThisLen : integer;
  ThisAddr : sockaddr;
  RXBuffer : array [0..1024] of char;
  TXBuffer : array [0..1024] of char;
  ch : char;
  ReadCount,Readindex : Integer;
  SendCount : Integer;

procedure Delay(Time : longint);
var
  Msg : TMsg;
  StartTime : Longint;
begin
  StartTime := GetTickCount;
  repeat
    While PeekMessage(Msg,0,0,0,PM_REMOVE) do begin
      TranslateMessage(Msg);
      DispatchMessage(Msg);
    end;
  until GetTickCount > StartTime + Time;
end;


Function WinExecAndWait(Path : Pchar; Visibility : word) : word;
{Execute a command and wait for completion before returning}
var
  InstanceID : THandle;
  Msg : TMSg;
  AText : Array[1..255] of char;

begin
  WinExecAndWait := 32;
  InstanceID := WinExec(Path,Visibility);
  if InstanceId < 32 then begin     {maybe its a DOS command}
    StrCopy(@AText, GetEnvVar('COMSPEC'));
    StrCat(@AText,' /C ');
    StrCat(@AText, Path);
    InstanceID := WinExec(@AText,Visibility);
  end;
  if InstanceID < 32 then           { file doesn't exist  }
     WinExecAndWait := InstanceID
  else begin
    Repeat
      delay(50);
    until GetModuleUsage(InstanceID) = 0;
  end;
end;

procedure DisplayNR(AString: String);
var
  AText : Array[0..255] of char;
begin
  strPcopy(AText,AString);
  StrCat(TXBuffer,AText);
  SendUserWriteMessage;
end;

procedure Display(AString: String);
begin
  DisplayNR(AString);
  StrCat(TXBuffer,#13#10);
end;

Function GetChar : char;
var
  ch : char;
  count : integer;
begin
  Repeat
    count := recv(AcceptSocket, @ch, 1, 0);
    if WSAGetLastError <> 0 then ;
    delay(10);
  until count = 1;
  GetChar := ch;
end;

Function GetString : String;
begin
  repeat
    Delay(50);
  until GotString;
  GetString := Command;
  Command := '';
  GotString := False;
end;

procedure ShowHelp;
var i : integer;
begin
  for i := 1 to 25 do Display('');
  Display(' Telnet Daemon written in Borland Pascal7 for Winsock.Dll');
  Display(' Public Domain 1995.  Cedar Island Software');
  Display(' Mike Caughran 71034.2371@compuserve.com');
  Display(' No liability assumed or accepted.');
  Display(' USE THIS THING AT YOUR OWN RISK!');
  Display('');
  Display(' Valid Commands :');
  Display('  exit   - Terminate Telnet session');
  Display('  help   - This is it');
  Display('  dir');
  Display('  cd');
  Display('  md');
  Display('  rd');
  Display('  type');
  Display('  copy');
  Display('  del');
  Display('');
end;

Function MakePipedOutput(Command : String) : boolean;
 {Create a temporary batch file (_EXECPIP.BAT) which will execute Command and
  pipe the output into a temporary output file (_EXECPIP.OUT)}
var
  f : text;
begin
{$I-}
  MakePipedOutput := True;
  assign(f,StartUpDir+'\_EXECPIP.BAT');
  if ioresult <> 0 then MakePipedOutput := False;
  rewrite(f);
  Writeln(f, Command+ ' > '+StartUpDir+'\_EXECPIP.OUT');
  Close(f);
  if ioresult <> 0 then MakePipedOutput := False;
 {$I+}
end;

function  ShowPipedOutput : boolean;
var
  f,g : text;
  AString : String;
begin
{$I-}
  ShowPipedOutput := True;
  assign(f,StartUpDir+'\_EXECPIP.OUT');
  reset(f);
  while not eof(f) do begin
    readln(f, AString);
    Display(AString);
  end;
  Close(f);
  if ioresult <> 0 then ;
  Erase(f);
  assign(g,StartUpDir+'\_EXECPIP.OUT');
  Erase(g);
  if ioresult <> 0 then ;
 {$I+}
end;

procedure ShowPrompt;
begin
  DisplayNR(CurrentDir+'> ');
end;

procedure FilterCommand(var Command : String) ;
var AString : String;
begin
  if Command = '' then exit;
  AString := Command;
  if      copy(AString,1,4) = 'exit'   then begin
    Terminate := True;
    Command := '';
  end
  else if copy(AString,1,5) = 'help'   then begin
    ShowHelp;
    Command := '';
  end
  else if copy(AString,1,3) = 'dir'    then {doit}
  else if copy(AString,1,3) = 'cd '    then begin
    {$I-}
    if ioresult <> 0 then ;
    AString := copy(AString,4,length(AString)-3);  {trim off 'cd '}
    chdir(AString);
    getDir(0,CurrentDir);
    Command := '';
    if ioresult <> 0 then Display('Invalid Directory : '+AString);
    {$I+}
  end
  else if copy(AString,1,3) = 'md '       then {doit}
  else if copy(AString,1,3) = 'rd '       then {doit}
  else if copy(AString,1,5) = 'type '     then {doit}
  else if copy(AString,1,5) = 'copy '     then {doit}
  else if copy(AString,1,4) = 'del '      then Command := 'Echo Y |' +AString
  else begin
    Display('Invalid Command.  Type help or exit.'); Display('');
    Command := '';
  end;
end;

procedure ExecuteCommand(var Command : String);
Var A: array[0..255] of Char;
begin
  if Command <> '' then begin
    if not MakePipedOutput(Command) then MessageBeep(0);
    StrPCopy(A,StartUpDir+'\_execpip.pif');
    WinExecAndWait(A,sw_ShowMinNoActive);
    if not ShowPipedOutput then MessageBeep(0);
  end;
end;

{------------------------------------------- end interpreter ---}



{----------------------------------------}
{ -- Start of code to SubClass WinCRT -- }
{----------------------------------------}
var
  OldWndProc : TFarProc;
  Msg : TMsg;
  StartTime : LongInt;
const
  hCRTWnd : HWND        = 0;
  cm_Exit               = 100;
  cm_About              = 101;
  USER_CONNECT         = WM_USER + 100;
  USER_READ            = WM_USER + 101;
  USER_WRITE           = WM_USER + 102;

procedure SendUserWriteMessage;
begin
  SendMessage(HCrtWnd,USER_WRITE,0,0);
end;

function WindowProc(Window:HWnd; Message,wParam:Word; lParam:LongInt) : LongInt; export;
var i : integer;
begin
  case Message of
    wm_Char        : begin
                       if wParam=vk_Escape then begin
                         CleanUp;
                         DoneWinCRT;
                       end;
                     end;
    wm_Command     : begin
      case WParam of
	cm_About:   begin
          MessageBox(Window,
'Telnet Daemon'#13'Public Domain 1995 by'#13'Mike Caughran'#13'Cedar Island Software',
'Pascal Telnet Daemon',mb_IconQuestion);
          MessageBox(Window,'Be sure to add this directory to your path','',mb_IconInformation);
                    end;
	cm_Exit:    begin
                      CleanUp;
                      DoneWinCrt;
                    end;
      end;
    end;
    USER_CONNECT : begin
                     writeln('Received a USER_CONNECT message');
                     if (WSAGetSelectError(lparam) <> 0) then Error('USER_CONNECT msg')
                     else begin
                       ThisLen := SizeOf(Remote_Addr);
                       ThisAddr := SockAddr(Remote_Addr);
                       AcceptSocket := accept(TelnetSocket, @ThisAddr, @ThisLen);

                       writeln('AcceptSocket=',acceptSocket);
                       if AcceptSocket=INVALID_SOCKET  then Error('AcceptSocket')
                       else begin
                         WSAAsyncSelect(AcceptSocket, hCRTWnd, USER_READ, FD_READ);  {notify on rx}
                         Delay(1000);
                         showHelp;
                         Command := '';
                         DisplayNR('Enter your userid : ');
                         Userid := GetString;   {ignore it}
                         Writeln;Writeln('The password is ''pastel''');
                         DisplayNR('Password : ');
                         if GetString <> 'pastel' then begin
                           Display('Invalid Password');
                           delay(500);
                           closeSocket(AcceptSocket);
                         end;
                         Display('');
                         ShowPrompt;
                         Terminate := False;
                         repeat
                           Command := '';
                           Command := GetString;
                           FilterCommand(Command);
                           ExecuteCommand(Command);
                           ShowPrompt;
                           Delay(50);
                         Until Terminate;
                         closesocket(AcceptSocket); {exit}
                       end;
                     end;
                   end;
    USER_READ :    begin   {characters received}
                     WSAAsyncSelect(AcceptSocket, hCRTWnd, USER_WRITE, FD_WRITE);
                     {Handle Received Characters}
                     ch := GetChar;{RXBuffer[0];}
                     case ch of
                       #255 : ;  {ignore IAC commands}
                       #4   : closesocket(AcceptSocket); {Control-D}
                       #8   : begin {BackSpace}
                                Command := copy(Command,1,length(Command)-1);
                                write(ch);
                                Send(AcceptSocket,#8' '#8,3,0);
                              end;
                       #13  : begin
                                GotString := True;
                                Display('');
                              end;
                       #26  : GotEOF := True; {Control-Z}
                       else begin
                         Command := Command + ch;
                         write(ch);
                         Send(AcceptSocket,@ch,1,0);
                       end;
                     end;  {case ch}
                   end;
    USER_WRITE :   begin      {characters sent}
                     WSAAsyncSelect(AcceptSocket, hCRTWnd, USER_READ, FD_READ);  {notify on rx}
                     SendCount :=Send(AcceptSocket,TXBuffer,StrLen(TxBuffer),0);
                     if (SendCount = SOCKET_ERROR) and (WSAGetLastError = WSAEWOULDBLOCK)then begin
                       Repeat
                         Delay(50);
                       until Send(AcceptSocket,TXBuffer,StrLen(TxBuffer),0) <> SOCKET_ERROR;
                     end;

                     For i := 0 to StrLen(TxBuffer) do write(TXBuffer[i]) ;
                     strCopy(TXBuffer,'');
                   end;

  end;  {case message}
  WindowProc := CallWindowProc(OldWndProc, Window, Message, wParam, lParam);
end;

procedure MakeMenu;
var
  Menu      : HMenu;
  FileMenu  : HMenu;
begin
  Menu := CreateMenu;
  FileMenu := CreateMenu;
  AppendMenu(Menu, mf_PopUp or mf_Enabled, FileMenu, 'File');
  AppendMenu(FileMenu, mf_Enabled, cm_Exit, 'Exit');
  AppendMenu(Menu, mf_Enabled, cm_About, 'About');
  SetMenu(hCRTWnd,Menu);
end;

procedure myInitWinCRT;
var
  hInstance : THandle;
  WindowClass : TWndClass;
begin
  GetClassInfo(hInstance, 'TPWinCrt' ,WindowClass);
  UnregisterClass('TPWinCRT', hInstance);
  WindowClass.hIcon := LoadIcon(0, idi_Question);
  WindowClass.hCursor := LoadCursor(0, idc_Arrow);
  OldWndProc := tFarProc(WindowClass.lpfnWndProc);
  WindowClass.lpfnWndProc := @WindowProc;
  RegisterClass(WindowClass);
  InactiveTitle := '%s';
  StrCopy(WindowTitle,'Pascal Telnet Daemon V1.0');
  ScreenSize.X :=80; ScreenSize.Y :=250;
  InitWinCrt;
  hCRTWnd := GetActiveWindow;
  MakeMenu;
end;

{--------------------------------------}
{ -- End of code to SubClass WinCRT -- }
{--------------------------------------}


procedure StartUp;
begin
  myVerReqd:=$0101;
  Writeln('Winsock version required : ',hibyte(myVerReqd),'.',lobyte(myVerReqd));
  if WSAStartup(myVerReqd,@myWSAData) <>0 then Abort('WSAStartup');
end;

procedure ShowWinSockInfo;
begin
  Write('Winsock Version found: ');
  Writeln(lobyte(myWSAData.wVersion),'.',lobyte(myWSAData.wHighVersion));
  S := StrPas(myWSAData.szDescription);
  Writeln('Description=',S);
  S := StrPas(myWSAData.szSystemStatus);
  Writeln('SystemStatus=',S);
  Writeln('MaxSockets=',word(myWSAData.iMaxSockets));
  Writeln('MaxUdpDg=',word(myWSAData.iMaxUdpDg));
  Write('VendorInfo= ');
    if myWSAData.lpVendorInfo <> NIL then begin
      writeln(myWSAData.lpVendorInfo);
    end else writeln('NULL');
  Write('Local Hostname=');
  if (gethostname(@CharArray,255) <> 0) then Error('GetHostName')
    else writeln(CharArray);
end;

procedure FindTelnetService;
var
  pSE : pServEnt;
begin
  TelnetPort := 0;
  pSE := getservbyname('telnet','tcp');
  if pSE = nil then begin
    Error('GetServByName'); Writeln;
    Writeln('Telnet is usually on port 23.  Check Services table.');
  end
  else begin
    TelnetPort := htons(pSE^.s_port);
    Writeln('Using Telnet service on port ',TelnetPort);
  end;
end;

procedure CreateSocket;
begin
  TelnetSocket:=socket(PF_INET, SOCK_STREAM, IPPROTO_IP);
  If TelnetSocket = INVALID_SOCKET then Abort('Can''t CreateSocket')
  else
    Writeln('Socket descriptor allocated : ',ord(TelnetSocket));
end;

procedure BindToSocket;
begin
  Remote_addr.sin_family := PF_INET;
  Remote_addr.sin_port := htons(TelnetPort);
  Remote_addr.sin_addr.s_addr:=INADDR_ANY;
  if bind(TelnetSocket, sockaddr(Remote_Addr), SizeOf(Remote_Addr)) <> 0 then
  begin
    CloseSocket(TelnetSocket);
    Abort('Bind');
  end;
end;

procedure ListenToSocket;
var
  rc : integer;
begin
  rc := listen(TelnetSocket,5);
  if rc > 0 then Error('Listen');
  rc := rc + WSAAsyncSelect(TelnetSocket, hCRTWnd, USER_CONNECT, FD_ACCEPT);
  if rc > 0 then begin
    CloseSocket(TelnetSocket);
    Abort('WSAAsyncSelect');
  end;
end;

procedure CleanUp;
begin
  if WSACleanup <> 0 then Error('WSACleanup');
end;

procedure DoTelnetd;
begin
  StartUp;
  ShowWinsockInfo;
  FindTelnetService;
  CreateSocket;
  BindToSocket;
  ListenToSocket;
end;

begin
  MyInitWinCRT;
  Command := '';
  GetDir(0,StartUpDir);
  GetDir(0,CurrentDir);
  DoTelnetd;
end.