#!/bin/sh
#
# Shell script to remove common items from .HREF and .NAME files, and sort and
# remove duplicates from .SRC file.  Can be used for external cross-reference
# checking with htmlchek, if refsfile= was specified on the command line
# without xref=1 also being specified, or can be used to resolve the output of
# multiple runs of htmlchek with the append=1 option specified.
#
# Uses perl.
#
if test $# -lt 1
then
    echo "
 Syntax is:  $0  prefix

Where \`\`prefix'' is the common prefix of the .NAME, .HREF, and .SRC files
which are to be reduced." >&2
    exit 1
else
    if test ! \( -s $1.NAME -a -s $1.HREF -a -s $1.SRC \)
    then echo "One or more necessary files don't exist; Exiting..." >&2
         exit 1
    else echo "Sorting and correlating files now... (using perl)" >&2
    sort < $1.NAME | uniq > $1.QNAME
    sort < $1.HREF | uniq > $1.QHREF
    diff $1.QNAME $1.QHREF > $1.TMP
    perl -ne 'if ($_ =~ /^< /) {print substr($_,2)}' $1.TMP > $1.QHREF
    perl -ne 'if ($_ =~ /^> /) {print substr($_,2)}' $1.TMP > $1.QNAME
    diff $1.QNAME $1.QHREF > $1.TMP                 # Iterate
    perl -ne 'if ($_ =~ /^< /) {print substr($_,2)}' $1.TMP > $1.QHREF
    perl -ne 'if ($_ =~ /^> /) {print substr($_,2)}' $1.TMP > $1.QNAME
    sort < $1.SRC | uniq > $1.TMP
    mv $1.TMP $1.SRC      # You can change this if you don't want
    mv $1.QNAME $1.NAME   # to overwrite the original three files
    mv $1.QHREF $1.HREF
    echo "Shared items were removed from $1.NAME and $1.HREF
 (i.e. external cross-reference checking), and $1.SRC was sorted and
 duplicate items removed.
" >&2
    fi
fi
exit 0
