#!/bin/sh
#
# Shell script to run htmlchek.pl with options checking.  (In this release of
# the htmlchek package, htmlchek.pl actually does internal options checking.)
#
nonvar='NO'
for px
do
 case $px
 in *=* ) if   test $nonvar = 'YES'
          then echo "Error: An option=value argument $px followed" >&2
               echo "a filename argument on the command line." >&2
               exit 1
          else
            case $px
            in append=* | arena=* | configfile=* | deprecated=* |\
               dirprefix=* | dlstrict=* | html3=* | htmlplus=* | loosepair=* |\
               lowlevelnonpair=* | lowlevelpair=* | map=* | metachar=* |\
               netscape=* | nogtwarn=* | nonblock=* | nonpair=* |\
               nonrecurpair=* | novalopts=* | nowswarn=* | refsfile=* |\
               reqopts=* | strictpair=* | subtract=* | sugar=* | tagopts=* |\
               usebase=* | xref=* | cf=* | inline=* | lf=* | listfile=* ) ;;
             * ) echo "Error: In the option=value argument $px, the part" >&2
                 echo "before the equals sign \`=' is not a recognized option." >&2
                 exit 1;;
            esac
          fi;;
      * ) nonvar='YES';;
 esac
done
#
case ${HTMLCHEK:-"/"}
    in */ ) ;;
       * ) HTMLCHEK="$HTMLCHEK/";;
esac
if test -s ${HTMLCHEK}htmlchek.pl
then
    echo "Checking file(s) now... (using perl)" >&2
    perl ${HTMLCHEK}htmlchek.pl $@
    if test $? -ne 0
    then echo "Note: there was apparently an error in running perl" >&2
         exit 1
    fi
else
    echo "htmlchek.pl is not found.  Either copy it to the current directory, or
set the environment variable HTMLCHEK to the pathname where it is located.
Do \`setenv HTMLCHEK /somedir/' in csh and tcsh, \`HTMLCHEK=/somedir/;
export HTMLCHEK' in sh and its offspring." >&2
    exit 1
fi
exit 0
