#!/bin/sh
#
# Shell script to run dehtml.awk under the best available awk interpreter, and
# avoid problems of invoking old awk, if possible.
#
case `type gawk` in *gawk ) awkntrp='gawk';;
                        * ) case `type nawk` in *nawk ) awkntrp='nawk';;
                                                    * ) awkntrp='awk';;
                            esac;;
esac
case ${HTMLCHEK:-"/"}
    in */ ) ;;
       * ) HTMLCHEK="$HTMLCHEK/";;
esac
if test -s ${HTMLCHEK}dehtml.awk
then
    for px
    do
    case $px
    in -?* ) echo "You are passing flags to the $awkntrp interpreter in argument $px" >&2
             echo "(This may not be what you intended)" >&2 ;;
        * ) ;;
    esac
    done
    echo "Stripping mark-up from file(s) now... (using $awkntrp)" >&2
    $awkntrp -f ${HTMLCHEK}dehtml.awk $@
else
    echo "dehtml.awk is not found.  Either copy it to the current directory, or
set the environment variable HTMLCHEK to the pathname where it is located.
Do \`setenv HTMLCHEK /somedir/' in csh and tcsh, \`HTMLCHEK=/somedir/;
export HTMLCHEK' in sh and its offspring." >&2
    exit 1
fi
exit 0
