#!/bin/sh
#
# Shell script to run HTML cross-reference checking with htmlchek.pl
#
case ${HTMLCHEK:-"/"}
    in */ );;
       * ) HTMLCHEK="$HTMLCHEK/";;
esac
if test $# -lt 2
then
    echo "
 Syntax is:  $0 directoryprefix outfileprefix [directory] [options]
" >&2
cat >&2 << '_EOHERE_'
 The optional third parameter specifies the top directory of the tree in which
all .html files are to be checked (for example, "$HOME/public_html"); if this
is not present, then the current directory is used.  The first parameter
``directoryprefix'' is how this top directory is referenced in <...HREF="...">
links in files in subordinate directories in the tree (for example, as
"/~myself/" or "http://myhost.edu/~myself/").  If the files you are checking
refer to each other only with simple relative URL's (i.e. with no access
method or hostname specified, and not beginning with `/'), then you can get
away with specifying ``directoryprefix'' as a null string ('').

 The second parameter ``outfileprefix'' is the name of the files (with the
extensions ".NAME", ".HREF", ".SRC", and ".ERR") in which the ouput of the
HTML-checking and cross-referencing process will be put.  And finally, the
optional parameters are all of the form "option=value", as explained in the
docs.  So the following are some typical command lines (putting
_EOHERE_
 echo "$0 first in a command, as in the first example, implies that
you have set execute permission by running \"chmod +x $0\"):

  $0  http://uts.cc.utexas.edu/~churchh/  check

  sh  $0  ''  out  \$HOME/public_html  html3=1" >&2
    exit 1
else
    if test -s ${HTMLCHEK}htmlchek.pl
    then
     case $1
     in *?=* ) echo "Error: dirprefix parameter  $1  is in option=value form" >&2
               exit 1;;
     esac
     case $2
     in *?=* ) echo "Error: outfilesname parameter  $2  is in option=value form" >&2
               exit 1;;
     esac
    dprefix=$1
    oprefix=$2
    shift 2
    if test $# -ge 1
    then
        case $1
             in *=* ) targdir='';;
                  * ) targdir=$1
                      shift;;
        esac
    else
        targdir=''
    fi
    case ${dprefix:-"/"}
        in */ ) ;;
            * ) dprefix="$dprefix/";;
    esac
    case $dprefix
         in ?* ) dprefix="dirprefix=$dprefix";;
             * ) ;;
    esac
    case $targdir
        in */ ) echo "Error: Target directory name  $targdir  should not have trailing slash" >&2
                exit 1;;
           ?* ) subopt="subtract=${targdir}/";;
            * ) subopt='';;
    esac
    for px
    do
    case $px
    in append=* | arena=* | cf=* | configfile=* | deprecated=* |\
    dlstrict=* | html3=* | htmlplus=* | loosepair=* |\
    lowlevelnonpair=* | lowlevelpair=* | map=* | metachar=* |\
    netscape=* | nogtwarn=* | nonblock=* | nonpair=* |\
    nonrecurpair=* | novalopts=* | nowswarn=* | reqopts=* |\
    strictpair=* | sugar=* | tagopts=* | usebase=* ) ;;
       * ) echo "Error: The argument  $px  is not in option=value form, where," >&2
           echo "the part before the equals sign \`=' is a recognized option." >&2
           exit 1;;
    esac
    done
    echo "Checking all .html files in and under ${targdir:-`pwd`} now... (using perl)" >&2
perl ${HTMLCHEK}htmlchek.pl $dprefix xref=1 refsfile=$oprefix $subopt $@ `find ${targdir:-"."} -name \*.html -print` > $oprefix.ERR
    if test $? -ne 0
    then echo "Note: there was apparently an error in running perl" >&2
         exit 1
    fi
    if test ! \( -s $oprefix.NAME -a -s $oprefix.HREF -a -s $oprefix.SRC -a -s $oprefix.ERR \)
    then echo "Was some error on output files; Exiting..." >&2
         exit 1
    fi
    echo "Errorcheck data is in the file $oprefix.ERR; locations in the specified
 files which are not referenced from the files are in $oprefix.NAME,
 references from the specified files which are not found in the files are
 in $oprefix.HREF, and references to inline images are in $oprefix.SRC;
 if the map=1 option was specified, cross-dependency information is in
 $oprefix.MAP" >&2
    else echo "
htmlchek.pl is not found.  Either copy it to the current directory, or
set the environment variable HTMLCHEK to the pathname where it is located.
Do \`setenv HTMLCHEK /somedir/' in csh and tcsh, \`HTMLCHEK=/somedir/;
export HTMLCHEK' in sh and its offspring." >&2
         exit 1
    fi
fi
exit 0
