@echo off
cls

if exist inwin.exe goto :rightplace

echo.
echo The current drive and directory is not the update directory.
echo You must invoke the updater from its directory. For example, if
echo you typed "b:\update" you must instead type "b:", then "cd\",
echo then "update".
echo.
echo Also, please remember that the updater cannot run from a Windows
echo DOS session. You must exit windows before running the updater.
echo.
pause
goto :end

:rightplace

inwin

if ERRORLEVEL = 100 goto E100
goto :begin

:E100
echo.
echo Windows is currently running.  You MUST exit Windows to use this!!!
echo.
pause
goto END

:begin
echo.
Echo Copyright 1993 Berkeley Systems Inc.  All rights reserved.
Echo After Dark Updater: Updates version 2.0, 2.0a, 2.0b to 2.0c.
echo Original version by Sean Turino. Final version by Paul Meyer.
echo.
if "%2"=="" goto :defaults

set _up_ad=%1
set _up_win=%2
echo.
echo Afterdark directory is: %_up_ad%
echo Windows directory is:   %_up_win%
echo.

goto :test

:defaults
set _up_ad=c:\afterdrk
set _up_win=c:\windows
echo.
echo Using the normal locations, C:\AFTERDRK for your AfterDark dirictory 
echo and C:\WINDOWS for your Windows directory. If either of these is 
echo obviously incorrect please hit "<control+break>" and then type "Y" 
echo to exit the batch file.  Type "README" to view information pertaining 
echo to your particular installation.  Otherwise press any key to continue
echo.

:test
if not exist %_up_ad%\ad.exe echo The Afterdark directory is incorrect    
if not exist %_up_win%\win.com echo The Windows directory is incorrect.  
if not exist %_up_ad%\ad.exe goto :badargs
if not exist %_up_win%\win.com goto :badargs
goto :update

:badargs
echo.
echo Please type UPDATE <Your After Dark directory> <Your Windows directory>.
echo For example: "UPDATE C:\win_apps\afterdrk d:\win31"
echo.
goto :end

:update 
tester %_up_ad%\ad.exe
if errorlevel 255 goto :canthappen
if errorlevel 5 goto :newer
if errorlevel 4 goto :already
if errorlevel 3 goto :v20b 
if errorlevel 2 goto :v20a
if errorlevel 1 goto :v20
goto :unknown

:v20b
set _up_scr=20c_adb.rtp
goto :got_ver

:v20a
set _up_scr=20c_ada.rtp
goto :got_ver

:v20
set _up_scr=20c_adx.rtp
goto :got_ver

:got_ver

pause

copy %_up_scr% %_up_ad%
copy 20C_AF.RTP %_up_ad%
copy 20C_AW.RTP %_up_ad%
if exist %_up_ad%\st_res\nul copy adbmp.rtp %_up_ad%
copy sn.dat %_up_ad%
copy patch.exe %_up_ad%

%_up_ad%\patch.exe %_up_scr% %_up_ad% > %_up_ad%\update.log
if errorlevel 1 goto :patchfail
%_up_ad%\patch.exe 20C_AF.RTP %_up_ad% >> %_up_ad%\update.log
if errorlevel 1 goto :patchfail
if exist c:\%_up_ad%\at_res\nul c:\%_up_ad%\patch.exe adbmp.rtp c:\%_up_ad% >> %_up_ad%\update.log
if errorlevel 1 goto :patchfail
%_up_ad%\patch.exe 20C_AW.RTP %_up_win% >> %_up_ad%\update.log
if errorlevel 1 goto :patchfail

del %_up_ad%\%_up_scr%
del %_up_ad%\20C_AF.RTP
del %_up_ad%\20C_AW.RTP 
del %_up_ad%\sn.dat
if exist %_up_ad%\adbmp.rtp del %_up_ad%\adbmp.rtp
del %_up_ad%\patch.exe

IF EXIST %_up_win%\ad.cfg del %_up_win%\ad.cfg
goto :end

:patchfail
echo.
echo Something went wrong during the update. The file %_up_ad%\update.log
echo contains some information about the problem. If this information is
echo insufficient please call Berkeley Systems Windows Technical Support
echo and have the contents of that file available for reference.
echo.
pause > nul
goto :end


:canthappen
echo CAN'T HAPPEN in updater script. Call Berkeley Systems for help.
pause > nul
goto :end

:newer
echo Your installed version of After Dark is apparently NEWER than 2.0c.
echo This updater is of no use to you.
pause > nul
goto :end

:already
echo You already seem to be running After Dark version 2.0c. This updater
echo is of no use to you.
pause > nul
goto :end

:unknown
echo Unable to retrieve old version number. This updater only works on 
echo After Dark for Windows versions 2.0, 2.0a, and 2.0b, including the
echo After Dark Star Trek Edition. If you have After Dark for Windows
echo version 1.0 or 1.0a you will need to purchase the upgrade from
echo Berkeley Systems for $14.95. Call 1-800-877-5535 and ask for the
echo Upgrade Department.
pause > nul
goto :end

:end
set _up_ad=
set _up_win=
set _up_scr=
