/* FRANCAIS.CMD : Installation de PLUMA version franaise. */

'@Echo Off'

/* Nom de l'objet  installer */

Title = 'Pluma 1.12'


/* Chargement de REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisations */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation de PLUMA...'
Say ''


/* Vrification de l'existance des diffrents fichiers */

Language = 'FRANCAIS'

Result = SysFileTree( 'PLUMA.EXE', 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERREUR : PLUMA.EXE introuvable !'
   Signal DONE
   End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERREUR : 'Language'.DLL introuvable !'
   Signal DONE
   End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
   Do
   Say 'ERREUR : 'Language'.HLP introuvable !'
   Signal DONE
   End

/* Saisie du rpertoire de destination */

Say 'Veuillez saisir le nom complet du rpertoire o PLUMA'
Say '  doit tre install (par dfaut, C:\OS2\APPS) : '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Si ncessaire, cration du rpertoire destination */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
   Do
   Result = SysMkDir( Directory )
   if Result == 0 Then
      Do
      End
   Else
      Do
      Say 'ERREUR : Impossible de crer le rpertoire destination.'
      Signal DONE
      End
   End
Say ''


/* Installation. */

Say 'Copie de PLUMA dans ' Directory '...'
Copy PLUMA.EXE Directory                   '1>NUL'
Copy PLUMA.ICO Directory                   '1>NUL'
Copy Language".DLL" Directory"\PLUMA.DLL"  '1>NUL'
Copy Language".HLP" Directory"\PLUMA.HLP"  '1>NUL'
Copy Language".DOC" Directory"\PLUMA.DOC"  '1>NUL'

Result = SysFileTree( Language".INF", 'Files', 'F' )
If Files.0 > 0 Then
Do
   Copy Language".INF" Directory"\PLUMA.INF"  '1>NUL'
End

Say 'Cration du dossier...'
Type = 'WPFolder'
Folder = '<WP_DESKTOP>'
Parms = "OPEN=ICON;OBJECTID=<PLUMAF>;ICONFILE="Directory"\PLUMA.ICO;"
Result = SysCreateObject( Type, 'Pluma', Folder, Parms, 'ReplaceIfExists' )
If Result != 1 Then
   Say 'ERREUR : Le dossier n'D2C(39)'a pas t cr.'

Say 'Cration de l'D2C(39)'objet programme...'
Type = 'WPProgram'
Folder = '<PLUMAF>'
Parms = "MINWIN=DESKTOP;PROGTYPE=PM;EXENAME="Directory"\PLUMA.EXE;STARTUPDIR="Directory";OBJECTID=<PLUMA>;NOPRINT=YES;ASSOCTYPE=Pluma;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result != 1 Then
   Say 'ERREUR : L'D2C(39)'objet n'D2C(39)'a pas t cr.'

Say 'Cration des objets documentation...'
Type = 'WPShadow'
Parms = "SHADOWID="Directory"\PLUMA.DOC;OBJECTID=<PLUMAD>;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result != 1 Then
   Say 'ERREUR : L'D2C(39)'objet documentation n'D2C(39)'a pas t cr.'

Result = SysFileTree( Directory"\PLUMA.INF", 'Files', 'F' )
If Files.0 > 0 Then Do
   Parms = "SHADOWID="Directory"\PLUMA.INF;OBJECTID=<PLUMAI>;"
   Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
   If Result != 1 Then Do
      Say 'ERREUR : L'D2C(39)'objet documentation n'D2C(39)'a pas t cr.'
      End
   End

Signal DONE

FAILURE:
Say 'chec REXX.'
Signal DONE

HALT:
Say 'Halte REXX.'
Signal DONE

SYNTAX:
Say 'REXX erreur de syntaxe.'
Signal DONE

DONE:
Exit
