/*  wppic\install.cmd 1994-08-18 - 1996-09-05 mjb  */

    version = '1.1'
    vdate = '1996-09-05'

    classname = 'WPPicture';

    dllfname = 'wppic.dll'
    hlpfname = 'wppic.hlp'
    templatefname = 'pic???'

    call rxfuncadd 'sysdrivemap', 'rexxutil', 'sysdrivemap'
    call rxfuncadd 'sysfilesearch', 'rexxutil', 'sysfilesearch'
    call rxfuncadd 'sysqueryclasslist', 'rexxutil', 'sysqueryclasslist'
    call rxfuncadd 'syssearchpath', 'rexxutil', 'syssearchpath'
    call rxfuncadd 'sysregisterobjectclass', 'rexxutil', 'sysregisterobjectclass'
    call rxfuncadd 'systempfilename', 'rexxutil', 'systempfilename'

    if stream(dllfname,'c','query exists') = '' | stream(hlpfname,'c','query exists') = 0 then do
        call lineout , 'Could not find required files for installation.  Make sure that'
        call lineout , dllfname 'and' hlpfname 'are in the current directory and'
        call lineout , 're-run the installation program.'
        signal abort
        end

    call setlocal

    call lineout , 'WPPicture Installation v'version vdate
    call lineout , 'Copyright (C) 1995-1996 Michael J. Barillier, All Rights Reserved.'
    call lineout , ''

    bootdrive = ''
    drives = sysdrivemap('C:','LOCAL')
    do while drives <> ''
        parse var drives drive drives
        testconfigsysfname = drive'\config.sys'
        if stream(testconfigsysfname,'c','query exists') <> '' then do
            bootdrive = drive
            leave
            end
        end
    if bootdrive = '' then do
        call lineout , 'Could not find config.sys.'
        signal abort
        end

    configsysfname = bootdrive'\config.sys'

    call sysfilesearch 'LIBPATH=', configsysfname, 'lines', 'C'
    do i = 1 to lines.0
        if substr(lines.i,1,8) = 'LIBPATH=' then leave
        end
    if i > lines.0 then do
        call lineout , 'Could not find LIBPATH statement in' configsysfname'.'
        signal abort
        end
    address cmd '@set TMPLIBPATH='substr(lines.i,9)

    call sysqueryclasslist 'classes'
    do i = 1 to classes.0
        if word(classes.i,1) = classname then leave
        end
    if i > classes.0 then
        call newinstall
      else
        call replaceexisting

    call endlocal

    return 0

abort:

    exit 10

newinstall:

    call charout , 'Installing ... '

    pmwpfname = syssearchpath('TMPLIBPATH','pmwp.dll')
    if pmwpfname = '' then do
        call lineout , 'Could not locate system .DLLs.'
        signal abort
        end

    destdllfname = filespec('d',pmwpfname) || filespec('p',pmwpfname) || dllfname

    wphelpfname = syssearchpath('HELP','wphelp.hlp')
    if wphelpfname = '' then do
        call lineout , 'Could not locate system help files.'
        signal abort
        end

    desthlpfname = filespec('d',wphelpfname) || filespec('p',wphelpfname) || hlpfname

    address cmd '@copy >nul' dllfname destdllfname
    address cmd '@copy >nul' hlpfname desthlpfname

    call sysregisterobjectclass classname, destdllfname

    call lineout , 'Installation completed.'

    return

replaceexisting:

    call charout , 'Installing ... '

    configbakfname = systempfilename(bootdrive'\config.???')
    cmdfname = systempfilename(bootdrive'\'templatefname'.cmd')

    cmdexefname = syssearchpath('PATH','cmd.exe')

    tempdllfname = systempfilename(templatefname'.dll')
    address cmd '@ren' dllfname tempdllfname
    destdllfname = syssearchpath('TMPLIBPATH',dllfname)
    address cmd '@ren' tempdllfname dllfname
    if destdllfname = '' then do
        pmwpfname = syssearchpath('TMPLIBPATH','pmwp.dll')
        if pmwpfname = '' then do
            call lineout , 'Could not locate system .DLLs.'
            signal abort
            end
        destdllfname = filespec('d',pmwpfname) || filespec('p',pmwpfname) || dllfname
        end

    tempdllfname = systempfilename(bootdrive'\'templatefname'.dll')

    temphlpfname = systempfilename(templatefname'.hlp')
    address cmd '@ren' hlpfname temphlpfname
    desthlpfname = syssearchpath('HELP',hlpfname)
    address cmd '@ren' temphlpfname hlpfname
    if desthlpfname = '' then do
        wphelpfname = syssearchpath('HELP','wphelp.hlp')
        if wphelpfname = '' then do
            call lineout , 'Could not locate system help files.'
            signal abort
            end
        desthlpfname = filespec('d',wphelpfname) || filespec('p',wphelpfname) || hlpfname
        end

    temphlpfname = systempfilename(bootdrive'\'templatefname'.hlp')

    address cmd '@copy >nul' dllfname tempdllfname
    address cmd '@attrib >nul +h' tempdllfname

    address cmd '@copy >nul' hlpfname temphlpfname
    address cmd '@attrib >nul +h' temphlpfname

    address cmd '@copy >nul' configsysfname configbakfname
    address cmd '@attrib >nul +h' configbakfname

    call lineout cmdfname, "attrib -h" tempdllfname
    call lineout cmdfname, "copy" tempdllfname destdllfname
    call lineout cmdfname, "del" tempdllfname
    call lineout cmdfname, "attrib -h" temphlpfname
    call lineout cmdfname, "copy" temphlpfname desthlpfname
    call lineout cmdfname, "del" temphlpfname
    call lineout cmdfname, "attrib -h" configbakfname
    call lineout cmdfname, "copy" configbakfname configsysfname
    call lineout cmdfname, "if errorlevel 1 goto contin"
    call lineout cmdfname, "del" configbakfname
    call lineout cmdfname, ":contin"
    call lineout cmdfname, "del" cmdfname
    call lineout cmdfname, "exit"

    call lineout configsysfname, 'run=' || cmdexefname '/c' cmdfname

    call lineout , 'Installation preparation has been completed.'
    call lineout , 'Close all running programs, shut down your system and reboot to'
    call lineout , 'complete installation.'

    return
