/*****************************************************************************
 * $Id: list.c,v 2.15 1995/01/01 00:13:29 ak Exp $
 *****************************************************************************
 * $Log: list.c,v $
 * Revision 2.15  1995/01/01  00:13:29  ak
 * Umlaute im QFA-File nicht maskieren.
 * Reblock bei compressed.
 *
 * Revision 2.14  1994/11/08  20:12:23  ak
 * Optional case-sensitive compare.
 * Moved include of port.h to tar.h.
 *
 * Revision 2.13  1994/10/29  20:58:10  ak
 * Bugfix multivolume QFA.
 *
 * Revision 2.12  1994/10/19  01:56:04  ak
 * Tape directory support in buffered mode.
 * Volume labels in tape directory were wrong.
 * Alias -Q for --buffered.
 * Priority control for buffered mode.
 *
 * Revision 2.11  1994/09/07 18:45:17  edvkai
 * AIX
 *
 * Revision 2.10  1994/08/06 19:16:20  ak
 * Bugfix --substitute.
 *
 * Revision 2.9  1994/07/11 21:04:54  ak
 * Bugfix EOT.
 *
 * Revision 2.8  1994/07/05 18:45:01  edvkai
 * 2.35: Posix support for long filenames and magic name.
 *
 * Lots of changes in filename handling, I hope I found all places. Added
 * decode_filename() with result in var 'filename' for this. header.name
 * should no longer be used. The diffarch kludge FILENAME is no longer
 * necessary.
 *
 * Treatment of links is not up-to-date, I fear - what's defined by Posix
 * about long link names?
 *
 * Due to NONAMES, prior versions created "oldarch" style archives without
 * magic name. Now magic is "ustar\0""00" for Posix and "ustar  \0" else.
 *
 * Unused header space is used to support multi-volume archives in Posix -
 * THIS IS SPECIFIC TO GTAK.
 *
 * Note that Posix conflicts with atime/ctime.
 *
 * Revision 2.7  1994/07/05 14:56:26  edvkai
 * Access Control Lists.
 *
 * Added --substitute, allows redirection of UNC names. No support for links yet.
 *
 * Streamlined absolute path treatment. No skipcrud any more.
 *
 * Bugfix: If a directory existed, EAs were not attached.
 *
 * Revision 2.6  1994/06/02 13:43:24  ak
 * Skip to end of archive when an EOF record is encountered while reading
 * a tape. Now a subsequent TAR run reads the next archive, not the
 * filemark.
 *
 * Revision 2.5  1994/01/01 11:02:57  ak
 * Both SCO UNIX and AIX TAR create header checksums interpreting
 * filename characters above 127 as signed values. So accept both
 * signed and unsigned checksum when reading and create signed
 * checksum on request (--signed-checksum). I don't know what the
 * standard defines.
 *
 * Revision 2.4  1993/12/03  13:19:32  edvkai
 * Bugfix checkpoint.
 *
 * Revision 2.3  1993/11/29  17:02:43  edvkai
 * Multivolume QFA fixes.
 * Smaller size of tape directory.
 *
 * Revision 2.2  1993/11/25  20:23:44  edvkai
 * Major QFA changes.
 *
 * QFA now supports both block id and relative addressing. Relative
 * addressing is more efficient with short distances. 4mm and 8mm devices
 * do well with relative addressing only. For the sake of QIC tapes, TAR
 * optimizes QFA using block ids for large distances.
 *
 * The format of the tape-directory changed. No longer compatible to prior
 * versions. Maybe I'll add a utility for conversion.
 *
 * Rmt interface changed. Now using block numbers instead of byte offsets
 * for seek. Previously the lseek limitation to 2GB limited QFA archive
 * capacity. Changed rmtlseek to rmtseek to indicate that it is different.
 *
 * QFA should be able to handle multi-volume archives now.
 *
 * If a volume name is specified on the command line, QFA skips archives
 * having a different volume name.
 *
 * Code for header pretty-printing cleaned. Doesn't depend on hstat any
 * longer and requires less globals. No explanation text behind names in
 * tape directory.
 *
 * A few bugfixes.
 *
 * Revision 2.1  1993/08/08  19:08:37  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.1.1.2  1993/08/08  17:50:42  ak
 * - Network tape access.
 * - Dynamically loaded modules for disk/scsi/network interfaces.
 *
 * Revision 1.10  1992/10/31  06:54:55  ak
 * Modified -G (again) to specify the generation of increment.
 *
 * Revision 1.9  1992/10/25  10:20:28  ak
 * Don't archive/extract ctime+atime if a single -p or --same-perm is
 * specified. It make trouble on incremental backups and file transfers.
 * Added an option --all-timestamps or twice -p to archive/extract
 * ctime+atime.
 *
 * Revision 1.8  1992/09/29  09:55:47  ak
 * K.U.R., once again :-)
 * - removed a dup() in buffer.c
 * - EMX opendir with hidden/system test in gnu.c (...dotdot)
 *
 * Revision 1.7  1992/09/26  08:32:05  ak
 * *** empty log message ***
 *
 * Revision 1.6  1992/09/21  08:06:07  ak
 * K.U.R.'s fix for --checkpoints
 *
 * Revision 1.5  1992/09/20  07:47:03  ak
 * Fixes from Kai Uwe Rommel
 *   --checkpoints instead of --semi-verbose (1.11)
 *   -g filenames
 *
 * Revision 1.4  1992/09/12  15:57:33  ak
 * - Usenet patches for GNU TAR 1.10
 * - Bugfixes and patches of Kai Uwe Rommel:
 *         filename conversion for FAT
 *         EMX 0.8e
 *         -0..1 alias for a: b:
 *         -2..7 alias for +++TAPE$x
 *
 * Revision 1.3  1992/09/09  14:25:51  ak
 * K.U.R: save atime/mtime when -p is given
 *
 * Revision 1.2  1992/09/02  20:08:13  ak
 * Version AK200
 * - Tape access
 * - Quick file access
 * - OS/2 extended attributes
 * - Some OS/2 fixes
 * - Some fixes of Kai Uwe Rommel
 *
 * Revision 1.1.1.1  1992/09/02  19:21:51  ak
 * Original GNU Tar 1.10 with some filenames changed for FAT compatibility.
 *
 * Revision 1.1  1992/09/02  19:21:49  ak
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: list.c,v 2.15 1995/01/01 00:13:29 ak Exp $";

/*
 * Modified by Andreas Kaiser July 92.
 * See CHANGES.AK for info.
 */

/* List a tar archive.
   Copyright (C) 1988 Free Software Foundation

This file is part of GNU Tar.

GNU Tar is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Tar is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Tar; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * List a tar archive.
 *
 * Also includes support routines for reading a tar archive.
 *
 * this version written 26 Aug 1985 by John Gilmore (ihnp4!hoptoad!gnu).
 *
 * @(#)list.c 1.31 11/5/87 - gnu
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef	MSDOS
#include <sys/file.h>
#endif	/* MSDOS */

#ifdef USG
#include <sys/sysmacros.h>	/* major() and minor() defined here */
#endif

char *ctime();				/* From libc.a */

#define	isodigit(c)	( ((c) >= '0') && ((c) <= '7') )

#include "tar.h"
#include "rmt.h"

extern FILE *msg_file;

long from_oct();			/* Decode octal number */
void demode();				/* Print file mode */

union record *head;			/* Points to current archive header */
struct stat hstat;			/* Stat struct corresponding */
int head_standard;			/* Tape header is in ANSI format */

void print_header();
void skip_file();
void skip_extended_headers();

extern char *quote_copy_string();


/*
 * Main loop for reading an archive.
 */
void
read_and(do_something)
	void (*do_something)();
{
	int status = 3;			/* Initial status at start of archive */
	int prev_status;
	extern time_t new_time;
	char save_linkflag;
	
	name_gather();			/* Gather all the names */
	open_archive(1);		/* Open for reading */

	for(;;) {
		prev_status = status;
		status = read_header();
		switch (status) {

		case 1:			/* Valid header */
			decode_filename(head);
			if (   !name_match(filename)
 			    || (f_new_files && hstat.st_mtime<new_time)
 			    || (f_exclude && check_exclude(filename))) {

				int isextended = 0;

				if(   head->header.linkflag==LF_VOLHDR
 				   || head->header.linkflag==LF_MULTIVOL
				   || head->header.linkflag==LF_NAMES) {
					(*do_something)();
					continue;
				}

                                /* If we're showing verbose non-progress
                                   reports, print the name.  */
                                if (f_show_omitted_dirs
                                    && head->header.linkflag == LF_DIR)
                                  printf ("Omitting %s\n", filename);

				/* Skip past it in the archive */
				if (head->header.isextended)
					isextended = 1;
				save_linkflag = head->header.linkflag;
				userec(head);
				if (isextended) {
/*					register union record *exhdr;

					for (;;) {
					    exhdr = findrec();
					    if (!exhdr->ext_hdr.isextended) {
					    	userec(exhdr);
					    	break;
					    }
					}
					userec(exhdr);*/
					skip_extended_headers();
				}
				/* Skip to the next header on the archive */
				if(save_linkflag != LF_DIR)
					skip_file((long)hstat.st_size);
				continue;

			}

			(*do_something)();
			continue;

			/*
			 * If the previous header was good, tell them
			 * that we are skipping bad ones.
			 */
		case 0:			/* Invalid header */
			userec(head);
			switch (prev_status) {
			case 3:		/* Error on first record */
				msg("Hmm, this doesn't look like a tar archive.");
				/* FALL THRU */
			case 2:		/* Error after record of zeroes */
			case 1:		/* Error after header rec */
				msg("Skipping to next file header...");
			case 0:		/* Error after error */
				break;
			}
			continue;

		case 2:			/* Record of zeroes */
			userec(head);
			status = prev_status;	/* If error after 0's */
			if (f_ignorez)
				continue;
			else if (_isrmt(archive))
				rmtseek(archive, 0L, 2);
			/* FALL THRU */
		case EOF:		/* End of archive */
			break;
		}
		break;
	};

	close_archive();
	names_notfound();		/* Print names not found */
}		


/*
 * Print a header record, based on tar options.
 */
void
list_archive()
{
	int	isextended = 0; /* Flag to remember if head is extended */
	
	/* Save the record */
	saverec(&head);

	/* Print the header record */
	if (f_verbose) {
		if (f_verbose > 1 || f_map_file)
			decode_header(head, &hstat, &head_standard, 0);
		print_header(head);
	}

	if(f_gnudump && head->header.linkflag==LF_DUMPDIR) {
		size_t	size, written, check;
		char	*data;
		extern int errno;

		userec(head);
		if(f_multivol) {
			save_name = head->header.name;
			save_totsize=hstat.st_size;
		}
		for(size = hstat.st_size;size>0;size-=written) {
			if(f_multivol)
				save_sizeleft=size;
			data = findrec()->charptr;
			if(data==NULL) {
				msg("EOF in archive file?");
				break;
			}
			written = endofrecs()->charptr - data;
			if(written>size)
				written=size;
			errno=0;
			check=fwrite(data,sizeof(char), written, msg_file);
			userec((union record *)(data+written - 1));
			if(check!=written) {
				msg_perror("only wrote %ld of %ld bytes to file %s",check, written,head->header.name);
				skip_file((long)(size)-written);
				break;
			}
		}
		if(f_multivol)
			save_name = 0;
		saverec((union record **) 0);	/* Unsave it */
		fputc('\n',msg_file);
		fflush(msg_file);
		return;

	}
	saverec((union record **) 0);	/* Unsave it */
	/* Check to see if we have an extended header to skip over also */
	if (head->header.isextended) 
		isextended = 1;
		
	/* Skip past the header in the archive */
	userec(head);

	/*
 	 * If we needed to skip any extended headers, do so now, by
 	 * reading extended headers and skipping past them in the 
	 * archive.
	 */
	if (isextended) {
/*		register union record *exhdr;

		for (;;) {
			exhdr = findrec();

			if (!exhdr->ext_hdr.isextended) {
				userec(exhdr);
				break;
			}
			userec(exhdr);
		}*/
		skip_extended_headers();
	}
			
	if(f_multivol)
		save_name=head->header.name;
	/* Skip to the next header on the archive */
		
	skip_file((long) hstat.st_size);
		
	if(f_multivol)
		save_name = 0;
}


/*
 * Read a record that's supposed to be a header record.
 * Return its address in "head", and if it is good, the file's
 * size in hstat.st_size.
 *
 * Return 1 for success, 0 if the checksum is bad, EOF on eof,
 * 2 for a record full of zeros (EOF marker).
 *
 * You must always userec(head) to skip past the header which this
 * routine reads.
 */
int
read_header()
{
	register int	i;
	register long	sum1, sum2, recsum;
	register char	*p;
	register union record *header;
	long	from_oct();

	header = findrec();
	head = header;		/* This is our current header */
	if (NULL == header)
		return EOF;

	recsum = from_oct(8,  header->header.chksum);

	sum1 = sum2 = 0;
	p = header->charptr;
	for (i = sizeof(*header); --i >= 0; ++p) {
		sum1 += (*p & 0x80) ? (~0xFF | *p) : (0xFF & *p);
		sum2 += 0xFF & *p;
	}

	/* Adjust checksum to count the "chksum" field as blanks. */
	for (i = sizeof(header->header.chksum); --i >= 0;) {
		sum1 -= header->header.chksum[i];
		sum2 -= header->header.chksum[i];
	}
	sum1 += ' '* sizeof header->header.chksum;	
	sum2 += ' '* sizeof header->header.chksum;	

	if (sum1 == recsum || sum2 == recsum) {
		/*
		 * Good record.  Decode file size and return.
		 */
		if (header->header.linkflag == LF_LINK)
			hstat.st_size = 0;	/* Links 0 size on tape */
		else
			hstat.st_size = from_oct(1+12, header->header.size);
		return 1;
	}

	if (sum2 == 8*' ') {
		/*
		 * This is a zeroed record...whole record is 0's except
		 * for the 8 blanks we faked for the checksum field.
		 */
		return 2;
	}

	return 0;
}


/* 
 * Decode things from a file header record into a "struct stat".
 * Also set "*stdp" to !=0 or ==0 depending whether header record is "Unix
 * Standard" tar format or regular old tar format.
 *
 * read_header() has already decoded the checksum and length, so we don't.
 *
 * If wantug != 0, we want the uid/group info decoded from Unix Standard
 * tapes (for extraction).  If == 0, we are just printing anyway, so save time.
 *
 * decode_header should NOT be called twice for the same record, since the
 * two calls might use different "wantug" values and thus might end up with
 * different uid/gid for the two calls.  If anybody wants the uid/gid they
 * should decode it first, and other callers should decode it without uid/gid
 * before calling a routine, e.g. print_header, that assumes decoded data.
 */
decode_header(header, st, stdp, wantug)
	register union record	*header;
	register struct stat	*st;
	int	*stdp;
	int	wantug;
{
	int i;
	long from_oct();

	st->st_mode = from_oct(8,  header->header.mode);
	st->st_mtime = from_oct(1+12, header->header.mtime);
	if(!f_posix && (f_gnudump || f_all_timestamps))
	{
		st->st_atime = from_oct(1+12, header->header.atime);
		st->st_ctime = from_oct(1+12, header->header.ctime);
	}
	
	if (memcmp(header->header.magic, TMAGIC, 5) == 0) {
		/* Unix Standard tar archive */
		*stdp = 1;
		if (wantug) {
#ifdef NONAMES
			st->st_uid = from_oct(8,  header->header.uid);
			st->st_gid = from_oct(8,  header->header.gid);
#else
			st->st_uid = finduid(header->header.uname);
			st->st_gid = findgid(header->header.gname);
#endif
		}
		switch (header->header.linkflag) {
		case LF_BLK: case LF_CHR:
		    st->st_rdev = makedev(from_oct(8, header->header.devmajor),
			 		  from_oct(8, header->header.devminor));
		}
	} else {
		/* Old fashioned tar archive */
		*stdp = 0;
		st->st_uid = from_oct(8,  header->header.uid);
		st->st_gid = from_oct(8,  header->header.gid);
		st->st_rdev = 0;
	}
}

decode_filename(union record *header)
{
	f_posix = memcmp(header->header.magic, TMAGIC_POSIX, 6) == 0;

	/*
	 * Extract filename.
	 */
	if (f_posix && header->posix.prefix[0]) {
		int i = f_absolute_paths ? 0 : skipabs(header->posix.prefix);
		strncpy(filename, header->posix.prefix+i, PREFIX-i);
		filename[PREFIX-i] = '\0';
		strcat(filename, "/");
		strncat(filename, header->posix.name, NAMSIZ);
	} else {
		int i = f_absolute_paths ? 0 : skipabs(header->header.name);
		if (header->header.name[NAMSIZ-1]) {
			memcpy(filename, header->header.name+i, NAMSIZ-i);
			filename[NAMSIZ-i] = '\0';
		} else
			strcpy(filename, header->header.name+i);
	}

	/*
	 * Substitute filename.
	 */
	if (f_substitute && memcmp(filename, subst_from, subst_from_len) == 0) {
		char *cp = filename + subst_from_len;
		memmove(filename+subst_to_len, cp, strlen(cp)+1);
		memcpy(filename, subst_to, subst_to_len);
	}
}


/*
 * Quick and dirty octal conversion.
 *
 * Result is -1 if the field is invalid (all blank, or nonoctal).
 */
long
from_oct(digs, where)
	register int	digs;
	register char	*where;
{
	register unsigned long	value;

	while (isspace(*where)) {		/* Skip spaces */
		where++;
		if (--digs <= 0)
			return -1;		/* All blank field */
	}
	value = 0;
	while (digs > 0 && isodigit(*where)) {	/* Scan til nonoctal */
		value = (value << 3) | (*where++ - '0');
		--digs;
	}

	if (digs > 0 && *where && !isspace(*where))
		return -1;			/* Ended on non-space/nul */

	return value;
}


/* print checkpoint */
void
print_checkpoint(union record *header)
{
	static char where[FILENAME_MAX];
	char *new = header->header.name;
	char *slash = strrchr(new, '/');
	if (slash && slash[1] && strncmp(where, new, slash - new)) {
		strncpy(where, new, slash - new);
		where[slash - new] = 0;
		msg("Processing %s/", where);
	}
}

/*
 * Actually print it.
 *
 * Plain and fancy file header block logging.
 * Non-verbose just prints the name, e.g. for "tar t" or "tar x".
 * This should just contain file names, so it can be fed back into tar
 * with xargs or the "-T" option.  The verbose option can give a bunch
 * of info, one line per file.  I doubt anybody tries to parse its
 * format, or if they do, they shouldn't.  Unix tar is pretty random here
 * anyway.
 *
 * Note that print_header uses the globals <head>, <hstat>, and
 * <head_standard>, which must be set up in advance.  This is not very clean
 * and should be cleaned up.  FIXME.
 */
#define	UGSWIDTH	11		/* min width of User, group, size */
#define	DATEWIDTH	19		/* Last mod date */
static int	ugswidth = UGSWIDTH;	/* Max width encountered so far */

void
print_header2(FILE *out, union record *header, char *fname, int mode)
{
	char modes[11];
	char *timestamp;
	char uform[11], gform[11];	/* These hold formatted ints */
	char *user, *group;
	char size[24];		/* Holds a formatted long or maj, min */
	long longie;		/* To make ctime() call portable */
	int pad;
	char *name;
	extern long baserec;

	if (mode & ListCheck) {
		print_checkpoint(header);
  		return;
	}

	if (mode & ListBlock)
		fprintf(out,"rec %10d: ",baserec + (ar_record - ar_block));

	if (mode & ListLong) {
		/* File type and modes */
		modes[0] = '?';
		switch (header->header.linkflag) {
		case LF_VOLHDR:
			modes[0]='V';
			break;

		case LF_MULTIVOL:
			modes[0]='M';
			break;

		case LF_NAMES:
			modes[0]='N';
			break;

		case LF_SPARSE:
		case LF_NORMAL:
		case LF_OLDNORMAL:
		case LF_LINK:
			modes[0] = '-'; 
			if (fname[strlen(fname)-1] == '/')
				modes[0] = 'd';
			break;
		case LF_DUMPDIR:modes[0] = 'd'; break;
		case LF_DIR:	modes[0] = 'd'; break;
		case LF_SYMLINK:modes[0] = 'l'; break;
		case LF_BLK:	modes[0] = 'b'; break;
		case LF_CHR:	modes[0] = 'c'; break;
		case LF_FIFO:	modes[0] = 'p'; break;	
		case LF_CONTIG:	modes[0] = 'C'; break;
		case LF_EATTR:	modes[0] = 'A'; break;
		case LF_ACL:	modes[0] = 'L'; break;
		}

#if 1 /* AK - avoid hstat */

		demode((unsigned)from_oct(8, header->header.mode), modes+1);

		/* Timestamp */
		longie = from_oct(1+12, header->header.mtime);
		timestamp = ctime(&longie);
                if (timestamp==NULL)
			timestamp="--- --- -- --:--:-- ----\n";
		if (timestamp) {
			timestamp[16] = '\0';
			timestamp[24] = '\0';
		}

		/* User and group names */
		if (*header->header.uname && head_standard) {
			user  = header->header.uname;
		} else {
			user = uform;
			sprintf(uform, "%ld", from_oct(8, header->header.uid));
		}
		if (*header->header.gname && head_standard) {
			group = header->header.gname;
		} else {
			group = gform;
			sprintf(gform, "%ld", from_oct(8, header->header.gid));
		}

		/* Format the file size or major/minor device numbers */
		switch (header->header.linkflag) {
		case LF_CHR:
		case LF_BLK:
			sprintf(size, "%ld,%ld",
				from_oct(8, header->header.devmajor),
				from_oct(8, header->header.devmajor));
			break;
		case LF_SPARSE:
			sprintf(size, "%ld",
 				from_oct(1+12, header->header.realsize));
			break;
		default:
			sprintf(size, "%ld", 
			        from_oct(1+12, header->header.size));
		}

#else

		demode((unsigned)hstat.st_mode, modes+1);

		/* Timestamp */
		longie = hstat.st_mtime;
		timestamp = ctime(&longie);
                if (timestamp==NULL)
			timestamp="--- --- -- --:--:-- ----\n";
		if (timestamp) {
			timestamp[16] = '\0';
			timestamp[24] = '\0';
		}

		/* User and group names */
		if (*header->header.uname && head_standard) {
			user  = header->header.uname;
		} else {
			user = uform;
			(void)sprintf(uform, "%d", (int)hstat.st_uid);
		}
		if (*header->header.gname && head_standard) {
			group = header->header.gname;
		} else {
			group = gform;
			(void)sprintf(gform, "%d", (int)hstat.st_gid);
		}

		/* Format the file size or major/minor device numbers */
		switch (header->header.linkflag) {
		case LF_CHR:
		case LF_BLK:
			(void)sprintf(size, "%d,%d",
					major(hstat.st_rdev),
					minor(hstat.st_rdev));
			break;
		case LF_SPARSE:
			(void)sprintf(size, "%ld",
 				from_oct(1+12, header->header.realsize));
			break;
		case LF_EATTR:
		case LF_ACL:
			(void)sprintf(size, "%ld", 
			        from_oct(1+12, header->header.size));
			break;
		default:
			(void)sprintf(size, "%ld", (long)hstat.st_size);
		}

#endif /* AK */

		/* Figure out padding and print the whole line. */
		pad = strlen(user) + strlen(group) + strlen(size) + 1;
		if (pad > ugswidth) ugswidth = pad;

		if (mode & ListModes)
			fprintf(out, "%s %s/%s %*s%s %s %s ",
				modes,
				user,
				group,
				ugswidth - pad,
				"",
				size,
				timestamp ? timestamp+4  : "-",
				timestamp ? timestamp+20 : "-");
		else
			fprintf(out, "%c %*s%s %s %s ",
				modes[0],
				ugswidth - pad,
				"",
				size,
				timestamp ? timestamp+4  : "-",
				timestamp ? timestamp+20 : "-");

		if (!(mode & ListUnquoted) && (name = quote_copy_string(fname))) {
			fputs(name, out);
			free(name);
		} else
			fputs(fname, out);

		switch (header->header.linkflag) {
		case LF_SYMLINK:
			if (!(mode & ListUnquoted) && (name = quote_copy_string(header->header.linkname))) {
				fprintf(out, " -> %s", name);
				free(name);
			} else
				fprintf(out, " -> %s", header->header.linkname);
			break;

		case LF_LINK:
			if (!(mode & ListUnquoted) && (name = quote_copy_string(header->header.linkname))) {
				fprintf(out, " link to %s", name);
				free(name);
			} else
				fprintf(out, " link to %s", header->header.linkname);
			break;

		default:
			if (mode & ListAttr)
				fprintf(out, " unknown file type '%c'",
					header->header.linkflag);
			break;

		case LF_OLDNORMAL:
		case LF_NORMAL:
		case LF_SPARSE:
		case LF_CHR:
		case LF_BLK:
		case LF_DIR:
		case LF_FIFO:
		case LF_CONTIG:
		case LF_DUMPDIR:
			break;

		case LF_VOLHDR:
			if (mode & ListAttr)
				fprintf(out, " --Volume Header--");
			break;
			
		case LF_MULTIVOL:
			if (mode & ListAttr)
				fprintf(out, " --Continued at byte %ld--",
					from_oct(1+12, f_posix
						? header->posix.offset
						: header->header.offset));
			break;

		case LF_NAMES:
			if (mode & ListAttr)
				fprintf(out," --Mangled file names--");
			break;

		case LF_EATTR:
			if (mode & ListAttr)
				fprintf(out, " --Extended attributes--");
			break;

		case LF_ACL:
			if (mode & ListAttr)
				fprintf(out, " --Access control list--");
			break;
		}
		putc('\n', out);
	} else {
		/* Just the fax, mam. */
		if (!(mode & ListUnquoted) && (name = quote_copy_string(fname))) {
			fprintf(out, "%s\n", name);
			free(name);
		} else
			fprintf(out, "%s\n", fname);
	}
	fflush(out);
}

void
print_header(header)
	union record *header;
{
	print_header2(msg_file, header, filename,
		  (f_verbose >= 2 ? ListLong : 0)
		| (f_sayblock ? ListBlock : 0)
		| (f_checkpoints ? ListCheck : 0)
		| ListModes
		| ListAttr);
}

/*
 * Print a similar line when we make a directory automatically.
 */
void
pr_mkdir(pathname, length, mode)
	char *pathname;
	int length;
	int mode;
{
	char modes[11];
	char *name;
	extern long baserec;

	if (f_verbose > 1) {
		/* File type and modes */
		modes[0] = 'd';
		demode((unsigned)mode, modes+1);

		if(f_sayblock)
			fprintf(msg_file,"rec %10d: ",baserec + (ar_record - ar_block));
		name=quote_copy_string(pathname);
		if(!name)
			name=pathname;
		fprintf(msg_file, "%s %*s %.*s\n",
			modes,
			ugswidth+DATEWIDTH,
			"Creating directory:",
			length,
			pathname);
		if(name!=pathname)
			free(name);
	}
}


/*
 * Skip over <size> bytes of data in records in the archive.
 */
void
skip_file(size)
	register long size;
{
	union record *x;

	if(f_multivol) {
		save_totsize=size;
		save_sizeleft=size;
	}

	while (size > 0) {
		x = findrec();
		if (x == NULL) {	/* Check it... */
			msg("Unexpected EOF on archive file");
			exit(EX_BADARCH);
		}
		userec(x);
		size -= RECORDSIZE;
		if(f_multivol)
			save_sizeleft-=RECORDSIZE;
	}
}

void
skip_extended_headers()
{
	register union record *exhdr;

	for (;;) {
	    exhdr = findrec();
	    if (!exhdr->ext_hdr.isextended) {
	        userec(exhdr);
	    	break;
	    }
	    userec (exhdr);
	}
}

/*
 * Decode the mode string from a stat entry into a 9-char string and a null.
 */
void
demode(mode, string)
	register unsigned mode;
	register char *string;
{
	register unsigned mask;
	register char *rwx = "rwxrwxrwx";

	for (mask = 0400; mask != 0; mask >>= 1) {
		if (mode & mask)
			*string++ = *rwx++;
		else {
			*string++ = '-';
			rwx++;
		}
	}

	if (mode & S_ISUID)
		if (string[-7] == 'x')
			string[-7] = 's';
		else
			string[-7] = 'S';
	if (mode & S_ISGID)
		if (string[-4] == 'x')
			string[-4] = 's';
		else
			string[-4] = 'S';
	if (mode & S_ISVTX)
		if (string[-1] == 'x')
			string[-1] = 't';
		else
			string[-1] = 'T';
	*string = '\0';
}
