#ifndef __DIRENT_H__
#define __DIRENT_H__
/*
 * $Id: dirent.h,v 1.6 1993/12/08 13:59:01 edvkai Exp $
 *
 * @(#)msd_dir.h 1.4 87/11/06   Public Domain.
 *
 *  A public domain implementation of BSD directory routines for
 *  MS-DOS.  Written by Michael Rendell ({uunet,utai}michael@garfield),
 *  August 1897
 *
 *  Extended by Peter Lim (lim@mullian.oz) to overcome some MS DOS quirks
 *  and returns 2 more pieces of information - file size & attribute.
 *  Plus a little reshuffling of some #define's positions    December 1987
 *
 *  Some modifications by Martin Junius                      02-14-89
 *
 *	AK900712
 *	AK910410	abs_path - make absolute path
 *
 * $Log: dirent.h,v $
 * Revision 1.6  1993/12/08  13:59:01  edvkai
 * Removed false RCSids from log.
 *
 * Revision 1.5  1992/09/14  12:25:45  ak
 * K.U.R.'s fixes.
 *
 * Revision 1.4  1992/02/14  18:08:23  ak
 * *** empty log message ***
 *
 * Revision 1.3  1992/01/03  14:19:44  ak
 *
 * Revision 1.2  1992/01/03  13:45:12  ak
 * Zortech fixes.
 *
 * Revision 1.1.1.1  1991/12/12  16:10:27  ak
 * Initial checkin of server source, modified to contain RCS IDs.
 *
 * Revision 1.1  1991/12/12  16:10:23  ak
 * Initial revision
 *
 */

#ifdef __EMX__
#include <sys/param.h>
#else
#include <param.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define rewinddir(dirp) seekdir(dirp, 0L)

/* attribute stuff */
#ifndef A_RONLY
# define A_RONLY   0x01
# define A_HIDDEN  0x02
# define A_SYSTEM  0x04
# define A_LABEL   0x08
# define A_DIR     0x10
# define A_ARCHIVE 0x20
#endif

struct dirent {
   #ifdef _COMPLETE_
	unsignd short	d_ino;			/* a bit of a farce */
	lonh		d_off;			/* more farce */
	int		d_reclen;		/* more farce */
   #endif
	char		d_name[MAXNAMLEN + 1];	/* garentee null termination */
	char		d_attribute;		/* .. extension .. */
	unsigned long	d_size;			/* .. extension .. */
};

struct _dircontents {
	char			*_d_entry;
	char			d_attribute;
	unsigned long		d_size;
	struct _dircontents	*_d_next;
};

typedef struct _dirdesc {
	int			dd_id;		/* uniquely identify each
						   open directory */
        long			dd_loc;		/* where we are in dir entry */
	struct _dircontents	*dd_contents;	/* ptr to contents of dir */
	struct _dircontents	*dd_cp;		/* ptr to current position */
} DIR;

#ifdef NOPROTOTYPES
extern DIR		*opendir();
extern DIR		*openxdir();
extern struct dirent	*readdir();
extern void		seekdir();
extern long		telldir();
extern void		closedir();
extern char *		abs_path();
#else
extern DIR		*opendir(const char *);
extern DIR		*openxdir(const char *, unsigned);
extern struct dirent	*readdir(DIR *);
extern void		seekdir(DIR *, long);
extern long		telldir(DIR *);
extern void 		closedir(DIR *);
extern char *		abs_path(const char *name, char *buffer, int len);
#endif

#ifdef __cplusplus
}
#endif

#endif
