/*****************************************************************************
 * $Id: ak_aix.c,v 2.4 1994/11/08 20:12:12 ak Exp $
 *****************************************************************************
 * $Log: ak_aix.c,v $
 * Revision 2.4  1994/11/08  20:12:12  ak
 * Optional case-sensitive compare.
 * Moved include of port.h to tar.h.
 *
 * Revision 2.3  1994/10/29  20:58:03  ak
 * Bugfix multivolume QFA.
 *
 * Revision 2.2  1994/05/31  21:33:03  ak
 * Still there seems to be a memory leak somewhere in EMX _ead_read.
 * Didn't find it with dbmalloc though. Added EA_MODE (former EMX_EA) of
 * 2, using my own ea_* functions to load the attributes and the EMX
 * functions to manipulate them. The leak seems to be gone now. Added
 * --old-ea to allow creating the gtak 2.12 EA records.
 *
 * Revision 2.1  1993/08/08 19:06:09  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.2  1993/05/28  12:55:01  AK
 * Added GZip option.
 *
 * Revision 1.1  1993/04/26  15:16:45  AK
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: ak_aix.c,v 2.4 1994/11/08 20:12:12 ak Exp $";

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#include "tar.h"
#include "rmt.h"

#undef opendir
#include <dirent.h>

void ck_close();

/*----------------------------------------------------------------------*/
/*		Child Process Operations				*/

#define	STDIN	0		/* Standard input  file descriptor */
#define	STDOUT	1		/* Standard output file descriptor */

#define	PREAD	0		/* Read  file descriptor from pipe() */
#define	PWRITE	1		/* Write file descriptor from pipe() */

#define	MAGIC_STAT	105	/* Magic status returned by child, if
				   it can't exec.  We hope compress/sh
				   never return this status! */
static int childpid;

extern int r_error_count;

static void
movefd(int from, int to)
{
	int err;

	if (from != to) {
		err=close(to);
		if(err<0 && errno!=EBADF) {
			msg_perror("Cannot close descriptor %d",to);
			exit(EX_SYSTEM);
		}
		err = dup(from);
		if (err != to) {
			msg_perror("Cannot dup descriptor %d",from);
			exit(EX_SYSTEM);
		}
		ck_close(from);
	}
}

/* return non-zero if p is the name of a directory */
static int
isfile(char *p)
{
	struct stat stbuf;

	if(stat(p,&stbuf)<0)
		return 1;
	if((stbuf.st_mode&S_IFMT)==S_IFREG)
		return 1;
	return 0;
}

void
child_open()
{
	int pipe[2];
	int err = 0;

	int kidpipe[2];
	int kidchildpid;

	char *prog = f_zip ? "gzip" : "compress";

	ck_pipe(pipe);

	childpid = fork();
	if(childpid < 0) {
		msg_perror("cannot fork");
		exit(EX_SYSTEM);
	}
	if(childpid > 0) {
		/* We're the parent.  Clean up and be happy */
		/* This, at least, is easy */

		if(ar_reading) {
			f_reblock++;
			archive = pipe[PREAD];
			ck_close(pipe[PWRITE]);
		} else {
			archive = pipe[PWRITE];
			ck_close(pipe[PREAD]);
		}
		return;
	}

	/* We're the kid */
	if(ar_reading) {
		movefd(pipe[PWRITE], STDOUT);
		ck_close(pipe[PREAD]);
	} else {
		movefd(pipe[PREAD], STDIN);
		ck_close(pipe[PWRITE]);
	}

	/* We need a child tar only if
	   1: we're reading/writing stdin/out (to force reblocking)
	   2: the file is to be accessed by rmt (compress doesn't know how)
	   3: the file is not a plain file */
#ifdef NO_REMOTE
	if (!(ar_file[0]=='-' && ar_file[1]=='\0') && isfile(ar_file))
#else
	if (!(ar_file[0]=='-' && ar_file[1]=='\0') && !_isrmt(ar_file) && isfile(ar_file))
#endif
	{
		/* We don't need a child tar.  Open the archive */
		if (ar_reading) {
			archive = open(ar_file, O_RDONLY, 0666);
			if(archive < 0) {
				msg_perror("can't open archive %s", ar_file);
				exit(EX_BADARCH);
			}
			movefd(archive, STDIN);
			/* close(archive); */
		} else {
			archive = creat(ar_file,0666);
			if(archive < 0) {
				msg_perror("can't open archive %s", ar_file);
				exit(EX_BADARCH);
			}
			movefd(archive, STDOUT);
			/* close(archive); */
		}
	} else {
		/* We need a child tar */
		ck_pipe(kidpipe);

		kidchildpid = fork();
		if(kidchildpid < 0) {
			msg_perror("child can't fork");
			exit(EX_SYSTEM);
		}

		if(kidchildpid > 0) {
			/* About to exec compress:  set up the files */
			if (ar_reading) {
				movefd(kidpipe[PREAD], STDIN);
				ck_close(kidpipe[PWRITE]);
				/* dup2(pipe[PWRITE],STDOUT); */
			} else {
				/* dup2(pipe[PREAD],STDIN); */
				movefd(kidpipe[PWRITE], STDOUT);
				ck_close(kidpipe[PREAD]);
			}
			/* ck_close(pipe[PREAD]); */
			/* ck_close(pipe[PWRITE]); */
			/* ck_close(kidpipe[PREAD]);
			ck_close(kidpipe[PWRITE]); */
		} else {
		/* Grandchild.  Do the right thing, namely sit here and
		   read/write the archive, and feed stuff back to compress */
			tar="tar (child)";
			if (ar_reading) {
				movefd(kidpipe[PWRITE],STDOUT);
				ck_close(kidpipe[PREAD]);
			} else {
				movefd(kidpipe[PREAD],STDIN);
				ck_close(kidpipe[PWRITE]);
			}

			if (ar_file[0] == '-' && ar_file[1] == '\0') {
				if (ar_reading)
					archive = STDIN;
				else
					archive = STDOUT;
			} else /* This can't happen if (ar_reading==2)
				archive = rmtopen(ar_file, O_RDWR|O_CREAT, 0666);
			else */if(ar_reading)
				archive = rmtopen(ar_file, O_RDONLY, 0666);
			else
				archive = rmtcreat(ar_file, 0666);

			if (archive < 0) {
				msg_perror("can't open archive %s",ar_file);
				exit(EX_BADARCH);
			}

			if(ar_reading) {
				for(;;) {
					char *ptr;
					int max,count;
		
					r_error_count = 0;
				error_loop:
					err = rmtread(archive, ar_block->charptr,(int)(blocksize));
					if(err < 0) {
						readerror();
						goto error_loop;
					}
					if(err==0)
						break;
					ptr = ar_block->charptr;
					max = err;
					while(max) {
						count = (max<RECORDSIZE) ? max : RECORDSIZE;
						err = write(STDOUT,ptr,count);
						if(err!=count) {
							if(err<0) {
								msg_perror("can't write to %s",prog);
								exit(EX_SYSTEM);
							} else
								msg("write to %s short %d bytes",prog,count-err);
							count = (err<0) ? 0 : err;
						}
						ptr += count;
						max -= count;
					}
				}
			} else {
				for(;;) {
					int n;
					char *ptr;
		
					n = blocksize;
					ptr = ar_block->charptr;
					while(n) {
						err = read(STDIN,ptr,(n<RECORDSIZE) ? n : RECORDSIZE);
						if(err <= 0)
							break;
						n -= err;
						ptr += err;
					}
						/* EOF */
					if (err==0) {
						if (f_compress<2)
							blocksize-=n;
						else
							bzero(ar_block->charptr+blocksize-n,n);
						err = rmtwrite(archive,ar_block->charptr,blocksize);
						if (err != blocksize)
							writeerror(err, 0);
						if (f_compress < 2)
							blocksize += n;
						break;
					}
					if (n) {
						msg_perror("can't read from %s",prog);
						exit(EX_SYSTEM);
					}
					err = rmtwrite(archive, ar_block->charptr, (int)blocksize);
					if (err != blocksize)
						writeerror(err, 0);
				}
			}
		
			/* close_archive(); */
			exit(0);
		}
	}
		/* So we should exec compress (-d) */
	if (ar_reading)
		execlp(prog, prog, "-d", (char *)0);
	else
		execlp(prog, prog, (char *)0);
	msg_perror("can't exec %s",prog);
	_exit(EX_SYSTEM);
}

void
child_close()
{
	int child, status;

	if (childpid) {
		/*
		 * Loop waiting for the right child to die, or for
		 * no more kids.
		 */
		while (((child = wait(&status)) != childpid) && child != -1)
			;

		if (child != -1) {
			switch (TERM_SIGNAL(status)) {
			case 0:
				/* Child voluntarily terminated  -- but why? */
				if (TERM_VALUE(status) == MAGIC_STAT)
					exit(EX_SYSTEM);/* Child had trouble */
				if (TERM_VALUE(status) == (SIGPIPE + 128)) {
					/*
					 * /bin/sh returns this if its child
					 * dies with SIGPIPE.  'Sok.
					 */
					break;
				} else if (TERM_VALUE(status))
					msg("child returned status %d",
						TERM_VALUE(status));
			case SIGPIPE:
				break;		/* This is OK. */

			default:
				msg("child died with signal %d%s",
				 TERM_SIGNAL(status),
				 TERM_COREDUMP(status)? " (core dumped)": "");
			}
		}
	}
}

/*----------------------------------------------------------------------*/
/*		Device Interface					*/

#ifdef DYNAMIC

int
open_rmt(char *path, int oflag, int mode)
{
	int fd = rmt_open(strchr(path, ':') + 1, oflag, mode);
	if (fd < 0)
		return fd;
	return fd + _RMT_BIAS;
}

/**/ extern int	rmt_open(char *path, int oflag, int mode);

static int
check_function(int (*fcn)(int), char *name)
{
	if (fcn)
		return 0;
	fprintf(stderr, "function %s not defined\n");
}

void
rmtinit(char *path)
{
	int rc;
	int (*startup)(void);

	if (strchr(path+2, ':')) {
		char *cp, module[100];
		int anyfails = 0;

		cp = module;
		*cp++ = 'r';
		*cp++ = 'm';
		*cp++ = 't';
		*cp++ = '_';
		while (*path != ':')
			*cp++ = *path++;
		*cp++ = '\0';

		startup = (int (*)(void)) load(module, 1, NULL);
		if (startup == NULL) {
			fprintf(stderr, "Cannot load interface module %s\n", module);
			exit(EX_SYSTEM);
		}

		anyfails += check_function(rmt_open,   "rmt_open");
#if 0
		anyfails += check_function((int (*)(int))rmt_read,   "rmt_read");
		anyfails += check_function((int (*)(int))rmt_write,  "rmt_write");
		anyfails += check_function((int (*)(int))rmt_lseek,  "rmt_lseek");
		anyfails += check_function((int (*)(int))rmt_close,  "rmt_close");
		anyfails += check_function((int (*)(int))rmt_ioctl,  "rmt_ioctl");
		anyfails += check_function((int (*)(int))rmt_block,  "rmt_block");
		anyfails += check_function((int (*)(int))rmt_error,  "rmt_error");
		anyfails += check_function((int (*)(int))rmt_status, "rmt_status");
#endif

		if (anyfails)
			exit(EX_SYSTEM);

		rmtflag    = 1;
	} else
		rmtflag    = 0;
}

#endif
