/*****************************************************************************
 * $Id: ak_rmt.c,v 2.3 1993/11/29 17:02:36 edvkai Exp $
 *****************************************************************************
 * $Log: ak_rmt.c,v $
 * Revision 2.3  1993/11/29  17:02:36  edvkai
 * Multivolume QFA fixes.
 * Smaller size of tape directory.
 *
 * Revision 2.2  1993/11/25  20:23:25  edvkai
 * Major QFA changes.
 *
 * QFA now supports both block id and relative addressing. Relative
 * addressing is more efficient with short distances. 4mm and 8mm devices
 * do well with relative addressing only. For the sake of QIC tapes, TAR
 * optimizes QFA using block ids for large distances.
 *
 * The format of the tape-directory changed. No longer compatible to prior
 * versions. Maybe I'll add a utility for conversion.
 *
 * Rmt interface changed. Now using block numbers instead of byte offsets
 * for seek. Previously the lseek limitation to 2GB limited QFA archive
 * capacity. Changed rmtlseek to rmtseek to indicate that it is different.
 *
 * QFA should be able to handle multi-volume archives now.
 *
 * If a volume name is specified on the command line, QFA skips archives
 * having a different volume name.
 *
 * Code for header pretty-printing cleaned. Doesn't depend on hstat any
 * longer and requires less globals. No explanation text behind names in
 * tape directory.
 *
 * A few bugfixes.
 *
 * Revision 2.1  1993/08/08  19:06:28  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.1.1.1  1993/08/08  17:44:10  ak
 * Network TAR.
 *
 * Revision 1.1  1993/04/26  15:16:51  AK
 * Initial revision
 *
 *****************************************************************************/

#ifdef DYNAMIC

static char *rcsid = "$Id: ak_rmt.c,v 2.3 1993/11/29 17:02:36 edvkai Exp $";

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "ak_rmt.h"

/*------------------------------------------------------------------------*/

static long deverrno;

long
rcode(long rc)
{
	if (rc >= 0)
		return rc;
	switch (rc) {
	case -1: /* unix api error */
		break;
	case -2: /* device error */
		deverrno = rmt_error();
		errno = EIO;
		break;
	case -3: /* end of media */
		errno = ENOSPC;
		break;
	case -4: /* invalid function */
		errno = EINVAL;
		break;
	}
	return -1;
}

char *
rmtstatus(long rc)
{
	return (rc == EIO) ? rmt_status(deverrno) : strerror(rc);
}

/*------------------------------------------------------------------------*/

long
seek(int fd, long block, long blocksz, int mode)
{
	static int modes[] = { 0, 1, 2, 1, 0, 0 };
	long r = lseek(fd, block * blocksz, modes[mode]);
	return r < 0 ? -1 : r / blocksz;
}

int
def_ioctl()
{
	return -4;
}

int
def_block()
{
	return 512;
}

long
def_error()
{
	return errno;
}

char *
def_status(long rc)
{
	return strerror(rc);
}

#endif
