/**********************************************************/
/*                Meal Planner for OS/2                   */
/*                    Version 1.85                        */
/*                 Installation Program                   */
/*         (C) Copyright 1997 Christopher Hodges          */
/**********************************************************/

/* Load system functions. */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

InstallDir = ''
StartupDir = Directory()

/* Product Information */
'@cls'
Say 'Meal Planner for OS/2 Version 1.85'
Say '(C) Copyright 1997 Christopher Hodges'
Say 'All rights reserved.'
/* Query installation directory. */

Call GetMPlanInstallDir

Call Install

Exit


GetMPlanInstallDir:

    If InstallDir = '' Then Do
        Say
        Say 'Please enter the directory you wish to install to: '
        Call CharOut, '=> '
        Parse Pull InstallDir
        Say
    End
    If InstallDir = '' Then Do
        Say 'Error: Could not find installation dir.'
        Exit
    End

    /* Check if dir exists. */
    If Stream( InstallDir, 'c', 'query exists' ) = '' Then Do
        rc = SysMkDir( InstallDir )
        If rc <> 0 & rc <> 5 Then Do
            Say 'Error: Could not make directory ('InstallDir'), error code = ('rc')'
            Exit
        End
        Else If rc = 0 Then
            Say 'Directory ('InstallDir') created...'
    End

    /* Write installation directory. */
    Say 'Installation directory is ('InstallDir')'
    return


Install:

    /* Unpack files. */

        /* Unpack file to installation directory. */
        Call ChangeDriveAndPath InstallDir
        Say 'In install directory'
        Copy StartupDir'\HEALTH.EXE' InstallDir
        Copy StartupDir'\HEALTH.HLP' InstallDir
        Copy StartupDir'\*.DTX'      InstallDir
        Copy StartupDir'\*.DTA'      InstallDir
        Copy StartupDir'\*.DOC'      InstallDir
        Copy StartupDir'\*.INI'      InstallDir
        Say
        /* Change back to startup directory. */
        Call ChangeDriveAndPath StartupDir
        If FileSpec( Drive, StartupDir ) <> FileSpec( Drive, InstallDir ) Then
            '@cd 'FileSpec( Drive, InstallDir )'\'


    /* Create the object. */

        Say
        Say 'Creating objects.'

        /* Create folder. */
        rc = SysCreateObject(   'WPFolder',,
                                'Meal Planner',,
                                '<WP_DESKTOP>',,
                                'OBJECTID=<Meal_Planner>;',
                                ';ICONVIEWPOS=33,33,34,34;ALWAYSSORT=YES;',
                                ,,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create the Meal Planner Folder Object.'

        /* Create program. */
        rc = SysCreateObject(   'WPProgram',,
                                'Meal Planner',,
                                '<Meal_Planner>',,
                                'EXENAME='InstallDir'\HEALTH.EXE;STARTUPDIR='InstallDir';OBJECTID=<MPlanner>;',,
                                'Replace' )
        If rc <> 1 Then Say  'Error: could not create Meal Planner object.'
    
        Call SysSetObjectData '<Meal_Planner>', 'OPEN=DEFAULT;'

        say
        say 'Meal Planner successfully installed...'

    return


ChangeDriveAndPath:
    Parse Arg DriveAndPath

    /* Get drive and path */
    Say
    Say 'Changing to 'DriveAndPath
    ChangeToDrive = FileSpec( Drive, DriveAndPath )
    ChangeToPath = FileSpec( Path, DriveAndPath )
    ChangeToPath = Left( ChangeToPath, Length( ChangeToPath ) - 1 )

    /* Change drive and path. */
    Say 'Changing drive to 'ChangeToDrive
    '@'ChangeToDrive
    If rc <> 0 Then Do
        Say 'Error: could not change drive.'
        Exit
    End
    Say 'Changing directory to 'ChangeToPath
    '@cd 'ChangeToPath
    If rc <> 0 Then Do
        Say 'Error: could not change directory.'
        Exit
    End

    return

