/* C include file for MPG123.DLL - Samuel Audet <guardia@cam.org> */

ULONG _System decoderInit(void); /* returns Decoder's TID */
BOOL _System decoderUnInit(void); /* returns TRUE / FALSE */

#define WM_PLAYSTOP     WM_USER+69  /* sent to hwnd on play stop */
#define WM_PLAYERROR    WM_USER+100 /* sent on error after a MP123_PLAY */
#define WM_SEEKSTOP     WM_USER+666 /* sent after a MP123_JUMPTO, when
                                       decoderTimer reports
                                       what you sent on MP123_JUMPTO */
typedef struct {
   HWND hwnd; /* can be NULLHANDLE */

   char *filename;
   int volume;
   int jumptosecs;
   int pause;  /* 0 = resume, 1 = pause */
   int ffwd; /* 1 = start ffwd, 0 = end ffwd */
   int rew;  /* 1 = start rew, 0 = end rew */
   int flushbuffers; /* read trashbuffers, optional for rew and fwd */

   int lockdevice; /* ie.: 0 = shared, 1 = not shared */
   int force8bit;
   int forcemono;
   int downsample; /* 0 = 1to1, 1 = 2to1, 2 = 4to1 */
   int device; /* 0 = default, 1 = first, etc */
   int numbuffers; /* 16KB chunks, default 32, minimum 5 */
   unsigned char boostclass, normalclass; /* default normal 2 31 */
   signed char   boostdelta, normaldelta; /*         boost  3 00 */

   char *proxyurl; /* NULL = none, this string IS NOT COPIED */
   char *httpauth; /* NULL = none, this string IS NOT COPIED */
} decoderParms;

#define MP123_PLAY   1 /* returns TRUE, might block for 10 seconds to reinit a stalled decoder */
#define MP123_STOP   2 /* returns TRUE, same thing */
#define MP123_PAUSE  3 /* returns decoderParms.pause, ie.: 1 paused, 0 resumed */
#define MP123_FFWD   4 /* returns TRUE */
#define MP123_VOLUME 5 /* returns current volume */
#define MP123_REW    6 /* returns TRUE */
#define MP123_JUMPTO 7 /* returns TRUE */
#define MP123_SETUP  8 /* returns TRUE */
ULONG _System decoderCmd(int msg, decoderParms *info);

BOOL _System decoderPlaying(void);

#define TOTALSECS 1  /* less than 0 if unknown */
#define PLAYEDSECS 2
int _System decoderTime(int which); /* returns time in seconds, do not call
                                       when decoderPlaying() returns FALSE */

char *_System decoderError(); /* returns a string with error message, and
                                 nullifies it. returns NULL if no new errors. */

static char *modes[4] = { "Stereo", "Joint-Stereo", "Dual-Channel", "Single-Channel" };

/* NOTE: the information returned is only based on the FIRST frame */
typedef struct {
  int mpeg; /* 25 = MPEG 2.5, 10 = MPEG 1.0, 20 = MPEG 2.0 */
  int layer; /* 0 = unknown */
  int freq; /* in kHz */
  int mode; /* use it on modes[4] */
  int modext; /* didn't check what this one does */
  int bpf; /* bytes in the mpeg frame including header */
  int channel; /* 1 = mono, 2 = stereo */
  int bitrate; /* in kbit/s */
  int extention; /* didn't check what this one does */
  int junklength; /* bytes of junk before mpeg stream start, if < 0 -> unknown */
  int songlength; /* in seconds, <= 0 -> unknown */
} FileInfo;

/* returns TRUE/FALSE, FALSE = mpg123 can't play it */
int _System decoderFileInfo(char *filename, FileInfo *info); 
