/* This REXX script installs the PM123 object on your WPS desktop. */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

say "PM123 Desktop Installation Utility"
say ""
say "Do you want your PM123 object with association to MPEG-audio"
say "files (otherwise without associations)?"
say ""
say "(y or n)? "

key = SysGetKey('NOECHO')
parse upper var key key
if key <> 'N' then call assoc
call noassoc

noassoc:
say "Creating PM123 object on your desktop..."

currentDirectory = directory()
programName = "\PM123.EXE"
programPath = insert( currentDirectory, programName )

PRGOPTION="PROGTYPE=PM;EXENAME="||programPath||";OBJECTID=<PM123>;ICONFILE="||programName||";"

if SysCreateObject("WPProgram", ,
                   "PM123", ,
                   "<WP_DESKTOP>", , 
                   PRGOPTION, ,
                   "REPLACE") Then Do
    Say "PM123 object successfully created."
    Exit 0
End

Say "Object creation was not successful!"
call end

assoc:
say "Creating PM123 object on your desktop with associations..."

currentDirectory = directory()
programName = "\PM123.EXE"
programPath = insert( currentDirectory, programName )

PRGOPTION="PROGTYPE=PM;EXENAME="||programPath||";OBJECTID=<PM123>;ICONFILE="||programName||";STARTUPDIR="||currentDirectory||";ASSOCFILTER=*.MP3,*.MP2,*.M3U"

if SysCreateObject("WPProgram", ,
                   "PM123", ,
                   "<WP_DESKTOP>", , 
                   PRGOPTION, ,
                   "REPLACE") Then Do
    Say "PM123 object successfully created."
    Exit 0
End

Say "Object creation was not successful!"

end:
Exit 0

