/*          To mark all notes in a folder as having been opened           */
/*                      Parameters: folder_directory                      */
/*           If no parameter, current directory will be assumed           */
/*    InnoVal Systems Solutions, Inc., and the authors cannot be held     */
/*   responsible for damage that might occur while using this program.    */
/*                         Use at your own risk.                          */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoRexx
call SysLoadFuncs
signal on syntax name Syntax
'@ECHO OFF'
parse arg directory
if pos('?',directory)>0 | directory='-h' | directory='-H' | ,
   directory='/h' | directory='/H' then do
   say
   say 'This program marks as "opened" every note (*.POP file) in the current'
   say 'or specified directory. Specify the desired folder pathname (directory)'
   say 'as a command line parameter. For example, the College subfolder of your'
   say 'Friends folder, in your address@wherever.com inbasket, is probably'
   say 'C:\POSTROAD\ADDRESS\FRIENDS\COLLEGE, so you would type:'
   say
   say '   MARKOPEN C:\POSTROAD\ADDRESS\FRIENDS\COLLEGE'
   say
   say 'at the OS/2 command line prompt to mark every note in that folder as'
   say '"opened".'
   exit
end
if directory='' then directory=directory()
if right(directory,1)='\' then directory=substr(directory,1,length(directory)-1)
call sysfiletree directory'\*.POP',files,'FO'
say
do i=1 to files.0
   drop variable
   call sysgetea files.i,"POPNOTEBUFFER",variable
   parse var variable one '09'x two '09'x three '09'x four '09'x five '09'x six '09'x seven '09'x attributes '09'x nine
   parse var attributes ten 2 opened 3 eleven
   if opened='01'x then iterate
   attributes=ten||'01'x||eleven
   variable=one||'09'x||two||'09'x||three||'09'x||four||'09'x||five||'09'x||six||'09'x||seven||'09'x||attributes||'09'x||nine
   doneit=sysputea(files.i,"POPNOTEBUFFER",variable)
   say 'Note file' files.i 'marked as "opened".'
end
if files.0=0 then say "No *.POP files (notes) were found in" directory "directory."
else if doneit='DONEIT' then say "No unopened notes were found in" directory "directory."
exit
Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return
NoRexx:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return
