/* FORWARD.CMD - A REXX user exit, for a filter to execute, to forward or */
/*            redirect an incoming note to multiple addresses             */
/*                                                                        */
/*              Do not use without customizing FORWARD.CFG!               */
/*                                                                        */
/*   Copyright (c)1996 Kari Jackson for InnoVal Systems Solutions, Inc.   */
/*  Portions adapted from PRMAF102.CMD, Copyright (c)1995 Bill Springall  */
/*                  for InnoVal Systems Solutions, Inc.                   */
/*    InnoVal Systems Solutions, Inc., and the authors cannot be held     */
/*   responsible for damage that might occur while using this program.    */
/*                         Use at your own risk.                          */
/*                                                                        */
/* FORWARD.CFG file must be present; instructions are in it, in comments. */

parse arg filename
inbasket=left(filename,lastpos('\',filename))
parse source . . program
program=left(program,lastpos('.',program))
inifile=program||'cfg'
inifile=stream(inifile,'C','QUERY EXISTS')
/* This program can't do anything if you don't tell it to whom you want the
   notes redirected or forwarded! */
if inifile='' then exit
tos.0=0 ; others.0=0
do while lines(inifile)
   line=linein(inifile)
   select
      when left(line,2)='/*' then nop
      when strip(line)='' then nop
      when translate(left(line,5))='FROM:' then FROM=strip(substr(line,6))
      when translate(left(line,9))='REPLY-TO:' then REPLYTO=strip(substr(line,10))
      when translate(left(line,8))='SUBJECT:' then SUBJECT=strip(substr(line,9))
      when translate(left(line,3))='TO:' then do
         tos.0=tos.0+1
         i=tos.0
         tos.i=strip(substr(line,4))
      end
      when translate(left(line,8))='TRAILER:' then TRAILER=substr(line,9)
      when translate(line)='SEND HEADER' then HEADER='yes'
      otherwise do
         others.0=others.0+1
         i=others.0
         others.i=line
      end
   end
end
call lineout inifile
/* This program can't do anything if you don't tell it to whom you want the
   notes redirected or forwarded! */
if tos.0=0 then exit
outfile=getpopname(inbasket'SNDNOTES','POP')
/* the following would virtually never happen; if it did, the program would
   not be able to do its job, so exit */
if outfile='error' then exit
outfile=inbasket'SNDNOTES\'outfile'.POP'
/* now we'll read the header of the incoming note */
header.0=0
do while lines(filename)
   i=header.0+1
   header.i=linein(filename)
   if strip(header.i)='' then leave
   header.0=i
   select
      when translate(left(header.i,5))='FROM:' & FROM='FROM' then FROM=strip(substr(header.i,6))
      when translate(left(header.i,9))='REPLY-TO:' & REPLYTO='REPLYTO' then REPLYTO=strip(substr(header.i,10))
      when translate(left(header.i,8))='SUBJECT:' & SUBJECT='SUBJECT' then SUBJECT=strip(substr(header.i,9))
      otherwise nop
   end
end
tagchar=x2c('05')
do i=1 to tos.0
   call lineout outfile,tagchar||x2c('01')||tos.i
end
if FROM<>'FROM' then call lineout outfile,tagchar||x2c('0B')||FROM
if REPLYTO<>'REPLYTO' then call lineout outfile,tagchar||x2c('31')||REPLYTO
do i=1 to others.0
   call lineout outfile,others.i
end
if SUBJECT<>'SUBJECT' then call lineout outfile,tagchar||x2c('0F')||SUBJECT
call lineout outfile,''
if header='yes' then do
   do i=1 to header.0
      call lineout outfile,header.i
   end
   call lineout outfile,''
end
do while lines(filename)
   call lineout outfile,linein(filename)
end
if trailer<>'TRAILER' then do
   call lineout outfile,''
   call lineout outfile,trailer
end
call lineout outfile,''
call lineout outfile
call lineout filename
exit

/* Copyright (c)1996 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* Subroutine to produce a *.POP-style filename */
/* Returns 8-character name or "error" */
GetPopName:procedure
parse arg directory,extension
characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
parse value date("O") with . 2 year "/" month "/" day
parse value time() with hour ":" minute ":" second
month=substr(characters,month+1,1)
day=substr(characters,day+1,1)
hour=substr(characters,hour+1,1)
fifth=minute%36
sixth=substr(characters,minute//36+1,1)
test=second//36
string=year||month||day||hour||fifth||sixth
do j=1 to 36
   test2=(test+j)//36
   if test2=0 then seventh=substr(characters,36,1)
   else seventh=substr(characters,test2,1)
   do i=1 to 36
      tryit=string||seventh||substr(characters,i,1)
      filename=directory||"\"||tryit||'.'||extension
      if stream(filename,'c','query exists')='' then return tryit
   end
end
/* there have already been 1296 files created in that directory this minute */
return 'error'
