/*
 * Simple filter program to add a final formfeed after
 * a message stream. Output is to device or file given
 * on the command line.
 * David Nugent <davidn@unique.blaze.net.au>
 * This code is public domain
 */

#include <stdio.h>

int
main (int argc, char *argv[])
{
  FILE * fp = stdout;
  char tmp[1024];

  if (argc > 1 && (fp = fopen(argv[1], "w"))==NULL)
  {
    fprintf(stderr, "Can't open file/device '%s': %m\n", argv[1]);
    return 1;
  }

  /* Copy input to output */
  while (fgets(tmp, sizeof tmp - 1, stdin)!=NULL)
    fputs(tmp, fp);
  /* Add the formfeed */
  fputc('\f', fp);
  /* Close and flush */
  close(fp);

  return 0;
}
