/***************************************************************************
 *  Demonstrates the CGI interface using a REXX program.
 **************************************************************************/

env  = "OS2ENVIRONMENT"

Say "Content-type: text/html"
Say

Say "<h1>CGI/1.1 Demonstration:</h1>"

Say "<ul>"

/* Echo the Standard Set of CGI Variables */

Say "<li>SERVER_SOFTWARE = "   value("SERVER_SOFTWARE",,env)
Say "<li>SERVER_NAME = "       value("SERVER_NAME",,env)
Say "<li>GATEWAY_INTERFACE = " value("GATEWAY_INTERFACE",,env) 
Say "<li>SERVER_PROTOCOL = "   value("SERVER_PROTOCOL",,env) 
Say "<li>SERVER_PORT = "       value("SERVER_PORT",,env)
Say "<li>REQUEST_METHOD = "    value("REQUEST_METHOD",,env) 
Say "<li>HTTP_ACCEPT = "       value("HTTP_ACCEPT",,env) 
Say "<li>PATH_INFO = "         value("PATH_INFO",,env) 
Say "<li>PATH_TRANSLATED = "   value("PATH_TRANSLATED",,env) 
Say "<li>SCRIPT_NAME = "       value("SCRIPT_NAME",,env) 
Say "<li>QUERY_STRING = "      value("QUERY_STRING",,env) 
Say "<li>REMOTE_HOST = "       value("REMOTE_HOST",,env) 
Say "<li>REMOTE_ADDR = "       value("REMOTE_ADDR",,env) 
Say "<li>REMOTE_USER = "       value("REMOTE_USER",,env) 
Say "<li>AUTH_TYPE = "         value("AUTH_TYPE",,env) 
Say "<li>CONTENT_TYPE = "      value("CONTENT_TYPE",,env)
len = value("CONTENT_LENGTH",,env)
Say "<li>CONTENT_LENGTH = "    || len   

/* If POST method was used to pass parameters, get them and echo them */

method = value("REQUEST_METHOD",,env)
If (method == "POST") & (len \= "") Then Do
  post_string = LineIn() 
  Say
  Say "CGI Script Parameters = " || post_string
End

Say "</ul>"

