/*                                                                 */
/* TOUPPER.CMD (v1.01):  Convert filenames to upper/lowercase      */
/* Ian Prest                                                       */
/* June 26, 1996 (v1.0)                                            */
/* June 29, 1996 (v1.01)                                           */
/*                                                                 */
/* Notice the nice layout/framework that will                      */
/* simplify creating other utilities of this type                  */
/* (utilities that perform an action on multiple                   */
/* filespecs, and have multiple switches).                         */
/*                                                                 */

/* Load rexxutil functions                                         */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
'@echo off'

/* Display copyright info                                          */
call proginfo

/* set up default state for "switch" variables                     */
parameters = 'O'
bfd = 0
recurse = 0
ulcase = 0

/* parse switches, which will modify state of "switch" variables   */
PARSE UPPER ARG cmdline
call parseargs cmdline, 0 

/* set up global variables based on "switch" variable state        */

/* handle BFD parameters                                           */
if bfd=0 then parameters = parameters'B'
else if bfd=1 then parameters = parameters'F'
else if bfd=2 then parameters = parameters'D'

/* handle RECURSE parameter                                        */
if recurse=1 then parameters = parameters'S'

/* handle UPPER/LOWERCASE parameters                               */
if ulcase=0 then do
   tableo = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   tablei = "abcdefghijklmnopqrstuvwxyz"
   end
else do
   tableo = "abcdefghijklmnopqrstuvwxyz"
   tablei = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   end

/* set number of filespecs encountered thus far to zero            */
fscount = 0

/* parse filenames, which will perform the action on the files and */
/* increase "fscount"                                              */
PARSE UPPER ARG cmdline
call parseargs cmdline, 1  

/* if fscount=0 then there weren't any filespecs on the cmd-line   */
/* so we tell user what to do                                      */
if fscount=0 then call usage

/* we're done!  yay!                                               */
exit


/*                                                                 */
/* ***** Subroutines! *****                                        */
/*                                                                 */

/* Informs user about command line parameters!                     */
usage: procedure
   say 'Usage:  TOUPPER  <filespec> [<filespec> [...]] [/rdfblu]'
   say
   say '  /r  Scans directories recursively'
   say '  /n  No directory recurse (default)'
   say '  /d  Directories only'
   say '  /f  Files only'
   say '  /b  Both files and directories (default)'
   say '  /l  Convert to lowercase'
   say '  /u  Convert to uppercase (default)'
   return

/* print copyright & other program info to the screen              */
proginfo: procedure
   say 'TOUPPER v1.01 - change the case of filenames'
   say 'Copyright (C) 1996  Ian Prest'
   say 'All rights reserved.'
   say
   return

/* performs the action on a file                                   */
fileaction: arg file
   name = file

   /* trim off pathname                                            */
   name = filespec("name",name)

   /* convert case                                                 */
   name = TRANSLATE(name, tableo, tablei)

   /* if the name has changed, rename file                         */
   if name <> filespec("name",file.i) then do
      say file.i '-->' name
      'rename "'file.i'" "'name'"'
      end
   return

/* performs the action on a filespec                               */
filespecaction: arg filespec
   /* "file" is a stem variable to hold all the names...           */
   call SysFileTree filespec, 'file', parameters, "**---"

   if file.0=0 then do
      say filespec":  No matching files found."
      end
   else do
      say filespec":  "file.0" matching files found."
      do i=1 to file.0
         call fileaction file.i
         end
      end
   say
   return

/* interprets a single character command-line switch               */
interpretswitch: arg s
   if s="N" then recurse=0
   else if s="R" then recurse=1
   else if s="B" then bfd = 0
   else if s="F" then bfd = 1
   else if s="D" then bfd = 2
   else if s="U" then ulcase = 0
   else if s="L" then ulcase = 1
   else do
      say "Invalid parameter '/"s"'"
      say
      call usage
      exit
      end
   return

/* parse command-line                                              */
parseargs: arg switches, argtype
   do forever
      PARSE VAR switches sw switches
      if sw="" then leave

      /* argtype=0 means we're looking for switches                */
      if argtype=0 then do
         if substr(sw,1,1) = "/" | substr(sw,1,1)="-" then
            do swstart=2 to length(sw)
               s = substr(sw,swstart,1)
               call interpretswitch s
               end
         end
      /* argtype=1 means we're looking for filespecs               */
      else if argtype=1 then do
         if \ (substr(sw,1,1) = "/" | substr(sw,1,1)="-") then do
            fscount = fscount + 1
            call filespecaction sw
            end
         end
      end
   return
