/* REXX SCRIPT */

/* =============================================================
   This is a REXX script file to halt/restart all programs and files
   required to properly start the SOCKS services. Look through it
   and edit as necessary for your local setup!
   ============================================================= */
call RxFuncAdd 'SysSleep', 'RexxUtil','SysSleep'



/* =============================================================
   Update RESOLV files. Edit as required, for ETC directory.
   ============================================================= */
call syssleep 10
'copy d:\mptn\etc\resolv.lo d:\mptn\etc\resolv'
'copy d:\mptn\etc\resolv.lo d:\mptn\etc\resolv2'
'copy d:\mptn\etc\resolv.lo d:\tcpip\dos\etc\resolv'
'copy d:\mptn\etc\resolv.lo d:\tcpip\dos\etc\resolv2'


/* =============================================================
   Restart SOCKS server after connection. A good idea to do this!
   Edit for local configuration.
   ============================================================= */
'go -k SOCKD.EXE'
call syssleep 5
'h:'
'cd\apps\sockd'
'start sockd.exe'


/* =============================================================
   Restart DNS server. I don't do this, but you might want to;
   Uncomment and edit as required, if you do.
   ============================================================= */

/*
'go -k NAMED.EXE'
call syssleep 5
'h:'
'cd\apps\bind'
'start named.exe'
*/

/* For example, if instead I was using DNSPROXY, I'd do this! */
/*
'start h:\apps\tcpip\utils\dnsproxy 165.87.201.244'
*/


/* =============================================================
   Add in anything else you want to do, here.
   ============================================================= */


/* START to local loopback interface, since that's what the DNS server 
   runs on */
'ifconfig lo 127.0.0.1 up'




/* nothing else for me! */


/* =============================================================
   END of STARTSOK.CMD
   ============================================================= */
exit
