//---------------------------------------------------------------------------------------------
// File STDWIN.CPP (Example for OS/2 e-Zine!) Eric Slaats 1996
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#include <os2.h>
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

void main()
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient, hwndFrame;  // Client and Frame handles

     ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_SHELLPOSITION |
                          FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST;

     //-------------------------------------------------------------------------
     // Initialize application and create message queue
     //-------------------------------------------------------------------------
     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);
     //-------------------------------------------------------------------------
     // Register class and create window
     //-------------------------------------------------------------------------
     WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
                                     WS_VISIBLE,       // Style (visible)
                                     &flFrameFlags,    // Creation flags
                                     "SampleClass",    // Class name
                                     "Titlebar Text",  // Titlebar text
                                     0,                // Client style
                                     NULLHANDLE,       // Resource handle
                                     0,                // Frame ID
                                     &hwndClient);     // Client handle
     //-------------------------------------------------------------------------
     // Message loop
     //-------------------------------------------------------------------------
     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);
     //-------------------------------------------------------------------------
     // Clean up (destroy window, queue and hab)
     //-------------------------------------------------------------------------
     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     }


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     switch (msg)
          {
          //--------------------------------------------------------------------
          // Fill client with default color
          //--------------------------------------------------------------------
          case WM_ERASEBACKGROUND:
          return MRFROMSHORT(TRUE);
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }

