/*------------------------------------------------------------------
 * miniftp.cmd :
 *------------------------------------------------------------------
 * 03-16-93 originally by Patrick J. Mueller & Cliff Nadler
 *------------------------------------------------------------------*/

ARG line


STRF_UCASE = X2D(00000001)
STRF_LCASE = X2D(00000002)
STRF_REQUIRED = X2D(00000004)
STRF_NOECHO = X2D(00000008)
STRF_ENCRYPT = X2D(00000010)
STRF_HOT = X2D(00000020)
STRF_EDIT = X2D(00000040)
STRF_PRETTY = X2D(00000080)
STRF_MUSTHOT = X2D(00000100)
STRF_NEAT = X2D(00000200)
STRF_NOHELP = X2D(00000400)
STRF_NOQUE = X2D(00000800)
STRF_NOQUEONE = X2D(00001000)
STRF_CHATCLNT = X2D(00002000)
STRF_NOTIMECHECK = X2D(00004000)

    /* types */

STRT_ALPHA = 1
STRT_NUMERIC = 2
STRT_ALPHANUMERIC = 3
STRT_HEX = 4
STRT_FILENAME = 5
STRT_FILESPEC = 6
STRT_ALL = 7
STRT_ANY = 8
STRT_YN = 9
STRT_MULTFILES    1 = 0
STRT_MULTSPECS    1 = 1
STRT_YNQ          1 = 2
STRT_YNQS         1 = 3
STRT_JUSTFILE     1 = 4
STRT_MULTJUST     1 = 5
STRT_TELEPHONE    1 = 6
STRT_YNNUM        1 = 7




/*------------------------------------------------------------------
 * load functions, if needed
 *------------------------------------------------------------------*/
if RxFuncQuery("FtpLoadFuncs") then
   do
   rc = RxFuncAdd("FtpLoadFuncs","RxFtp","FtpLoadFuncs")
   rc = FtpLoadFuncs()
   end

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

/*------------------------------------------------------------------
 * set up signal
 *------------------------------------------------------------------*/
rows = 25
cols = 80

host = ""
user = ""
pass = ""

TEST = ""

/*------------------------------------------------------------------
 * set things
 *------------------------------------------------------------------*/


AdeptPrint(line, "[2J\r\n\n")

do while (cmd <> "QUIT")

   /*---------------------------------------------------------------
    * print prompt
    *---------------------------------------------------------------*/
   AdeptPrint(line, "\r\nEnter FTP command: (use ? for help)\r\n")

   /*---------------------------------------------------------------
    * get command
    *---------------------------------------------------------------*/
   test = AdeptInput(line, 1, 75, STRT_ALL, STRF_EDIT+STRF_NOHELP, "[0m", "", "", "")

   parse VAR test cmd cmdargs

   parse var cmdargs file1 file2 rest

   if (file1 = "") then file1 = "*"
   if (file2 = "") then file2 = file1

   /*------------------------------------------------------------------
    * sanity check
    *------------------------------------------------------------------*/
   cmd = translate(cmd)

   if (host="") then
      if (cmd <> "CONNECT") & (cmd <> "?") & (cmd <> "QUIT") then
         do
         AdeptPrint(line, "\r\nYou have not provided host, userid, and password information.\r\n")
         AdeptPrint(line, "\r\nUse the CONNECT command to provide this information.\r\n")
         iterate
         end

   /*---------------------------------------------------------------
    * start timer for get/put
    *---------------------------------------------------------------*/
   if (cmd = "GET") | (cmd = "GETB") | (cmd = "PUT") | (cmd = "PUTB") then
      call time "r"

   /*---------------------------------------------------------------
    * run command
    *---------------------------------------------------------------*/
   err = 0
   select
      when (cmd = "QUIT")    then iterate
      when (cmd = "GET")     then err = FtpGet(file1,file2,"ASCII")
      when (cmd = "GETB")    then err = FtpGet(file1,file2,"BINARY")
      when (cmd = "PUT")     then err = FtpPut(file1,file2,"ASCII")
      when (cmd = "PUTB")    then err = FtpPut(file1,file2,"BINARY")
      when (cmd = "UPUT")    then err = FtpPutUnique(file1,file2,"ASCII")
      when (cmd = "UPUTB")   then err = FtpPutUnique(file1,file2,"BINARY")
      when (cmd = "DELETE")  then err = FtpDelete(file1)
      when (cmd = "RENAME")  then err = FtpRename(file1,file2)
      when (cmd = "APPEND")  then err = FtpAppend(file1,file2,"ASCII")
      when (cmd = "APPENDB") then err = FtpAppend(file1,file2,"BINARY")
      when (cmd = "QUOTE")   then err = FtpQuote(cmdargs)
      when (cmd = "SITE")    then err = FtpSite(cmdargs)
      when (cmd = "CD")      then err = FtpChDir(file1)
      when (cmd = "MD")      then err = FtpMkDir(file1)
      when (cmd = "RD")      then err = FtpRmDir(file1)

      when (cmd = "DIR")     then err = FtpDir(file1,"stem.")
      when (cmd = "LS")      then err = FtpLs(file1,"stem.")

      when (cmd = "CONNECT") then
         do
         parse var cmdargs host user pass

         AdeptPrint(line, "\r\n\nhost = "host"\r\n")
         AdeptPrint(line, "user = "user"\r\n")
         AdeptPrint(line, "pass = "pass"\r\n")

         call FtpSetUser host, user, pass
         end

      when (cmd = "CLOSE")   then
         do
         rc = FtpLogoff()
         host = ""
         user = ""
         pass = ""
         end

      when (cmd = "PWD")     then
         do
         junk = FtpPwd('curdir')
         AdeptPrint(line, "\r\nCurrent Remote Directory :" curdir"\r\n")
         end

      when (cmd = "SYS")     then
         do
         junk = FtpSys('sys')
         AdeptPrint(line, "\r\nReturned from sys:" sys"\r\n")
         end

      when (cmd = "?")       then call Usage

      otherwise
         AdeptPrint(line, "\r\nInvalid command. Use ? for help.\r\n")
   end

   /*---------------------------------------------------------------
    * stop timer for get/put
    *---------------------------------------------------------------*/
   if (cmd = "GET") | (cmd = "GETB") | (cmd = "PUT") | (cmd = "PUTB") then
      do
      elapsed = strip(format(time("e"),10,2))

      if (cmd = "GET") | (cmd = "GETB") then
         lfile = file2
      else
         lfile = file1

      bytes = stream(lfile,"C","QUERY SIZE")

      bps = strip(format(bytes/elapsed,10,2))
      AdeptPrint(line, "\r\ntransmitted" bytes "bytes in" elapsed "seconds:" bps "bytes/second.\r\n")
      end

   /*------------------------------------------------------------------
    * check error
    *------------------------------------------------------------------*/
   if (err <> 0) then
      AdeptPrint(line, "\r\nError from FTP:" FTPERRNO"\r\n")

   /*------------------------------------------------------------------
    * check for dir or ls
    *------------------------------------------------------------------*/
   x = 0

   if (cmd = "LS") | (cmd = "DIR") then
      do i = 1 to stem.0
         x = x + 1
         AdeptPrint(line, stem.i"\r\n")
         if(x = 22) then do
            More = AdeptInput(line,,1,,,"More Y/n? ",,,)
            x = 0
            if(More = 'N') then do
              I = stem.0
              Iterate
            end
            if(More = 'n') then do
              I = stem.0
              Iterate
            end
         end
      end
end

/*------------------------------------------------------------------
 * quit
 *------------------------------------------------------------------*/
done:
rc = FtpSetUser("X","X","X")
rc = FtpLogoff()
exit

/*------------------------------------------------------------------
 * break condition
 *------------------------------------------------------------------*/
halt:
   AdeptPrint(line, "\r\nTerminating ...\r\n")
   signal done

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage:

   AdeptPrint(line, "\r\nusage:\r\n")
   AdeptPrint(line, "   command ...\r\n")
   AdeptPrint(line, "is used to run ftp commands on a remote host\r\n\n")
   AdeptPrint(line, "where:\r\n")
   AdeptPrint(line, "   command can be one of:\r\n")
   AdeptPrint(line, "       connect host user password\r\n")
   AdeptPrint(line, "       close\r\n")
   AdeptPrint(line, "       site site-command\r\n")
   AdeptPrint(line, "       dir pattern                        ls  pattern\r\n")
   AdeptPrint(line, "       get remotefile [localfile]\r\n")
   AdeptPrint(line, "       getb remotefile [localfile]        put localfile [remotefile]\r\n")
   AdeptPrint(line, "       putb localfile [remotefile]        uput localfile [remotefile]\r\n")
   AdeptPrint(line, "       uputb localfile [remotefile]\r\n")
   AdeptPrint(line, "       rename oldname newname             delete filename\r\n")
   AdeptPrint(line, "       append remotefile [localfile]      appendb remotefile [localfile]\r\n")
   AdeptPrint(line, "       sys\r\n")
   AdeptPrint(line, "       md directory                       cd directory\r\n")
   AdeptPrint(line, "       rd directory\r\n")
   AdeptPrint(line, "       pwd\r\n")
   AdeptPrint(line, "       quit\r\n")

return
