/*******************************************************************
Name:  dbug.h
Desc:  contains dbug macros, prototypes, and defines
*******************************************************************/

/* double inclusion */
#ifndef INCL_DBUG
#define INCL_DBUG

/* define additional types */
#if !defined(OS2_INCLUDED) && !defined(INCL_NEWTYPES1)
#define INCL_NEWTYPES1
typedef short            SHORT;
typedef SHORT *          PSHORT;
typedef unsigned short   USHORT;
typedef USHORT *         PUSHORT;
typedef long             LONG;
typedef LONG *           PLONG;
typedef unsigned long    ULONG;
typedef ULONG *          PULONG;
typedef char             CHAR;
typedef CHAR *           PCHAR;
typedef unsigned char    UCHAR;
typedef UCHAR *          PUCHAR;
typedef UCHAR            BYTE;
typedef BYTE *           PBYTE;
typedef int              INT;
typedef INT *            PINT;
typedef void             VOID;
typedef VOID *           PVOID;
typedef ULONG            BOOL;
typedef BOOL *           PBOOL;
#endif

#ifndef INCL_NEWTYPES2
#define INCL_NEWTYPES2
typedef double           DOUBLE;
typedef DOUBLE *         PDOUBLE;
typedef INT              FD;

#ifdef UNIX
typedef INT              APIRC;
typedef APIRC *          PAPIRC;
typedef pid_t            PID;
typedef unsigned int     TID;
#ifndef APIENTRY
#define APIENTRY
#endif
#else
typedef ULONG            APIRC;
typedef APIRC *          PAPIRC;
typedef USHORT           APIRC16;
typedef APIRC16 *        PAPIRC16;
typedef USHORT           HFILE16;
typedef HFILE16 *        PHFILE16;
#ifndef APIENTRY
#define APIENTRY         _System
#endif
#endif
#endif

/* define message types and sizes */
#define DBUG_TYPE_M        1L
#define DBUG_TYPE_S        2L
#define DBUG_TYPE_L        3L
#define DBUG_TYPE_I        4L
#define DBUG_TYPE_D        5L
#define DBUG_TYPE_C        6L
#define DBUG_TYPE_Z        7L
#define DBUG_TYPE_P        8L
#define DBUG_TYPE_V        9L
#define DBUG_TYPE_STOP     1000L
#define DBUG_TYPE_LOGOPEN  1001L
#define DBUG_TYPE_LOGCLOSE 1002L
#define DBUG_SIZE_TYPE_S   ((ULONG) sizeof(USHORT))
#define DBUG_SIZE_TYPE_L   ((ULONG) sizeof(ULONG))
#define DBUG_SIZE_TYPE_I   ((ULONG) sizeof(INT))
#define DBUG_SIZE_TYPE_D   ((ULONG) sizeof(DOUBLE))
#define DBUG_SIZE_TYPE_C   ((ULONG) sizeof(UCHAR))
#define DBUG_SIZE_TYPE_P   ((ULONG) sizeof(ULONG))

/*******************************************************************
DBUG macros
*******************************************************************/
#ifdef DEBUG
#define DBUG(a,b,c) DBug(DBUG_TYPE_V, (PCHAR) a, b, c, __FILE__, __LINE__)
#define DBUGS(a,b)  DBug(DBUG_TYPE_S, (PCHAR) a, DBUG_SIZE_TYPE_S, b, __FILE__, __LINE__)
#define DBUGL(a,b)  DBug(DBUG_TYPE_L, (PCHAR) a, DBUG_SIZE_TYPE_L, b, __FILE__, __LINE__)
#define DBUGI(a,b)  DBug(DBUG_TYPE_I, (PCHAR) a, DBUG_SIZE_TYPE_I, b, __FILE__, __LINE__)
#define DBUGD(a,b)  DBug(DBUG_TYPE_D, (PCHAR) a, DBUG_SIZE_TYPE_D, b, __FILE__, __LINE__)
#define DBUGC(a,b)  DBug(DBUG_TYPE_C, (PCHAR) a, DBUG_SIZE_TYPE_C, b, __FILE__, __LINE__)
#define DBUGP(a,b)  DBug(DBUG_TYPE_P, (PCHAR) a, DBUG_SIZE_TYPE_P, b, __FILE__, __LINE__)
#define DBUGZ(a,b)  DBug(DBUG_TYPE_Z, (PCHAR) a, strlen(a)+1,      b, __FILE__, __LINE__)
#define DBUGM(a)    DBug(DBUG_TYPE_M, (PCHAR) NULL, 0,             a, __FILE__, __LINE__)
#define DBUGSTOP()  DBug(DBUG_TYPE_STOP,     (PCHAR) NULL, 0,   NULL, __FILE__, __LINE__)
#define DBUGOPEN()  DBug(DBUG_TYPE_LOGOPEN,  (PCHAR) NULL, 0,   NULL, __FILE__, __LINE__)
#define DBUGCLOSE() DBug(DBUG_TYPE_LOGCLOSE, (PCHAR) NULL, 0,   NULL, __FILE__, __LINE__)

/*******************************************************************
DBUG printf macros
*******************************************************************/
#define DBUG_M(a)    printf("%s/%04d  INFO: "   #a "\n", __FILE__, __LINE__)
#define DBUG_S(a,b)  printf("%s/%04d  SHORT: "  #a "=[%hd]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_US(a,b) printf("%s/%04d  USHORT: " #a "=[%hu]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_L(a,b)  printf("%s/%04d  LONG: "   #a "=[%ld]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_UL(a,b) printf("%s/%04d  ULONG: "  #a "=[%lu]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_I(a,b)  printf("%s/%04d  INT: "    #a "=[%d]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_D(a,b)  printf("%s/%04d  DOUBLE: " #a "=[%f]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_C(a,b)  printf("%s/%04d  CHAR: "   #a "=[%c]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_Z(a,b)  printf("%s/%04d  PCHAR: "  #a "=[%s]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_P(a,b)  printf("%s/%04d  PTR: "    #a "=[%p]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_X(a,b)  printf("%s/%04d  HEX: "    #a "=[%x]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_O(a,b)  printf("%s/%04d  OCT: "    #a "=[%o]  Note: %s\n", __FILE__, __LINE__, a, b)
#define DBUG_E(a,b)  printf("%s/%04d  EXP: "    #a "=[%e]  Note: %s\n", __FILE__, __LINE__, a, b)

/*******************************************************************
DBUG prototype
*******************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
APIRC APIENTRY DBug(ULONG msgType, PCHAR data, USHORT dataLen, PCHAR note,
                    PCHAR file, USHORT line);
#ifdef __cplusplus
}
#endif

/*******************************************************************
DBUG null macros
*******************************************************************/
#else
#define DBUG(a,b,c)
#define DBUGS(a,b)
#define DBUGL(a,b)
#define DBUGI(a,b)
#define DBUGD(a,b)
#define DBUGC(a,b)
#define DBUGP(a,b)
#define DBUGZ(a,b)
#define DBUGM(a)
#define DBUGSTOP()
#define DBUGOPEN()
#define DBUGCLOSE()

#define DBUG_M(a)
#define DBUG_S(a,b)
#define DBUG_US(a,b)
#define DBUG_L(a,b)
#define DBUG_UL(a,b)
#define DBUG_I(a,b)
#define DBUG_D(a,b)
#define DBUG_C(a,b)
#define DBUG_Z(a,b)
#define DBUG_P(a,b)
#define DBUG_X(a,b)
#define DBUG_O(a,b)
#define DBUG_E(a,b)
#endif

#endif
