/* JAPANESE.CMD: Install MEMSIZE in Japanese. */

'@Echo Off'
'CHCP 932'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'MEMSIZE ̃CXg[ł...'
Say ''


/* Verify the existence of the various component files. */

Language = 'JAPANESE'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'G[: MEMSIZE.EXE ܂!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'G[: 'Language'.DLL ܂!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'G[: 'Language'.HLP ܂!'
  Signal DONE
  End

/* Ask for the target directory name. */

Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = 'C:\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'MEMSIZE CXg[fBNg'
Say 'tl[Ŏw肵ĉ (w肵Ȃ 'Default' ɂȂ܂): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'G[: fBNg܂B'
    Signal DONE
    End
  End
Say ''


/* Ask for the target folder. */

Say 'IuWFNgntH_ɓo^܂H (Y/N)'
Pull YesNo
If YesNo = "Y" Then
  Do
  Folder = '<WP_START>'
  Say 'ntH_ɓo^܂B'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'fXNgbvɓo^܂B'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Perform the installation. */

Say 'MEMSIZE 'Directory' ɃRs[...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say 'IuWFNg̍쐬ł...'
Type = 'WPProgram'
Title = 'VXe\[X'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'IuWFNg쐬܂BCXg[I܂B'
Else
  Say 'G[: IuWFNg쐬܂łB'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
