#  Startup.csh Release 2.2.35 for OS/2

#  This is a sample startup.csh file.  Hamilton C shell looks for this
#  file in your home directory every time you start a new copy whether
#  from the Start Programs menu or from the command line.  You should edit
#  this file to customize it to your needs, in particular to add any
#  alias definitions you always want available each time you start
#  the shell.  Blank lines are ignored; text following a "#" on a given
#  line is considered a comment.

#  Paste the current directory onto the front of the search path if it's
#  not already there.  (See comments about the PATH variable in login.csh.)
if (path[0] != ".") set path = . $path

#  Useful constant.
@     pi       = 3.1415926535897932384626433

#  Aliases to allow these functions to be used under cmd.exe albeit
#  under different names.  (Date and vol conflict with cmd.exe builtins.)
alias date     dt
alias vol      vl

#  Aliases to simulate cmd.exe builtins.
alias md       mkdir
alias pause    (echo -n Press any key when ready ...; @ getchar; echo)
alias rd       rmdir
alias start    cmd /c start
alias type     cat

#  Alias to run the Microsoft/IBM label command.  (It has a bug which
#  prevents it from properly reading command-line arguments unless called
#  by cmd.exe.)  You can leave this commented out if you use the label.exe
#  utility supplied with Hamilton C shell instead.
#  alias label    cmd /c label

#  Aliases and procedures for intercepting copy, xcopy and rename commands so
#  that wildcarding won't be done before they're called.
proc safecopy(files)
   cmd /c copy $files; @ nowild = s; unlocal s
end
alias copy     (local s; @ s = ^$nowild; @ nowild = 1; safecopy)
proc safexcopy(files)
   xcopy.exe $files; @ nowild = s; unlocal s
end
alias xcopy    (local s; @ s = ^$nowild; @ nowild = 1; safexcopy)
proc saferename(files)
   cmd /c rename $files; @ nowild = s; unlocal s
end
alias rename   (local s; @ s = ^$nowild; @ nowild = 1; saferename)
alias ren      rename

#  Intercept the del command so "del *.*" still gives the "Are you sure?"
#  message.  (Alternately, you may prefer to simply alias it to rm.exe.)
proc safedel(files)
   cmd /c del $files; @ nowild = s; unlocal s
end
alias del      (local s; @ s = ^$nowild; @ nowild = 1; safedel)
alias erase    del

#  Intercept the dir command either with a simple alias (letting the C shell
#  do the wildcarding first) or with the same kind of alias + proc mechanism
#  used above to turn off wildcarding first.  (Dir behaves differently
#  depending on whether you let it do its own wildcarding or not.)

#  Uncomment either the simple alias to let the C shell do the wildcarding:
alias dir      cmd /c dir

#  or the following 4 lines to have dir work exactly like under cmd.exe:
#  proc safedir(files)
#     cmd /c dir $files; @ nowild = s; unlocal s
#  end
#  alias dir      (local s; @ s = ^$nowild; @ nowild = 1; safedir)

#  Alias for accessing help with the same command used in cmd.exe.
alias help     helpmsg

#  Aliases to implement obsolete Unix C shell reserved words.  (You may
#  not want these unless you have old habits.)
alias breaksw  break
alias endif    end
alias endsw    end

#  Typical locally-defined aliases.  (Edit this section to define your own.)

alias app      (cat >>)    #  Append stdin to a file.
alias beep     eval echo -n ^^a  #  Beep! (eval is used with an extra ^ so
                                 #     just listing aliases won't beep at you.)
alias cdd      cd +c       #  Change directory AND disk.
alias di       diff -b!    #  "Diff interactive":  Merged diff using color to
                           #     show changes.  Ignore white space differences.
alias duc      du -c       #  Disk usage for the current disk only.
alias f        fgrep       #  Faster name for fgrep.
alias fn       fgrep -n    #  Fgrep and print line numbers.
alias g        grep        #  Faster name for grep.
alias h        history
alias home     cdd ~       #  Change to the home directory and disk.
alias ll       ls -L       #  Long listing of the directory.
alias ld       ls -a +D -. #  List only the subdirectories.
alias loadhist source -n ~\history.csh
alias dumphist (history -s >~\history.csh)
alias mis      more -i     #  More interactive small.  (faster, limited memory)
alias mih      moreh -i    #  More interactive huge.
alias mi       moreh -i    #  Choose your default "more interactive" as
                           #     either the small or the huge version.
alias q        exit
alias rot13    tr 'n-za-mN-ZA-M' 'a-zA-Z'    #  Encoder/Decoder for off-
                                             #  color jokes on Internet.
alias uud      uudecode
alias uue      uuencode -c #  uuencode using cp-style syntax.
alias w        ((wait;beep))  #  Wait for background processes and beep.

#  If you like, count the nesting level of this invocation of csh.exe
#  and put it into the prompt of nested invocations.
if (! $?did_setlayer) then
   if ($?layer) then
      @        layer++
      set      prompt1 = '[$layer] $@ $CDISK% '
      set      prompt2 = '[$layer] $@ $CDISK? '
   else
      setenv   layer = 1
   end
   @  did_setlayer = 1
end
