//
// $Header: d:\\32bits\\ext2-os2\\minifsd\\ext2\\rcs\\super.c,v 9.1 1997/03/15 22:33:48 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifdef OS2
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0
#include <fsd.h>
#include <fsh.h>
#include <os2/types.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <string.h>
#include <linux/sched.h>
#include <linux/locks.h>
#include <os2/log.h>
#include <linux/e2_proto.h>
#endif

#ifdef OS2
#define NORET_TYPE
#define KERN_CRIT
#define KERN_WARNING
extern char scratch_buffer[];
#endif

#ifdef OS2
#define NORET_TYPE
#define KERN_CRIT
#define KERN_WARNING
#define MAJOR(dev) dev
#define MINOR(dev) 0
extern unsigned long simple_strtoul(const char *string, char **end_ptr, int radix);
INLINE void kfree_s(void *data, int size) {
    G_free(data);
}
#endif

NORET_TYPE void ext2_panic (struct super_block * sb, const char * function,
                            const char * fmt, ...)
{
        char *buf = scratch_buffer;

        va_list args;

        va_start (args, fmt);
        vsprintf (buf, fmt, args);
        va_end (args);

        ext2_os2_panic(0, "ext2fs panic (on drive %c:): %s: %s\n",
               sb->s_unit + 'A', function, buf);
}

void ext2_error (struct super_block * sb, const char * function,
                 const char * fmt, ...)
{
        char buf[1024];
        va_list args;

        va_start (args, fmt);
        vsprintf (buf, fmt, args);
        va_end (args);

	ext2_os2_panic(0, "ext2-os2 detected a file system error on drive %c: %s: %s\n",
                       sb->s_unit + 'A', function, buf);

}

void ext2_warning (struct super_block * sb, const char * function,
                   const char * fmt, ...)
{
        char buf[1024];
        va_list args;

        va_start (args, fmt);
        vsprintf (buf, fmt, args);
        va_end (args);

        printk (KERN_WARNING "EXT2-fs warning (on drive %c:): %s: %s\n",
                sb->s_unit + 'A', function, buf);

}

struct super_operations ext2_sops = {
        ext2_read_inode,
        NULL,
        NULL,             
        NULL,              
        NULL, // ext2_put_super,
        NULL, // ext2_write_super,
        NULL, // ext2_statfs,
        NULL  // ext2_remount
};

static void ext2_setup_super (struct super_block * sb,
                              struct ext2_super_block * es)
{
#ifdef OS2
    clear_opt(sb->u.ext2_sb.s_mount_opt, ERRORS_CONT);
    clear_opt(sb->u.ext2_sb.s_mount_opt, ERRORS_RO);
    set_opt(sb->u.ext2_sb.s_mount_opt, ERRORS_PANIC);
#endif

        if (es->s_rev_level > EXT2_CURRENT_REV) {
                        printk ("EXT2-fs warning: revision level too high, "
                                "forcing read/only mode\n");
                        sb->s_flags |= MS_RDONLY;
        }
#if 0
        if (!(sb->s_flags & MS_RDONLY)) {
                if (!(sb->u.ext2_sb.s_mount_state & EXT2_VALID_FS))
                        printk ("EXT2-fs warning: mounting unchecked fs, "
                                "running e2fsck is recommended\n");
                else if ((sb->u.ext2_sb.s_mount_state & EXT2_ERROR_FS))
                        printk ("EXT2-fs warning: mounting fs with errors, "
                                "running e2fsck is recommended\n");
                else if (es->s_max_mnt_count >= 0 &&
                         es->s_mnt_count >= (unsigned short) es->s_max_mnt_count)
                        printk ("EXT2-fs warning: maximal mount count reached, "
                                "running e2fsck is recommended\n");
                else if (es->s_checkinterval &&
                        (es->s_lastcheck + es->s_checkinterval <= CURRENT_TIME))
                        printk ("EXT2-fs warning: checktime reached, "
                                "running e2fsck is recommended\n");
                es->s_state &= ~EXT2_VALID_FS;
                if (!es->s_max_mnt_count)
                        es->s_max_mnt_count = EXT2_DFL_MAX_MNT_COUNT;
#ifndef OS2
                es->s_mnt_count++;
#else
                //
                // This is to force Linux to autocheck the ext2fs partition "touched" by OS/2
                // this autocheck is enabled unless -no_auto_fsck is specified on the IFS cmd
                // line
                //
                if (auto_fsck) {
                    kernel_printf("e2fsck will be forced next time Linux will mount this partition");
                      es->s_mnt_count = EXT2_DFL_MAX_MNT_COUNT;
                } else {
                    es->s_mnt_count++;
                }
#endif
                es->s_mtime = CURRENT_TIME;
                mark_buffer_dirty(sb->u.ext2_sb.s_sbh, 1);
                sb->s_dirt = 1;
#ifndef OS2 // For the moment .....
                if (test_opt (sb, DEBUG))
#endif
                        printk ("[EXT II FS %s, %s, bs=%lu, fs=%lu, gc=%lu, "
                                "bpg=%lu, ipg=%lu, mo=%04lx]\n",
                                EXT2FS_VERSION, EXT2FS_DATE, sb->s_blocksize,
                                sb->u.ext2_sb.s_frag_size,
                                sb->u.ext2_sb.s_groups_count,
                                EXT2_BLOCKS_PER_GROUP(sb),
                                EXT2_INODES_PER_GROUP(sb),
                                sb->u.ext2_sb.s_mount_opt);
#ifndef OS2 // For the moment .....
                if (test_opt (sb, CHECK)) {
#endif
                        ext2_check_blocks_bitmap (sb);
                        ext2_check_inodes_bitmap (sb);
#ifndef OS2 // For the moment .....
                }
#endif
        }
#endif
}

static int ext2_check_descriptors (struct super_block * sb)
{
	int i;
	int desc_block = 0;
	unsigned long block = sb->u.ext2_sb.s_es->s_first_data_block;
	struct ext2_group_desc * gdp = NULL;

	ext2_debug ("Checking group descriptors");

	for (i = 0; i < sb->u.ext2_sb.s_groups_count; i++)
	{
		if ((i % EXT2_DESC_PER_BLOCK(sb)) == 0)
			gdp = (struct ext2_group_desc *) sb->u.ext2_sb.s_group_desc[desc_block++]->b_data;
		if (gdp->bg_block_bitmap < block ||
		    gdp->bg_block_bitmap >= block + EXT2_BLOCKS_PER_GROUP(sb))
		{
			ext2_error (sb, "ext2_check_descriptors",
				    "Block bitmap for group %d"
				    " not in group (block %lu)!",
				    i, (unsigned long) gdp->bg_block_bitmap);
			return 0;
		}
		if (gdp->bg_inode_bitmap < block ||
		    gdp->bg_inode_bitmap >= block + EXT2_BLOCKS_PER_GROUP(sb))
		{
			ext2_error (sb, "ext2_check_descriptors",
				    "Inode bitmap for group %d"
				    " not in group (block %lu)!",
				    i, (unsigned long) gdp->bg_inode_bitmap);
			return 0;
		}
		if (gdp->bg_inode_table < block ||
		    gdp->bg_inode_table + sb->u.ext2_sb.s_itb_per_group >=
		    block + EXT2_BLOCKS_PER_GROUP(sb))
		{
			ext2_error (sb, "ext2_check_descriptors",
				    "Inode table for group %d"
				    " not in group (block %lu)!",
				    i, (unsigned long) gdp->bg_inode_table);
			return 0;
		}
		block += EXT2_BLOCKS_PER_GROUP(sb);
		gdp++;
	}
	return 1;
}

/*
 * This function has been shamelessly adapted from the msdos fs
 */
static int parse_options (char * options, unsigned long * sb_block,
			  unsigned short *resuid, unsigned short * resgid,
			  unsigned long * mount_options)
{
	char * this_char;
	char * value;

	if (!options)
		return 1;
	for (this_char = strtok (options, ",");
	     this_char != NULL;
	     this_char = strtok (NULL, ",")) {
		if ((value = strchr (this_char, '=')) != NULL)
			*value++ = 0;
		if (!strcmp (this_char, "bsddf"))
			clear_opt (*mount_options, MINIX_DF);
		else if (!strcmp (this_char, "check")) {
			if (!value || !*value)
				set_opt (*mount_options, CHECK_NORMAL);
			else if (!strcmp (value, "none")) {
				clear_opt (*mount_options, CHECK_NORMAL);
				clear_opt (*mount_options, CHECK_STRICT);
			}
			else if (strcmp (value, "normal"))
				set_opt (*mount_options, CHECK_NORMAL);
			else if (strcmp (value, "strict")) {
				set_opt (*mount_options, CHECK_NORMAL);
				set_opt (*mount_options, CHECK_STRICT);
			}
			else {
				printk ("EXT2-fs: Invalid check option: %s\n",
					value);
				return 0;
			}
		}
		else if (!strcmp (this_char, "debug"))
			set_opt (*mount_options, DEBUG);
		else if (!strcmp (this_char, "errors")) {
			if (!value || !*value) {
				printk ("EXT2-fs: the errors option requires "
					"an argument");
				return 0;
			}
			if (!strcmp (value, "continue")) {
				clear_opt (*mount_options, ERRORS_RO);
				clear_opt (*mount_options, ERRORS_PANIC);
				set_opt (*mount_options, ERRORS_CONT);
			}
			else if (!strcmp (value, "remount-ro")) {
				clear_opt (*mount_options, ERRORS_CONT);
				clear_opt (*mount_options, ERRORS_PANIC);
				set_opt (*mount_options, ERRORS_RO);
			}
			else if (!strcmp (value, "panic")) {
				clear_opt (*mount_options, ERRORS_CONT);
				clear_opt (*mount_options, ERRORS_RO);
				set_opt (*mount_options, ERRORS_PANIC);
			}
			else {
				printk ("EXT2-fs: Invalid errors option: %s\n",
					value);
				return 0;
			}
		}
		else if (!strcmp (this_char, "grpid") ||
			 !strcmp (this_char, "bsdgroups"))
			set_opt (*mount_options, GRPID);
		else if (!strcmp (this_char, "minixdf"))
			set_opt (*mount_options, MINIX_DF);
		else if (!strcmp (this_char, "nocheck")) {
			clear_opt (*mount_options, CHECK_NORMAL);
			clear_opt (*mount_options, CHECK_STRICT);
		}
		else if (!strcmp (this_char, "nogrpid") ||
			 !strcmp (this_char, "sysvgroups"))
			clear_opt (*mount_options, GRPID);
		else if (!strcmp (this_char, "resgid")) {
			if (!value || !*value) {
				printk ("EXT2-fs: the resgid option requires "
					"an argument");
				return 0;
			}
			*resgid = (unsigned short)simple_strtoul (value, &value, 0);
			if (*value) {
				printk ("EXT2-fs: Invalid resgid option: %s\n",
					value);
				return 0;
			}
		}
		else if (!strcmp (this_char, "resuid")) {
			if (!value || !*value) {
				printk ("EXT2-fs: the resuid option requires "
					"an argument");
				return 0;
			}
			*resuid = (unsigned short)simple_strtoul (value, &value, 0);
			if (*value) {
				printk ("EXT2-fs: Invalid resuid option: %s\n",
					value);
				return 0;
			}
		}
		else if (!strcmp (this_char, "sb")) {
			if (!value || !*value) {
				printk ("EXT2-fs: the sb option requires "
					"an argument");
				return 0;
			}
			*sb_block = simple_strtoul (value, &value, 0);
			if (*value) {
				printk ("EXT2-fs: Invalid sb option: %s\n",
					value);
				return 0;
			}
		}
		else {
			printk ("EXT2-fs: Unrecognized mount option %s\n", this_char);
			return 0;
		}
	}
	return 1;
}

struct super_block * ext2_read_super (struct super_block * sb, void * data,
				      int silent)
{
	struct buffer_head * bh;
	struct ext2_super_block * es;
	unsigned long sb_block = 1;
	unsigned short resuid = EXT2_DEF_RESUID;
	unsigned short resgid = EXT2_DEF_RESGID;
	unsigned long logic_sb_block = 1;
	int dev = sb->s_dev;
	int db_count;
	int i, j;
#ifdef EXT2FS_PRE_02B_COMPAT
	int fs_converted = 0;
#endif

#ifndef OS2
	set_opt (sb->u.ext2_sb.s_mount_opt, CHECK_NORMAL);
#else
	set_opt (sb->u.ext2_sb.s_mount_opt, CHECK_STRICT);
#endif
	if (!parse_options ((char *) data, &sb_block, &resuid, &resgid,
	    &sb->u.ext2_sb.s_mount_opt)) {
		sb->s_dev = 0;
		return NULL;
	}

	lock_super (sb);
#if 0
	set_blocksize (dev, BLOCK_SIZE);
#endif
	if (!(bh = bread (dev, sb_block, BLOCK_SIZE))) {
		sb->s_dev = 0;
		unlock_super (sb);
		printk ("EXT2-fs: unable to read superblock\n");
		return NULL;
	}
	/*
	 * Note: s_es must be initialized s_es as soon as possible because
	 * some ext2 macro-instructions depend on its value
	 */
	es = (struct ext2_super_block *) bh->b_data;
	sb->u.ext2_sb.s_es = es;
	sb->s_magic = es->s_magic;
	if (sb->s_magic != EXT2_SUPER_MAGIC
#ifdef EXT2FS_PRE_02B_COMPAT
	   && sb->s_magic != EXT2_PRE_02B_MAGIC
#endif
	   ) {
		sb->s_dev = 0;
		unlock_super (sb);
		brelse (bh);
		if (!silent)
			printk ("VFS: Can't find an ext2 filesystem on dev %d/%d.\n",
				MAJOR(dev), MINOR(dev));
		return NULL;
	}
	sb->s_blocksize = EXT2_MIN_BLOCK_SIZE << es->s_log_block_size;
	sb->s_blocksize_bits = EXT2_BLOCK_SIZE_BITS(sb);
#if 1
	if (sb->s_blocksize != BLOCK_SIZE) {
			sb->s_dev = 0;
			unlock_super (sb);
			brelse (bh);
			printk ("EXT2-fs: Magic mismatch, very weird !\n");
			return NULL;
        }
#else
	if (sb->s_blocksize != BLOCK_SIZE && 
	    (sb->s_blocksize == 1024 || sb->s_blocksize == 2048 ||  
	     sb->s_blocksize == 4096)) {
		unsigned long offset;

		brelse (bh);
		set_blocksize (dev, sb->s_blocksize);
		logic_sb_block = (sb_block*BLOCK_SIZE) / sb->s_blocksize;
		offset = (sb_block*BLOCK_SIZE) % sb->s_blocksize;
		bh = bread (dev, logic_sb_block, sb->s_blocksize);
		if(!bh)
			return NULL;
		es = (struct ext2_super_block *) (((char *)bh->b_data) + offset);
		sb->u.ext2_sb.s_es = es;
		if (es->s_magic != EXT2_SUPER_MAGIC) {
			sb->s_dev = 0;
			unlock_super (sb);
			brelse (bh);
			printk ("EXT2-fs: Magic mismatch, very weird !\n");
			return NULL;
		}
	}
#endif
	sb->u.ext2_sb.s_frag_size = EXT2_MIN_FRAG_SIZE <<
				   es->s_log_frag_size;
	if (sb->u.ext2_sb.s_frag_size)
		sb->u.ext2_sb.s_frags_per_block = sb->s_blocksize /
						  sb->u.ext2_sb.s_frag_size;
	else
		sb->s_magic = 0;
	sb->u.ext2_sb.s_blocks_per_group = es->s_blocks_per_group;
	sb->u.ext2_sb.s_frags_per_group = es->s_frags_per_group;
	sb->u.ext2_sb.s_inodes_per_group = es->s_inodes_per_group;
	sb->u.ext2_sb.s_inodes_per_block = sb->s_blocksize /
					   sizeof (struct ext2_inode);
	sb->u.ext2_sb.s_itb_per_group = sb->u.ext2_sb.s_inodes_per_group /
				        sb->u.ext2_sb.s_inodes_per_block;
	sb->u.ext2_sb.s_desc_per_block = sb->s_blocksize /
					 sizeof (struct ext2_group_desc);
	sb->u.ext2_sb.s_sbh = bh;
	sb->u.ext2_sb.s_es = es;
	if (resuid != EXT2_DEF_RESUID)
		sb->u.ext2_sb.s_resuid = resuid;
	else
		sb->u.ext2_sb.s_resuid = es->s_def_resuid;
	if (resgid != EXT2_DEF_RESGID)
		sb->u.ext2_sb.s_resgid = resgid;
	else
		sb->u.ext2_sb.s_resgid = es->s_def_resgid;
	sb->u.ext2_sb.s_mount_state = es->s_state;
	sb->u.ext2_sb.s_rename_lock = 0;
#ifndef OS2  
	sb->u.ext2_sb.s_rename_wait = NULL;
#else
	sb->u.ext2_sb.s_rename_wait = 0;
#endif
#ifdef EXT2FS_PRE_02B_COMPAT
	if (sb->s_magic == EXT2_PRE_02B_MAGIC) {
		if (es->s_blocks_count > 262144) {
			/*
			 * fs > 256 MB can't be converted
			 */ 
			sb->s_dev = 0;
			unlock_super (sb);
			brelse (bh);
			printk ("EXT2-fs: trying to mount a pre-0.2b file"
				"system which cannot be converted\n");
			return NULL;
		}
		printk ("EXT2-fs: mounting a pre 0.2b file system, "
			"will try to convert the structure\n");
		if (!(sb->s_flags & MS_RDONLY)) {
			sb->s_dev = 0;
			unlock_super (sb);
			brelse (bh);
			printk ("EXT2-fs: cannot convert a read-only fs\n");
			return NULL;
		}
		if (!convert_pre_02b_fs (sb, bh)) {
			sb->s_dev = 0;
			unlock_super (sb);
			brelse (bh);
			printk ("EXT2-fs: conversion failed !!!\n");
			return NULL;
		}
		printk ("EXT2-fs: conversion succeeded !!!\n");
		fs_converted = 1;
	}
#endif
	if (sb->s_magic != EXT2_SUPER_MAGIC) {
		sb->s_dev = 0;
		unlock_super (sb);
		brelse (bh);
		if (!silent)
			printk ("VFS: Can't find an ext2 filesystem on dev %d/%d.\n",
				MAJOR(dev), MINOR(dev));
		return NULL;
	}
#ifndef MINIFSD
	if (sb->s_blocksize != bh->b_size) {
		sb->s_dev = 0;
		unlock_super (sb);
		brelse (bh);
		if (!silent)
			printk ("VFS: Unsupported blocksize on dev 0x%04x.\n",
				dev);
		return NULL;
	}
#endif
	if (sb->s_blocksize != sb->u.ext2_sb.s_frag_size) {
		sb->s_dev = 0;
		unlock_super (sb);
		brelse (bh);
		printk ("EXT2-fs: fragsize %lu != blocksize %lu (not supported yet)\n",
			sb->u.ext2_sb.s_frag_size, sb->s_blocksize);
		return NULL;
	}

	sb->u.ext2_sb.s_groups_count = (es->s_blocks_count -
				        es->s_first_data_block +
				       EXT2_BLOCKS_PER_GROUP(sb) - 1) /
				       EXT2_BLOCKS_PER_GROUP(sb);
	db_count = (sb->u.ext2_sb.s_groups_count + EXT2_DESC_PER_BLOCK(sb) - 1) /
		   EXT2_DESC_PER_BLOCK(sb);
#ifndef OS2
	sb->u.ext2_sb.s_group_desc = kmalloc (db_count * sizeof (struct buffer_head *), GFP_KERNEL);
	if (sb->u.ext2_sb.s_group_desc == NULL) {
#else
//	if (DevHlp32_VMAlloc(db_count * sizeof (struct buffer_head *), VMDHA_NOPHYSADDR, VMDHA_SWAP, (void **)(&(sb->u.ext2_sb.s_group_desc))) != NO_ERROR) {
	if ((sb->u.ext2_sb.s_group_desc = G_malloc(db_count * sizeof (struct buffer_head *))) == 0) {
#endif
		sb->s_dev = 0;
		unlock_super (sb);
		brelse (bh);
		printk ("EXT2-fs: not enough memory\n");
		return NULL;
	}
	for (i = 0; i < db_count; i++) {
		sb->u.ext2_sb.s_group_desc[i] = bread (dev, logic_sb_block + i + 1,
						       sb->s_blocksize);
		if (!sb->u.ext2_sb.s_group_desc[i]) {
			sb->s_dev = 0;
			unlock_super (sb);
			for (j = 0; j < i; j++)
				brelse (sb->u.ext2_sb.s_group_desc[j]);
			kfree_s (sb->u.ext2_sb.s_group_desc,
				 db_count * sizeof (struct buffer_head *));
			brelse (bh);
			printk ("EXT2-fs: unable to read group descriptors\n");
			return NULL;
		}
	}
	if (!ext2_check_descriptors (sb)) {
		sb->s_dev = 0;
		unlock_super (sb);
		for (j = 0; j < db_count; j++)
			brelse (sb->u.ext2_sb.s_group_desc[j]);
		kfree_s (sb->u.ext2_sb.s_group_desc,
			 db_count * sizeof (struct buffer_head *));
		brelse (bh);
		printk ("EXT2-fs: group descriptors corrupted !\n");
		return NULL;
	}
	for (i = 0; i < EXT2_MAX_GROUP_LOADED; i++) {
		sb->u.ext2_sb.s_inode_bitmap_number[i] = 0;
		sb->u.ext2_sb.s_inode_bitmap[i] = NULL;
		sb->u.ext2_sb.s_block_bitmap_number[i] = 0;
		sb->u.ext2_sb.s_block_bitmap[i] = NULL;
	}
	sb->u.ext2_sb.s_loaded_inode_bitmaps = 0;
	sb->u.ext2_sb.s_loaded_block_bitmaps = 0;
	sb->u.ext2_sb.s_db_per_group = db_count;
	unlock_super (sb);
	/*
	 * set up enough so that it can read an inode
	 */
	sb->s_dev = dev;
	sb->s_op = &ext2_sops;
	if (!(sb->s_mounted = iget (sb, EXT2_ROOT_INO))) {
		sb->s_dev = 0;
		for (i = 0; i < db_count; i++)
			if (sb->u.ext2_sb.s_group_desc[i])
				brelse (sb->u.ext2_sb.s_group_desc[i]);
		kfree_s (sb->u.ext2_sb.s_group_desc,
			 db_count * sizeof (struct buffer_head *));
		brelse (bh);
		printk ("EXT2-fs: get root inode failed\n");
		return NULL;
	}
#ifdef EXT2FS_PRE_02B_COMPAT
	if (fs_converted) {
		for (i = 0; i < db_count; i++)
			mark_buffer_dirty(sb->u.ext2_sb.s_group_desc[i], 1);
		sb->s_dirt = 1;
	}
#endif
	ext2_setup_super (sb, es);
	return sb;
}


struct file_system_type ext2_fs_type = {
        ext2_read_super, "ext2", 1, NULL
};

char *G_malloc_fixed(unsigned long cbSize) {
    unsigned long  ptr;
    unsigned short seg;

    ptr = 0;
    if (FSH_SEGALLOC(SA_FRING0 | SA_FSWAP, cbSize, &seg) == NO_ERROR) {
        ptr = ((unsigned long)seg) << 16;
    }

    return (char *)ptr;
}


#define ERROR_VOLUME_NOT_MOUNTED 0xEE00                // IFS specific

/*
 * This routine reads the superblock and tests if it can be an ext2 file system.
 * It does NOT use buffers from the cache.
 */
int check_ext2fs_magic(struct vpfsi *pvpfsi, unsigned short hVPB) {
    int   nb_sec;
    int   rc;
    char *buf;
    struct ext2_super_block *es;

    //
    // Allocates a temporary buffer
    //
    if ((buf = G_malloc_fixed(BLOCK_SIZE)) != 0) {

        //
        // Reads disk block 1 (with blocksize = 1024)
        //
        nb_sec = BLOCK_SIZE / pvpfsi->vpi_bsize;
        if ((rc = FSH_DOVOLIO(
                              DVIO_OPREAD,
                              DVIO_ALLABORT | DVIO_ALLRETRY | DVIO_ALLFAIL,
                              hVPB,
                              buf,
                              &nb_sec,
                              nb_sec
                             )) == NO_ERROR) {

            es = (struct ext2_super_block *)buf;
            if (es->s_magic == EXT2_SUPER_MAGIC) {
                kernel_printf("ext2 signature found in superblock (hVPB = 0x%04X)", hVPB);
		rc = NO_ERROR;
            } else {
                kernel_printf("ext2 signature NOT found in superblock (hVPB = 0x%04X)", hVPB);
		rc = ERROR_VOLUME_NOT_MOUNTED;
            }

        } else {
	    kernel_printf("check_ext2fs_magic - fsh32_dovolio returned %d", rc);
        }

        G_free(buf);
    } else {
        kernel_printf("check_ext2fs_magic - VMAlloc returned %d", rc);
    }
    return rc;

}
