' SIMPLINE.BAS

Option Explicit

Dim FatalFlag As Integer
Dim Code As Integer

Sub Aborting ()
  Dim Code As Integer
  EASY.Print "Fatal Error, Aborting..."
  Code = SioDone(ThePort)
  End
End Sub

Sub GetIncoming ()
  Dim i As Integer
  Dim Buffer As String * 1024
  Dim Count As Integer
  Count = SioGets(ThePort, Buffer, 1024)
  If Count > 0 Then
    For i = 1 To Count
      Call DisplayChar(EASY, Asc(Mid$(Buffer, i, 1)))
    Next i
  End If
End Sub

Sub GoOffLine ()
  Dim Code As Integer
  OnLineFlag = 0
  'shut down port
  Code = SioDone(ThePort)
End Sub

Sub GoOnLine ()
  Dim i As Integer
  Dim RxQueSize As Integer
  Dim TxQueSize As Integer
  If OnLineFlag Then
    Exit Sub
  End If
  'reset the port (1024 byte RX buffer & 256 byte TX buffer)
  RxQueSize = 1024
  TxQueSize = 256
  Code = SioReset(ThePort, RxQueSize, TxQueSize)
  If Code < 0 Then
    Call SayError(EASY, Code)
    Exit Sub
  End If
  'set baud rate
  Code = SioBaud(ThePort, TheBaudCode)
  'call Aborting() if detect error after resetting port
  Call DisplayLine(EASY, "COM" + LTrim$(Str$(1 + ThePort)) + " reset")
  'set DTR & RTS
  Code = SioDTR(ThePort, Asc("S"))
  Code = SioRTS(ThePort, Asc("S"))
  'turn on hardware flow control
  '''Code = SioFlow(ThePort, Asc("H"))
  ' set parms
  Code = SioParms(ThePort, NoParity, OneStopBit, WordLength8)
  ' we're online !
  OnLineFlag = 1
End Sub

Sub SetBaud ()
Dim Code As Integer
'Baudrate can be changed while running
Code = SioBaud(ThePort, TheBaudCode)
End Sub

Sub ShowConfig ()
  Dim A As String
  Dim B As String
  Dim C As String
  If OnLineFlag Then
    A = " (Online)"
  Else
    A = " (Offline)"
  End If
  B = "COM" + LTrim$(Str$(ThePort + 1))
  C = " @ " + BaudRateTable(TheBaudCode) + " "
  EASY.Caption = "EASY: " + B + C + A
End Sub

