'
'   FILE    vt100.bas
'
'       This is the code to emulate a vt100 and interface to the windows API
'
'   Charles McGuinness [76701,11]
'
'
Dim curx            As Integer
Dim cury            As Integer
Dim curpx           As Integer
Dim curpy           As Integer

Dim InEscape        As Integer      ' Processing an escape seq?
Dim EscString       As String       ' String so far

Dim CharHeight      As Integer
Dim CharWidth       As Integer

Dim CurState        As Integer

Dim ttyhdc          As Integer

Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer

'   Ternary raster operations
Const SRCCOPY = &HCC0020        ' (DWORD) dest = source
Const SRCPAINT = &HEE0086       ' (DWORD) dest = source OR dest
Const SRCAND = &H8800C6         ' (DWORD) dest = source AND dest
Const SRCINVERT = &H660046      ' (DWORD) dest = source XOR dest
Const SRCERASE = &H440328       ' (DWORD) dest = source AND (NOT dest )
Const NOTSRCCOPY = &H330008     ' (DWORD) dest = (NOT source)
Const NOTSRCERASE = &H1100A6    ' (DWORD) dest = (NOT src) AND (NOT dest)
Const MERGECOPY = &HC000CA      ' (DWORD) dest = (source AND pattern)
Const MERGEPAINT = &HBB0226     ' (DWORD) dest = (NOT source) OR dest
Const PATCOPY = &HF00021        ' (DWORD) dest = pattern
Const PATPAINT = &HFB0A09       ' (DWORD) dest = DPSnoo
Const PATINVERT = &H5A0049      ' (DWORD) dest = pattern XOR dest
Const DSTINVERT = &H550009      ' (DWORD) dest = (NOT dest)
Const BLACKNESS = &H42&         ' (DWORD) dest = BLACK
Const WHITENESS = &HFF0062      ' (DWORD) dest = WHITE

'
'   Calls to output text
'
Declare Function TextOut Lib "GDI" (ByVal hdc%, ByVal x%, ByVal y%, ByVal lpString$, ByVal nCount%) As Integer

'
'   Set text to transparent or opaque
'
Declare Function SetBkMode Lib "GDI" (ByVal hdc%, ByVal nmode%) As Integer

Const TRANSPARENT = 1
Const OPAQUE = 2

'
'   Color management
'
Declare Function GetTextColor Lib "GDI" (ByVal hdc%) As Long
Declare Function SetTextColor Lib "GDI" (ByVal hdc%, newcolor As Long) As Long

Declare Function GetBkColor Lib "GDI" (ByVal hdc%) As Long
Declare Function SetBkColor Lib "GDI" (ByVal hdc%, newcolor As Long) As Long



Dim ScrImage(0 To 23) As String * 80
''' Removed to improve speed ''' Dim ScrAttr(0 to 23) As String * 80
Dim Normal80 As String
''' Removed to improve speed ''' Dim CurAttr As String


'
'   Current Buffered Text
'

    Dim outstr As String
    Dim outx As Integer
    Dim outlen As Integer

'
'   Flag to indicate that we're ready to run
'
    Dim FlagInit As Integer

Sub term_init ()
    curx = 0
    cury = 0
    curpx = 0
    curpy = 0
    InEscape = 0
    CurState = 0
    
    outx = curpx
    outstr = ""
    outlen = 0

    CharHeight = tty.TextHeight("M")
    CharWidth = tty.TextWidth("M")

    r% = SetBkMode(tty.hdc, OPAQUE)
    disp_cursor

    ''' Removed to improve speed '''     Normal80 = String$(80, "0")

    For i% = 0 To 23
        ScrImage(i%) = Space$(80)
        ''' Removed to improve speed '''         ScrAttr(i%) = Normal80
    Next i%

    ''' Removed to improve speed '''     CurAttr = "0"

    FlagInit = -1
End Sub

Sub disp_cursor ()

    If CurState <> 0 Then Exit Sub

    sx% = curpx
    sy% = curpy

    If tty.windowstate <> 1 Then
        ttyhdc = tty.hdc
        r% = BitBlt(ttyhdc, sx%, sy%, CharWidth, CharHeight, ttyhdc, sx%, sy%, DSTINVERT)
    End If

    CurState = -1

End Sub

Sub compute_xy ()
    curpx = curx * CharWidth
    curpy = cury * CharHeight
End Sub

Sub hide_cursor ()

    If CurState = 0 Then Exit Sub

    sx% = curpx
    sy% = curpy


    If tty.windowstate <> 1 Then
        ttyhdc = tty.hdc
        r% = BitBlt(ttyhdc, sx%, sy%, CharWidth, CharHeight, ttyhdc, sx%, sy%, DSTINVERT)
    End If

    CurState = 0
End Sub

Sub scroll_up ()
    Dim wid As Integer
    Dim High As Integer
    Dim cHigh As Integer

    wid = tty.width
    cHigh = CharHeight
    High = 23 * cHigh

    If (High > tty.ScaleHeight) Then
        High = tty.ScaleHeight
        End If

    If tty.windowstate <> 1 Then
        ttyhdc = tty.hdc
        r% = BitBlt(ttyhdc, 0, 0, wid, High, ttyhdc, 0, cHigh, SRCCOPY)
        r% = BitBlt(ttyhdc, 0, High, wid, cHigh, ttyhdc, 0, High, WHITENESS)
    End If

    For i% = 0 To 22
        ScrImage(i%) = ScrImage(i% + 1)
''' Removed to improve speed '''         ScrAttr(i%) = ScrAttr(i% + 1)
    Next i%

    ScrImage(23) = Space$(80)
''' Removed to improve speed '''     ScrAttr(24) = Normal80

End Sub

Sub term_put (buf As String, cnt As Integer)

    Dim i As Integer
    Dim ch As Integer

    If (CurState <> 0) Then
        Call hide_cursor
    End If

    i = 1

    If (InEscape = 0) Then
        GoTo CharLoop
    End If

EscapeLoop:

    Do
        Call AddEscape(Asc(Mid$(buf, i, 1)))
        outx = curpx
        i = i + 1
        If (InEscape = 0) And (i <= cnt) Then
            GoTo CharLoop
        End If
    Loop While i <= cnt

    Exit Sub

CharLoop:

    Do
        C$ = Mid$(buf, i, 1)
        ch = Asc(C$)

        If ch > 31 Then
            outstr = outstr + C$
            outlen = outlen + 1
            Mid$(ScrImage(cury), curx + 1, 1) = C$
            ''' Removed to improve speed ''' Mid$(ScrAttr(cury), curx + 1, 1) = CurAttr
            curx = curx + 1
            curpx = curpx + CharWidth

            If (curx = 80) Then
                Call WriteText
                Call term_put(Chr$(13) + Chr$(10), 2)
            End If

        Else
                Select Case ch

                Case 13     ' Return
                    If (outlen <> 0) Then Call WriteText

                    curx = 0
                    curpx = 0
                    outx = curpx

                Case 10     ' Line Feed
                    If (outlen <> 0) Then Call WriteText
                
                    cury = cury + 1
                    If (cury = 24) Then
                        Call scroll_up
                        cury = 23
                    Else
                        curpy = curpy + CharHeight
                    End If

                Case 8  ' Backspace
                    If (outlen <> 0) Then Call WriteText
                
                    curx = curx - 1
                    If curx < 0 Then
                        curx = 0
                    Else
                        curpx = curpx - CharWidth
                        outx = curpx
                    End If

                Case 9  ' TAB (non-destructive)

                    If (curx < 72) Then
                        If (outlen <> 0) Then
                            Call WriteText
                        End If
                        curx = curx + (8 - (curx Mod 8))
                        curpx = curx * CharWidth
                        outx = curpx
                    End If

                ' BEL
                Case 7
                    Beep

                ' Escape
                Case 27
                    If (outlen <> 0) Then WriteText
                    If (FlagMonitor <> 0) Then
                        Call term_put("ESC", 3)
                    Else
                        Call StartEscape
                        i = i + 1
                        If (i <= cnt) Then GoTo EscapeLoop
                    End If
                End Select
        End If

        i = i + 1
    Loop While i <= cnt

End Sub

Sub StartEscape ()
    InEscape = -1
    EscString = ""
End Sub

Sub AddEscape (ch As Integer)

    Dim C As String
    Dim l As Long


    C = Chr$(ch)

    If EscString = "" And C <> "[" Then
        InEscape = 0
        Exit Sub
        End If

    EscString = EscString + C

    If (LCase$(C) = UCase$(C)) Then
        Rem Not a letter ...

        If Len(EscString) > 16 Then InEscape = 0
        Exit Sub
        End If

    Select Case C

    Case "H", "f"
        EscString = Mid$(EscString, 2)
        cury = Val(PopArg(EscString)) - 1
        If (cury < 0) Then cury = 0
        curx = Val(EscString) - 1
        If (curx < 0) Then curx = 0
        compute_xy

    Case "A"
        EscString = Mid$(EscString, 2)
        If (isdigit(EscString)) Then
            cury = cury - Val(PopArg(EscString))
        Else
            cury = cury - 1
        End If
        If (cury < 0) Then cury = 0
        Call compute_xy

    Case "B"
        EscString = Mid$(EscString, 2)
        If (isdigit(EscString) <> 0) Then
            cury = cury + Val(PopArg(EscString))
        Else
            cury = cury + 1
        End If
        If (cury > 23) Then cury = 23
        Call compute_xy

    Case "C"
        EscString = Mid$(EscString, 2)
        If (isdigit(EscString)) Then
            curx = curx + Val(PopArg(EscString))
        Else
            curx = curx + 1
        End If
        If (curx > 79) Then cury = 79
        Call compute_xy

    Case "D"
        EscString = Mid$(EscString, 2)
        If (isdigit(EscString)) Then
            curx = curx - Val(PopArg(EscString))
        Else
            curx = curx - 1
        End If
        If (curx < 0) Then cury = 0
        Call compute_xy


    Case "K"
        Select Case Val(Mid$(EscString, 2))
        Case 0
            Call erase_eol
        Case 1
            Call erase_bol
        Case 2
            Call erase_line
        End Select

    Case "J"
        Select Case Val(Mid$(EscString, 2))
        Case 0
            Call erase_eos
        Case 1
            Call erase_bos
        Case 2
            Call erase_screen
        End Select

''' Removed to improve speed '''     Case "m"
''' Removed to improve speed '''         EscString = Mid$(EscString, 2)
''' Removed to improve speed '''         Do
''' Removed to improve speed '''             Call SetAttr(PopArg(EscString))
''' Removed to improve speed '''         Loop While EscString <> ""
    End Select

    InEscape = 0
    EscString = ""

End Sub

Function PopArg (s As String) As String
'
'   PopArg takes the next argument (digits up to a ;) and
'   returns it.  It also removes the arg and the ; from
'   the "s"

    If InStr(s, ";") = 0 Then
        PopArg = s
        s = ""
        Exit Function
    End If

    i% = InStr(s, ";")
    PopArg = Left$(s, i% - 1)
    s = Mid$(s$, i% + 1)
End Function

Sub erase_bos ()
'
'   Erase from Beginning of Screen
'
    Dim wid As Integer
    Dim High As Integer
    Dim cHigh As Integer

    Call erase_bol

    If (cury = 0) Then Exit Sub

    wid = tty.width
    cHigh = CharHeight
    High = (cury - 1) * cHigh

    If tty.windowstate <> 1 Then
        ttyhdc = tty.hdc
        r% = BitBlt(ttyhdc, 0, 0, wid, High, ttyhdc, 0, 0, WHITENESS)
    End If
    For y% = 0 To cury - 1
        ScrImage(y%) = Space$(80)
''' Removed to improve speed '''         ScrAttr(y%) = Normal80
        Next y%

End Sub

Sub erase_line ()
'   Erase Line

    Dim wid As Integer
    Dim High As Integer
    Dim cHigh As Integer
    Dim StartX As Integer

    wid = tty.width
    cHigh = tty.TextHeight("M")
    High = cury * cHigh

    If tty.windowstate <> 1 Then
        r% = BitBlt(tty.hdc, 0, High, wid, cHigh, tty.hdc, 0, High, WHITENESS)
    End If

    ScrImage(cury) = Space$(80)
''' Removed to improve speed '''     ScrAttr(cury) = Normal80
End Sub

Sub erase_eos ()
'
'   Erase to end of screen
'
    Dim wid As Integer
    Dim High As Integer
    Dim cHigh As Integer
    Dim StartY As Integer

    Call erase_eol

    If (cury = 23) Then Exit Sub

    wid = tty.ScaleWidth
    cHigh = tty.TextHeight("M")
    StartY = (cury + 1) * cHigh
    High = 24 * cHigh - StartY


    If tty.windowstate <> 1 Then
        r% = BitBlt(tty.hdc, 0, StartY, wid, High, tty.hdc, 0, StartY, WHITENESS)
    End If

    For y% = cury + 1 To 23
        ScrImage(y%) = Space$(80)
''' Removed to improve speed '''         ScrAttr(y%) = Normal80
    Next y%
End Sub

Sub erase_eol ()
'
'   Erase to End of Line
'
    Dim wid As Integer
    Dim High As Integer
    Dim cHigh As Integer
    Dim StartX As Integer

    wid = tty.width
    cHigh = CharHeight
    High = curpy
    StartX = curpx

    If tty.windowstate <> 1 Then
        r% = BitBlt(tty.hdc, StartX, High, wid - StartX, cHigh, tty.hdc, StartX, High, WHITENESS)
    End If

    Mid$(ScrImage(cury), curx + 1, 80 - curx) = Space$(80 - curx)
''' Removed to improve speed '''     Mid$(ScrAttr(cury), curx + 1, 80 - curx) = String$(80 - curx, "0")

End Sub

Sub erase_bol ()
'
'   Erase From Beginning of Line
'
    Dim wid As Integer
    Dim High As Integer
    Dim cHigh As Integer


    cHigh = CharHeight
    High = curpy
    wid = curpx

    If tty.windowstate <> 1 Then
        ttyhdc = tty.hdc
        r% = BitBlt(ttyhdc, 0, High, wid, cHigh, ttyhdc, 0, High, WHITENESS)
    End If

    Mid$(ScrImage(cury), 1, curx + 1) = Space$(curx + 1)
''' Removed to improve speed '''     Mid$(ScrAttr(cury), 1, curx + 1) = String$(curx + 1, "0")

End Sub

Sub erase_screen ()
    tty.Cls
    For y% = 0 To 23
        ScrImage(y%) = Space$(80)
''' Removed to improve speed '''         ScrAttr(y%) = Normal80
        Next y%
End Sub

Sub WriteText ()
    r% = TextOut(tty.hdc, outx, curpy, outstr, outlen)
    outstr = ""
    outlen = 0
    outx = curpx
End Sub

Sub RedrawScreen ()
    Dim oldcur As Integer
    Dim oldattr As String


    If FlagInit <> -1 Then Exit Sub

    If tty.windowstate = 1 Then Exit Sub

    oldcur = CurState

''' Removed to improve speed '''    oldattr = CurAttr

    Call hide_cursor
''' Removed to improve speed '''    Call SetAttr("0")

    ttyhdc = tty.hdc
    ty% = 0
    For y% = 0 To 23
''' Removed to improve speed '''         If (ScrAttr(y%) = Normal80) Then
            r% = TextOut(ttyhdc, 0, ty%, ScrImage(y%), 80)
''' Removed to improve speed '''         Else
''' Removed to improve speed '''             tx% = 0
''' Removed to improve speed '''             For x% = 1 To 80
''' Removed to improve speed '''                 If (Mid$(ScrAttr(y%), x%, 1) <> CurAttr) Then
''' Removed to improve speed '''                     Call SetAttr(Mid$(ScrAttr(y%), x%, 1))
''' Removed to improve speed '''                     End If
''' Removed to improve speed '''                 r% = TextOut(tty.hdc, tx%, ty%, Mid$(ScrImage(y%), x%, 1), 1)
''' Removed to improve speed '''                 tx% = tx% + charwidth
''' Removed to improve speed '''                 Next x%
''' Removed to improve speed '''         End If
        ty% = ty% + CharHeight
        ' r% = DoEvents()
    Next y%

''' Removed to improve speed '''     Call SetAttr(oldattr)
    If oldcur <> 0 Then Call disp_cursor
End Sub

Sub SetAttr (ch As String)

''' Removed to improve speed '''    Select Case Val(ch)
''' Removed to improve speed '''            Case 0
''' Removed to improve speed '''                tty.fontbold = 0
''' Removed to improve speed '''                tty.fontunderline = 0
''' Removed to improve speed '''                tty.fontitalic = 0
''' Removed to improve speed '''                tty.forecolor = QBColor(0)
''' Removed to improve speed '''                CurAttr = "0"
''' Removed to improve speed '''            Case 1
''' Removed to improve speed '''                tty.fontbold = -1
''' Removed to improve speed '''                CurAttr = "1"
''' Removed to improve speed '''            Case 5
''' Removed to improve speed '''                tty.fontitalic = -1
''' Removed to improve speed '''                CurAttr = "5"
''' Removed to improve speed '''            Case 4
''' Removed to improve speed '''                tty.fontunderline = -1
''' Removed to improve speed '''                CurAttr = "4"
''' Removed to improve speed '''            Case 7
''' Removed to improve speed '''                tty.forecolor = QBColor(8)
''' Removed to improve speed '''                CurAttr = "7"
''' Removed to improve speed '''    End Select

End Sub

Function isdigit (s$)
    If (Left$(s$, 1) < "0") Then
        isdigit = 0
    ElseIf (Left$(s$, 1) > "9") Then
        isdigit = 0
    Else
        isdigit = 1
    End If
End Function

