VERSION 2.00
Begin Form Client 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "FTP Client"
   ClientHeight    =   4185
   ClientLeft      =   1245
   ClientTop       =   1905
   ClientWidth     =   7095
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4875
   Left            =   1185
   LinkTopic       =   "Form1"
   ScaleHeight     =   4185
   ScaleWidth      =   7095
   Top             =   1275
   Width           =   7215
   Begin Socket Socket2 
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   720
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Peek            =   0   'False
      Protocol        =   0
      RecvLen         =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SendLen         =   0
      TabIndex        =   24
      Timeout         =   0
      Top             =   3600
      Type            =   1
      Urgent          =   0   'False
   End
   Begin Socket Socket1 
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   120
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Peek            =   0   'False
      Protocol        =   0
      RecvLen         =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SendLen         =   0
      TabIndex        =   23
      Timeout         =   0
      Top             =   3600
      Type            =   1
      Urgent          =   0   'False
   End
   Begin CommandButton CopyButton 
      Caption         =   "Copy"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3840
      TabIndex        =   22
      Top             =   3600
      Width           =   1215
   End
   Begin Frame TransferFrame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Transfer"
      Height          =   1695
      Left            =   4440
      TabIndex        =   21
      Top             =   1680
      Width           =   2535
      Begin CheckBox BinaryTransfer 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Binary"
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   1200
         Width           =   855
      End
      Begin OptionButton RemoteTransfer 
         BackColor       =   &H00C0C0C0&
         Caption         =   "To Remote System"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   840
         Width           =   2055
      End
      Begin OptionButton LocalTransfer 
         BackColor       =   &H00C0C0C0&
         Caption         =   "To Local System"
         Height          =   375
         Left            =   240
         TabIndex        =   13
         Top             =   430
         Value           =   -1  'True
         Width           =   1935
      End
   End
   Begin Frame FileFrame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "File"
      Height          =   1695
      Left            =   120
      TabIndex        =   20
      Top             =   1680
      Width           =   4215
      Begin TextBox RemoteFile 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   1200
         TabIndex        =   12
         Top             =   1080
         Width           =   2775
      End
      Begin TextBox LocalFile 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   1200
         TabIndex        =   10
         Top             =   720
         Width           =   2775
      End
      Begin Label RemotePath 
         BackStyle       =   0  'Transparent
         Height          =   300
         Left            =   1200
         TabIndex        =   8
         Top             =   360
         Width           =   2775
      End
      Begin Label Label7 
         BackStyle       =   0  'Transparent
         Caption         =   "Directory:"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   360
         Width           =   855
      End
      Begin Label Label6 
         BackStyle       =   0  'Transparent
         Caption         =   "&Remote:"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   1080
         Width           =   735
      End
      Begin Label Label5 
         BackStyle       =   0  'Transparent
         Caption         =   "&Local:"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   720
         Width           =   615
      End
   End
   Begin CommandButton ActionButton 
      Caption         =   "Connect"
      Height          =   375
      Left            =   2160
      TabIndex        =   17
      Top             =   3600
      Width           =   1215
   End
   Begin Frame UserFrame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "User"
      Height          =   1455
      Left            =   3600
      TabIndex        =   19
      Top             =   120
      Width           =   3375
      Begin TextBox Password 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   1080
         PasswordChar    =   "*"
         TabIndex        =   6
         Top             =   840
         Width           =   1935
      End
      Begin TextBox UserName 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   1080
         TabIndex        =   4
         Top             =   480
         Width           =   1935
      End
      Begin Label Label4 
         BackColor       =   &H00FFFFFF&
         BackStyle       =   0  'Transparent
         Caption         =   "&Password:"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   840
         Width           =   975
      End
      Begin Label Label3 
         BackStyle       =   0  'Transparent
         Caption         =   "&Username:"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   480
         Width           =   975
      End
   End
   Begin Frame RemoteFrame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "System"
      Height          =   1455
      Left            =   120
      TabIndex        =   18
      Top             =   120
      Width           =   3375
      Begin ComboBox Hostname 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   1200
         Sorted          =   -1  'True
         TabIndex        =   0
         Top             =   480
         Width           =   1935
      End
      Begin TextBox IPAddress 
         BackColor       =   &H00C0C0C0&
         Height          =   300
         Left            =   1200
         TabIndex        =   2
         Top             =   840
         Width           =   1575
      End
      Begin Label Label2 
         BackStyle       =   0  'Transparent
         Caption         =   "IP &Address:"
         Height          =   255
         Left            =   120
         TabIndex        =   1
         Top             =   840
         Width           =   1095
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "&Hostname:"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   480
         Width           =   975
      End
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu ExitApp 
         Caption         =   "E&xit"
      End
   End
End

Option Explicit

Sub ActionButton_Click ()
    Dim Address As String

    If Not Socket1.Connected Then
        ActionButton.Enabled = False
        ActionButton.Default = False
        Client.MousePointer = 11
        Address = Trim$(Hostname.Text)
        If Len(Address) = 0 Then Address = Trim$(IPAddress.Text)
        If Not FTPConnect(Address) Then
            ActionButton.Enabled = True
            ActionButton.Default = True
            Client.MousePointer = 0
            MsgBox "Unable to connect to remote host"
            Exit Sub
        End If
        If Not FTPLogin(Trim$(UserName.Text), Trim$(Password.Text)) Then
            Client.MousePointer = 0
            Socket1.Action = SOCKET_CLOSE
            ActionButton.Enabled = True
            ActionButton.Default = True
            Exit Sub
        End If
        Client.MousePointer = 0
        FTPGetDirectory
        ActionButton.Caption = "Disconnect"
        ActionButton.Enabled = True
        CopyButton.Enabled = True
    Else
        Socket1.Action = SOCKET_CLOSE
        ActionButton.Caption = "Connect"
        ActionButton.Default = True
        CopyButton.Enabled = False
        Hostname.SetFocus
    End If
End Sub

Sub CopyButton_Click ()
    Dim SrcFile As String, DstFile As String
    
    CopyButton.Enabled = False
    Client.MousePointer = 11

    If LocalTransfer.Value Then
        SrcFile = Trim$(RemoteFile.Text)
        DstFile = Trim$(LocalFile.Text)
        If Not FTPGetFile(SrcFile, DstFile) Then
            Client.MousePointer = 0
            MsgBox "Could not copy remote file"
        End If
    Else
        SrcFile = Trim$(LocalFile.Text)
        DstFile = Trim$(RemoteFile.Text)
        If Not FTPPutFile(SrcFile, DstFile) Then
            Client.MousePointer = 0
            MsgBox "Could not copy local file"
        End If
    End If
    
    CopyButton.Enabled = True
    Client.MousePointer = 0
End Sub

Sub ExitApp_Click ()
    Unload Client
End Sub

Sub Form_Load ()
    Dim Host As String

    '
    ' Initialize hostname combo box
    '
    On Error Resume Next
    Socket1.HostFile = "HOSTS"
    If Err = 0 Then
        Host$ = Socket1.GetFirstHost
        While Host$ <> ""
            Hostname.AddItem Host$
            Host$ = Socket1.GetNextHost
        Wend
    End If
    Socket1.HostFile = ""

    '
    ' Initialize the other controls
    '
    ActionButton.Caption = "Connect"
    ActionButton.Default = True
    ActionButton.Enabled = False
End Sub

Sub Form_Unload (Cancel As Integer)
    If Socket1.Connected Then Socket1.Action = SOCKET_CLOSE
    If Socket2.Listening Or Socket2.Connected Then Socket2.Action = SOCKET_CLOSE
    End
End Sub

Sub Hostname_Change ()
    If (Len(Hostname.Text) > 0 Or Len(IPAddress.Text) > 0) And Len(UserName.Text) > 0 Then
        ActionButton.Enabled = True
    Else
        ActionButton.Enabled = False
    End If
End Sub

Sub Hostname_GotFocus ()
    Hostname.SelStart = 0
    Hostname.SelLength = Len(Hostname.Text)
End Sub

Sub Hostname_KeyPress (KeyAscii As Integer)
    IPAddress.Text = ""
End Sub

Sub IPAddress_Change ()
    If Len(Hostname.Text) > 0 Or Len(IPAddress.Text) > 0 Then
        ActionButton.Enabled = True
    Else
        ActionButton.Enabled = False
    End If
End Sub

Sub IPAddress_GotFocus ()
    IPAddress.SelStart = 0
    IPAddress.SelLength = Len(IPAddress.Text)
End Sub

Sub IPAddress_KeyPress (KeyAscii As Integer)
    Hostname.Text = ""
End Sub

Sub Socket1_Close ()
    Socket1.Action = SOCKET_CLOSE
    ActionButton.Caption = "Connect"
    ActionButton.Default = True
    CopyButton.Enabled = False
    MsgBox "Remote server closed control connection"
End Sub

Sub UserName_Change ()
    If Len(UserName.Text) > 0 And (Len(Hostname.Text) > 0 Or Len(IPAddress.Text) > 0) Then
        ActionButton.Enabled = True
    Else
        ActionButton.Enabled = False
    End If

End Sub

