unit Xyeditor;

{see XYGraph for info about this define}
{$DEFINE STATISTICS}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, xygraph, xydata, StdCtrls, {$IFDEF WIN32} ComCtrls, {$ENDIF}
  ExtCtrls, Spin, Buttons, TabNotBk, Tabs;

type
  TxyEdit = class(TForm)
    Panel1: TPanel;
    TabbedNotebook1: TTabbedNotebook;
    BitBtn1: TBitBtn;
    Panel6: TPanel;
    Button8: TButton;
    Panel7: TPanel;
    Panel5: TPanel;
    Label3: TLabel;
    Label2: TLabel;
    Label24: TLabel;
    Edit1: TEdit;
    Button3: TButton;
    SpinEdit1: TSpinEdit;
    Label14: TLabel;
    Label25: TLabel;
    Button7: TButton;
    Label26: TLabel;
    Panel4: TPanel;
    Panel8: TPanel;
    Label20: TLabel;
    Label10: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Button9: TButton;
    SpinEdit5: TSpinEdit;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Button2: TButton;
    SpinEdit6: TSpinEdit;
    SpinEdit7: TSpinEdit;
    Button10: TButton;
    gridstyle: TComboBox;
    Panel9: TPanel;
    Label27: TLabel;
    Button11: TButton;
    CheckBox3: TCheckBox;
    Label1: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label12: TLabel;
    Label28: TLabel;
    SpinEdit8: TSpinEdit;
    SpinEdit9: TSpinEdit;
    SpinEdit10: TSpinEdit;
    SpinEdit11: TSpinEdit;
    Panel3: TPanel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    SpinEdit4: TSpinEdit;
    CheckBox4: TCheckBox;
    Label29: TLabel;
    Button1: TButton;
    Label4: TLabel;
    Label5: TLabel;
    ComboBox1: TComboBox;
    Panel14: TPanel;
    Panel10: TPanel;
    Panel13: TPanel;
    Label30: TLabel;
    ComboBox2: TComboBox;
    Edit2: TEdit;
    CheckBox8: TCheckBox;
    Panel15: TPanel;
    Panel11: TPanel;
    Panel12: TPanel;
    Label31: TLabel;
    CheckBox9: TCheckBox;
    Edit3: TEdit;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    CheckBox7: TCheckBox;
    Label6: TLabel;
    SpinEdit12: TSpinEdit;
    Label7: TLabel;
    SpinEdit13: TSpinEdit;
    CheckBox10: TCheckBox;
    Label36: TLabel;
    Label37: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    CheckBox11: TCheckBox;
    Label38: TLabel;
    Edit6: TEdit;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    Label40: TLabel;
    ComboBox3: TComboBox;
    Label41: TLabel;
    Label42: TLabel;
    Edit7: TEdit;
    ComboBox4: TComboBox;
    fd: TFontDialog;
    cd: TColorDialog;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Panel16: TPanel;
    Label39: TLabel;
    ComboBox5: TComboBox;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Bevel6: TBevel;
    Panel19: TPanel;
    Bevel5: TBevel;
    Label72: TLabel;
    Label73: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    Label76: TLabel;
    Label78: TLabel;
    ComboBox12: TComboBox;
    ComboBox13: TComboBox;
    Button14: TButton;
    Edit12: TEdit;
    Edit13: TEdit;
    Panel18: TPanel;
    Label61: TLabel;
    Label63: TLabel;
    Label65: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    Label68: TLabel;
    Label69: TLabel;
    Label70: TLabel;
    CheckBox1: TCheckBox;
    Button12: TButton;
    RadioButton6: TRadioButton;
    RadioButton7: TRadioButton;
    ComboBox10: TComboBox;
    Button13: TButton;
    ComboBox11: TComboBox;
    SpinEdit15: TSpinEdit;
    Edit10: TEdit;
    Bevel7: TBevel;
    CheckBox2: TCheckBox;
    Label77: TLabel;
    CheckBox14: TCheckBox;
    Label71: TLabel;
    Edit11: TEdit;
    Label43: TLabel;
    ComboBox6: TComboBox;
    Label44: TLabel;
    Label45: TLabel;
    Edit8: TEdit;
    Edit9: TEdit;
    Button4: TButton;
    Label46: TLabel;
    Label47: TLabel;
    ComboBox7: TComboBox;
    procedure Edit1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure closebutClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure SpinEdit8Change(Sender: TObject);
    procedure SpinEdit9Change(Sender: TObject);
    procedure SpinEdit10Change(Sender: TObject);
    procedure SpinEdit11Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure SpinEdit7Change(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure gridstyleChange(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure CheckBox9Click(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure SpinEdit12Change(Sender: TObject);
    procedure SpinEdit13Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure CheckBox10Click(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure CheckBox11Click(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure Edit7Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure ComboBox5Change(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Edit10Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure ComboBox10Change(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure ComboBox11Change(Sender: TObject);
    procedure SpinEdit15Change(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure CheckBox14Click(Sender: TObject);
    procedure Edit11Change(Sender: TObject);
    procedure ComboBox12Change(Sender: TObject);
    procedure ComboBox13Change(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Edit12Change(Sender: TObject);
    procedure Edit13Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBox6Change(Sender: TObject);
    procedure Edit8Change(Sender: TObject);
    procedure Edit9Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ComboBox7Change(Sender: TObject);
  private
    { Private declarations }
    editing:boolean;
    currentAxis:TAxis;
    CurrentSeries:TSeries;
    hideshape:TPanel;
    procedure updateaxespage;
    procedure setupseriescombo;
    procedure enableseriespage(status:boolean);
    procedure updateseriespage;
  public
    { Public declarations }
    fgraph: txygraph;
    designtime:boolean;
  end;

var
  xyEdit: TxyEdit;

implementation

{$R *.DFM}

{----------------------------------------------------------------------------
    #1a. set up
 ----------------------------------------------------------------------------}

 procedure TxyEdit.FormShow(Sender: TObject);
begin
  checkbox2.checked := FGraph.allowduplicates;

  {general page}
  edit1.text := FGraph.appearance.graphtitle;
  spinedit1.value := FGraph.dimensions.graphtitleoffset;
  spinedit8.value := FGraph.dimensions.topmargin;
  spinedit9.value := FGraph.dimensions.bottommargin;
  spinedit10.value := FGraph.dimensions.leftmargin;
  spinedit11.value := FGraph.dimensions.rightmargin;
  spinedit5.value := FGraph.dimensions.Ticklength;
  checkbox3.checked := FGraph.appearance.plotoffgraph;
  Checkbox5.checked := fgraph.appearance.showgraphlabels;
  Checkbox6.checked := fgraph.appearance.showticks;
  SpinEdit6.value := fgraph.appearance.MaxSteps;
  SpinEdit7.value := fgraph.appearance.MinSteps;
  case fgraph.appearance.gridstyle of
    psSolid:gridstyle.itemindex := 0;
    psDot:gridstyle.itemindex := 1;
    psDash:gridstyle.itemindex := 2;
    psDashDot:gridstyle.itemindex :=3 ;
    psDashDotDot:gridstyle.itemindex := 4;
  end;
  Spinedit2.value := FGraph.Dimensions.printscalepct;
  spinedit3.value := fgraph.dimensions.PrintXOffsetPct;
  spinedit4.value := fgraph.dimensions.PrintYOffsetPct;
  checkbox4.checked := FGraph.appearance.PrintBkgndcolor;

{axes page}
  case combobox1.itemindex of
   0:currentaxis := FGraph.XAxis;
   1:currentaxis := FGraph.YAxis;
   2:currentaxis := FGraph.YAxis_Second;
  end;
  updateaxespage;

{series page}
  setupseriescombo;
  if combobox5.enabled then
    begin
    combobox5.itemindex := 0;
    combobox5change(self);
    end
  else
    currentseries := nil;
  updateseriespage;

  editing := true;
end;

procedure TxyEdit.updateaxespage;
var oedit:boolean;
begin
  oedit := editing;
  editing := false;
  checkbox7.checked := currentaxis.showaxis;
  checkbox9.checked := currentaxis.gridlines;
  edit3.text := currentaxis.title;
  if combobox1.itemindex < 1 then
    begin
    Spinedit12.value := FGraph.dimensions.XAxisTitleOffset;
    Spinedit13.value := FGraph.dimensions.XAxisLabelOffset
    end
  else
    begin
    Spinedit12.value := FGraph.dimensions.YAxisTitleOffset;
    Spinedit13.value := FGraph.dimensions.YAxisLabelOffset;
    end;
  case currentaxis.offsettype of
    ao_minimum: combobox2.itemindex := 0;
    ao_Maximum: combobox2.itemindex := 1;
    ao_percentage: combobox2.itemindex := 2;
    ao_absolute: combobox2.itemindex := 3;
  end;
  if combobox2.itemindex > 1 then
    edit2.enabled := true
  else
    edit2.enabled := false;
  edit2.text := floattostrF(currentaxis.offset,ffFixed, 2,2);
  checkbox8.checked := currentaxis.Reversed;
  checkbox10.checked := currentaxis.autosizing;
  edit4.enabled := not checkbox10.checked;
  edit4.text := floattostrF(currentaxis.min,ffFixed, 2,2);
  edit5.enabled := not checkbox10.checked;
  edit5.text := floattostrF(currentaxis.max,ffFixed, 2,2);
  checkbox11.checked := currentaxis.autostepping;
  edit6.enabled := not checkbox11.checked;
  edit6.text := floattostrF(currentaxis.stepsize,ffFixed, 2,2);
  if currentaxis.logscale then
    begin
    radiobutton2.checked := true;
    RadioButton1Click(radiobutton2);
    end
  else if currentaxis.showastime then
    begin
    radiobutton3.checked := true;
    RadioButton1Click(radiobutton3);
    end
  else
    begin
    radiobutton1.checked := true;
    RadioButton1Click(radiobutton1);
    end;
  case currentaxis.LogCycleDivisions of
     0:combobox3.itemindex := 0;
     1:combobox3.itemindex := 1;
     2:combobox3.itemindex := 2;
     5:combobox3.itemindex := 3;
     7:combobox3.itemindex := 4;
     9:combobox3.itemindex := 5;
    end;
  edit7.text := currentaxis.DateTimeFormat;
  case currentaxis.DateTickType of
    dt_minute:Combobox4.itemindex := 0;
    dt_5minute:Combobox4.itemindex := 1;
    dt_halfhourly:Combobox4.itemindex := 2;
    dt_hourly:Combobox4.itemindex := 3;
    dt_daily:Combobox4.itemindex := 4;
    dt_weekly:Combobox4.itemindex := 5;
    dt_monthly:Combobox4.itemindex := 6;
    dt_2monthly:Combobox4.itemindex := 7;
    dt_quarterly:Combobox4.itemindex := 8;
    dt_annually:Combobox4.itemindex := 9;
    dt_decade:Combobox4.itemindex := 10;
    dt_century:Combobox4.itemindex := 11;
    dt_custom:Combobox4.itemindex := 12;
  end;
  editing := oedit;
end;

procedure TxyEdit.updateseriespage;
var oedit:boolean;
begin
  oedit := editing;
  editing := false;
  if currentseries = nil then
    enableseriespage(false)
  else
   with currentseries do
    begin
    enableseriespage(true);
    edit10.text := seriesname;
    checkbox1.checked := active;
    radiobutton6.checked := not (WhichYAxis = FGraph.YAxis_second);
    radiobutton7.checked := (WhichYAxis = FGraph.YAxis_second);
    if not drawline then combobox10.itemindex := 0
     else
      case linestyle of
        psSolid:combobox10.itemindex := 1;
        psDash:combobox10.itemindex := 2;
        psDot:combobox10.itemindex := 3;
        psDashDot:combobox10.itemindex := 4;
        psDashDotDot:combobox10.itemindex := 5;
      end;
    button12.enabled := (combobox10.itemindex > 0);
    if not drawpoints then combobox11.itemindex := 0
     else
      case pointshape of
        ps_Square:combobox11.itemindex := 1;
        ps_Circle:combobox11.itemindex := 2;
        ps_Diamond:combobox11.itemindex := 3;
        ps_Cross:combobox11.itemindex := 4;
        ps_Wide:combobox11.itemindex := 5;
      end;
    button13.enabled := (combobox10.itemindex > 0);
    spinedit15.enabled := (combobox10.itemindex > 0);
    spinedit15.value := pointsize;
    checkbox14.checked := autozero;
    edit11.text := floattostrF(Internalzero,FFFixed,2,4);
    case BoundsType of
      bt_None: combobox6.itemindex := 0;
      bt_AsSet:combobox6.itemindex := 1;
      bt_1SD:  combobox6.itemindex := 2;
      bt_2SD:  combobox6.itemindex := 3;
      bt_3SD:  combobox6.itemindex := 4;
      bt_allSD:combobox6.itemindex := 5;
    end;
    edit8.text := floattostrF(LowerBound,FFFixed,2,4);
    edit9.text := floattostrF(UpperBound,FFFixed,2,4);
    case BoundsLineStyle of
      psSolid:combobox7.itemindex := 0;
      psDash:combobox7.itemindex := 1;
      psDot:combobox7.itemindex := 2;
      psDashDot:combobox7.itemindex := 3;
      psDashDotDot:combobox7.itemindex := 4;
    end;

    {$IFDEF STATISTICS}
    case regtype of
      rg_None:combobox12.itemindex := 0;
      rg_Linear:combobox12.itemindex := 1;
      rg_passingBablok:combobox12.itemindex := 2;
      rg_quadratic:combobox12.itemindex := 3;
      rg_Spline:combobox12.itemindex := 4;
      rg_dwls:combobox12.itemindex := 5;
      rg_RunningAverage:combobox12.itemindex := 6;
    end;
    edit12.text := inttostr(regcontrol1);
    edit13.text := floattostrF(regcontrol2,FFFixed,2,4);
    case RegressionLineStyle of
      psSolid:combobox13.itemindex := 0;
      psDash:combobox13.itemindex := 1;
      psDot:combobox13.itemindex := 2;
      psDashDot:combobox13.itemindex := 3;
      psDashDotDot:combobox13.itemindex := 4;
    end;
    {$ENDIF}
    end;
  editing := oedit;
end;

procedure TxyEdit.enableseriespage(status:boolean);
begin
 edit10.text := '';
 edit10.enabled := status;
 checkbox1.enabled := status;
 radiobutton6.enabled := status;
 radiobutton7.enabled := status;
 combobox10.enabled := status;
 button12.enabled := false;
 combobox11.enabled := status;
 spinedit15.enabled := status;
 button13.enabled := false;
 checkbox14.enabled := status;
 edit11.text := '';
 edit11.enabled := status;
 edit8.text := '';
 edit8.enabled := status;
 edit9.text := '';
 edit9.enabled := status;
 button4.enabled := status;
 combobox6.enabled := status;
 combobox7.enabled := status;

{$IFDEF STATISTICS}
 combobox12.enabled := status;
 edit12.text := '';
 edit12.enabled := status;
 edit13.text := '';
 edit13.enabled := status;
 combobox13.enabled := status;
 button14.enabled := status;
{$ELSE}
 combobox12.enabled := false;
 edit12.enabled := false;
 edit13.enabled := false;
 combobox13.enabled := false;
 button14.enabled := false;
{$ENDIF}
end;

procedure TxyEdit.setupseriescombo;
var p:TSeries;
begin
 combobox5.items.clear;
 p := FGraph.serieshandle;
 if p = nil then
    begin
    combobox5.enabled := false;
    exit;
    end
 else combobox5.enabled := true;
 while p <> nil do
   begin
   combobox5.items.addobject(p.SeriesName,tobject(p.SeriesIndex));
   p := p.nextSeries;
   end;
end;

procedure TxyEdit.closebutClick(Sender: TObject);
begin
  close;
end;

procedure TxyEdit.FormCreate(Sender: TObject);
begin
 editing := false;
 combobox1.itemindex := 0;
 {$IFNDEF STATISTICS}
 hideshape := TPanel.create(self);
 hideshape.parent := panel19;
 hideshape.top := 73;
 hideshape.left := 6;
 hideshape.width := panel19.width - (6 + 3);
 hideshape.height := panel19.height - (73 + 3);
 hideshape.bevelOuter := bvnone;
 {$ENDIF}
end;

procedure TxyEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
hideshape.free;
end;


{----------------------------------------------------------------------------
    #1a. update graph
 ----------------------------------------------------------------------------}

procedure TxyEdit.Edit1Change(Sender: TObject);
begin
  if editing then fgraph.appearance.graphtitle := edit1.text;
end;

procedure TxyEdit.SpinEdit1Change(Sender: TObject);
begin
 if editing then FGraph.dimensions.graphtitleoffset := spinedit1.value;
end;

procedure TxyEdit.Button3Click(Sender: TObject);
begin
  fd.font := FGraph.font;
  if fd.execute then FGraph.Font := fd.font;
end;

procedure TxyEdit.Button7Click(Sender: TObject);
begin
  cd.color := FGraph.appearance.BackgroundColor;
  if cd.execute then
    FGraph.appearance.backgroundcolor := cd.color;
end;

procedure TxyEdit.SpinEdit8Change(Sender: TObject);
begin
 if editing then FGraph.dimensions.topmargin := spinedit8.value;
end;

procedure TxyEdit.SpinEdit9Change(Sender: TObject);
begin
 if editing then FGraph.dimensions.bottommargin := spinedit9.value;
end;

procedure TxyEdit.SpinEdit10Change(Sender: TObject);
begin
 if editing then FGraph.dimensions.leftmargin := spinedit10.value;
end;

procedure TxyEdit.SpinEdit11Change(Sender: TObject);
begin
 if editing then FGraph.dimensions.rightmargin := spinedit11.value;
end;

procedure TxyEdit.CheckBox3Click(Sender: TObject);
begin
  if editing then FGraph.appearance.plotoffgraph := checkbox3.checked;
end;

procedure TxyEdit.Button11Click(Sender: TObject);
begin
  cd.color := FGraph.color;
  if cd.execute then FGraph.color := cd.color;
end;

procedure TxyEdit.Button9Click(Sender: TObject);
begin
  cd.color := FGraph.appearance.axesColor;
  if cd.execute then
    FGraph.appearance.axescolor := cd.color;
end;

procedure TxyEdit.Button1Click(Sender: TObject);
begin
  fd.font := FGraph.appearance.Titlefont;
  if fd.execute then FGraph.appearance.Titlefont := fd.font;
end;

procedure TxyEdit.Button2Click(Sender: TObject);
begin
  fd.font := FGraph.appearance.labelfont;
  if fd.execute then FGraph.appearance.labelfont := fd.font;
end;

procedure TxyEdit.CheckBox5Click(Sender: TObject);
begin
 if editing then fgraph.appearance.showgraphlabels := Checkbox5.checked;
end;

procedure TxyEdit.CheckBox6Click(Sender: TObject);
begin
 if editing then fgraph.appearance.showticks := Checkbox6.checked;
end;

procedure TxyEdit.SpinEdit5Change(Sender: TObject);
begin
  if editing then fgraph.dimensions.Ticklength := SpinEdit5.value;
end;

procedure TxyEdit.SpinEdit6Change(Sender: TObject);
begin
  if editing then fgraph.appearance.MaxSteps := SpinEdit6.value;
end;

procedure TxyEdit.SpinEdit7Change(Sender: TObject);
begin
  if editing then fgraph.appearance.MinSteps := SpinEdit7.value;
end;

procedure TxyEdit.Button10Click(Sender: TObject);
begin
 cd.color := fgraph.appearance.gridcolor;
 if cd.execute then fgraph.appearance.gridcolor := cd.color;
end;

procedure TxyEdit.gridstyleChange(Sender: TObject);
begin
  if not editing then exit;
  case gridstyle.itemindex of
    0:fgraph.appearance.gridstyle := psSolid;
    1:fgraph.appearance.gridstyle := psDot;
    2:fgraph.appearance.gridstyle := psDash;
    3:fgraph.appearance.gridstyle := psDashDot;
    4:fgraph.appearance.gridstyle := psDashDotDot;
  end;
end;

procedure TxyEdit.SpinEdit2Change(Sender: TObject);
begin
  if editing then FGraph.Dimensions.printscalepct := Spinedit2.value;
end;

procedure TxyEdit.SpinEdit3Change(Sender: TObject);
begin
  if editing then fgraph.dimensions.PrintXOffsetPct := spinedit3.value;
end;

procedure TxyEdit.SpinEdit4Change(Sender: TObject);
begin
  if editing then fgraph.dimensions.PrintYOffsetPct := spinedit4.value;
end;

procedure TxyEdit.CheckBox4Click(Sender: TObject);
begin
  if editing then FGraph.appearance.PrintBkgndcolor := checkbox4.checked;
end;

procedure TxyEdit.ComboBox1Change(Sender: TObject);
begin
  if not editing then exit;
  case combobox1.itemindex of
   0:currentaxis := FGraph.XAxis;
   1:currentaxis := FGraph.YAxis;
   2:currentaxis := FGraph.YAxis_second;
  end;
  updateaxespage;
end;

procedure TxyEdit.CheckBox7Click(Sender: TObject);
begin
  if editing then currentaxis.showaxis := checkbox7.checked;
end;

procedure TxyEdit.CheckBox9Click(Sender: TObject);
begin
  if editing then currentaxis.gridlines := checkbox9.checked;
end;

procedure TxyEdit.Edit3Change(Sender: TObject);
begin
  if editing then currentaxis.title := edit3.text;
end;

procedure TxyEdit.SpinEdit12Change(Sender: TObject);
begin
  if not editing then exit;
  if combobox1.itemindex < 1 then
    FGraph.dimensions.XAxisTitleOffset := Spinedit12.value
  else
    FGraph.dimensions.YAxisTitleOffset := Spinedit12.value
end;

procedure TxyEdit.SpinEdit13Change(Sender: TObject);
begin
  if not editing then exit;
  if combobox1.itemindex < 1 then
    FGraph.dimensions.XAxisLabelOffset := Spinedit13.value
  else
    FGraph.dimensions.YAxisLabelOffset := Spinedit13.value
end;

procedure TxyEdit.ComboBox2Change(Sender: TObject);
begin
  if combobox2.itemindex > 1 then
    edit2.enabled := true
  else
    edit2.enabled := false;
  if not editing then exit;
  case combobox2.itemindex of
    0:currentaxis.offsettype := ao_minimum;
    1:currentaxis.offsettype := ao_Maximum;
    2:currentaxis.offsettype := ao_percentage;
    3:currentaxis.offsettype := ao_absolute;
  end;
end;

procedure TxyEdit.CheckBox8Click(Sender: TObject);
begin
  if editing then currentaxis.Reversed := checkbox8.checked;
end;

procedure TxyEdit.Edit2Change(Sender: TObject);
begin
  if editing then currentaxis.offset := strtofloat(edit2.text);
end;

procedure TxyEdit.CheckBox10Click(Sender: TObject);
begin
  edit4.enabled := not checkbox10.checked;
  edit5.enabled := not checkbox10.checked;
  if editing then
    begin
    currentaxis.autosizing := checkbox10.checked;
    edit4.text := floattostrF(currentaxis.min,ffFixed, 2,2);
    edit5.text := floattostrF(currentaxis.max,ffFixed, 2,2);
    if checkbox11.checked then
       edit6.text := floattostrF(currentaxis.stepsize,ffFixed, 2,2);
    end;
end;

procedure TxyEdit.Edit4Change(Sender: TObject);
begin
  if editing then
    begin
    currentaxis.min := strtofloat(edit4.text);
    if checkbox11.checked then
       edit6.text := floattostrF(currentaxis.stepsize,ffFixed, 2,2);
    end;
end;

procedure TxyEdit.Edit5Change(Sender: TObject);
begin
  if editing then
    begin
    currentaxis.max := strtofloat(edit5.text);
    if checkbox11.checked then
       edit6.text := floattostrF(currentaxis.stepsize,ffFixed, 2,2);
    end;
end;

procedure TxyEdit.CheckBox11Click(Sender: TObject);
begin
  edit6.enabled := not checkbox11.checked;
  if editing then
    begin
    currentaxis.autostepping := checkbox11.checked;
    edit6.text := floattostrF(currentaxis.stepsize,ffFixed, 2,2);
    end;
end;

procedure TxyEdit.Edit6Change(Sender: TObject);
begin
  if editing then
    currentaxis.stepsize := strtofloat(edit6.text);
end;

procedure TxyEdit.RadioButton1Click(Sender: TObject);
begin
  case TComponent(sender).tag of
    0:begin
      combobox3.enabled := false;
      combobox4.enabled := false;
      edit7.enabled := false;
      end;
    1:begin
      combobox3.enabled := true;
      combobox4.enabled := false;
      edit7.enabled := false;
      end;
    2:begin
      combobox3.enabled := false;
      combobox4.enabled := true;
      edit7.enabled := true;
      end;
  end;
  if not editing then exit;
  case TComponent(sender).tag of
    0:begin
      currentaxis.logscale := false;
      currentaxis.ShowAsTime := false;
      end;
    1:begin
      currentaxis.logscale := true;
      currentaxis.ShowAsTime := false;
      end;
    2:begin
      currentaxis.logscale := false;
      currentaxis.ShowAsTime := true;
      end;
  end;
end;

procedure TxyEdit.ComboBox3Change(Sender: TObject);
begin
  if editing then
    case combobox3.itemindex of
     0:currentaxis.LogCycleDivisions := 0;
     1:currentaxis.LogCycleDivisions := 1;
     2:currentaxis.LogCycleDivisions := 2;
     3:currentaxis.LogCycleDivisions := 5;
     4:currentaxis.LogCycleDivisions := 7;
     5:currentaxis.LogCycleDivisions := 9;
    end;
end;

procedure TxyEdit.Edit7Change(Sender: TObject);
begin
  if editing then currentaxis.DateTimeFormat := edit7.text;
end;

procedure TxyEdit.ComboBox4Change(Sender: TObject);
begin
  if not editing then exit;
  case Combobox4.itemindex of
    00:currentaxis.DateTickType := dt_minute;
    01:currentaxis.DateTickType := dt_5minute;
    02:currentaxis.DateTickType := dt_halfhourly;
    03:currentaxis.DateTickType := dt_hourly;
    04:currentaxis.DateTickType := dt_daily;
    05:currentaxis.DateTickType := dt_weekly;
    06:currentaxis.DateTickType := dt_monthly;
    07:currentaxis.DateTickType := dt_2monthly;
    08:currentaxis.DateTickType := dt_quarterly;
    09:currentaxis.DateTickType := dt_annually;
    10:currentaxis.DateTickType := dt_decade;
    11:currentaxis.DateTickType := dt_century;
    12:currentaxis.DateTickType := dt_custom;
  end;
end;

procedure TxyEdit.ComboBox5Change(Sender: TObject);
begin
  if combobox5.itemindex = -1 then
    currentseries := nil
  else
    currentseries := FGraph[longint(combobox5.items.objects[combobox5.itemindex])];
  updateseriespage;
end;

procedure TxyEdit.BitBtn3Click(Sender: TObject);
var p:Tseries;
    i,j:integer;
begin
  if not designtime then
    begin
    i := combobox5.itemindex + 1;
    p := FGraph[FGraph.lastseriesindex + 1];
    setupseriescombo;
    combobox5.itemindex := i;
    combobox5change(self);
    end
  else
    begin
    messagedlg('Series created at design time are not included after compilation. Some random data will be created',
                 mtinformation,[mbok],0);
    i := combobox5.itemindex + 1;
    p := FGraph[FGraph.lastseriesindex + 1];
    for j := 1 to 10 do
      p[j] := j+2*random;
    setupseriescombo;
    combobox5.itemindex := i;
    combobox5change(self);
    end
end;

procedure TxyEdit.BitBtn2Click(Sender: TObject);
var i:integer;
begin
  i := combobox5.itemindex - 1;
  currentseries.free;
  setupseriescombo;
  combobox5.itemindex := i;
  combobox5change(self);
end;

procedure TxyEdit.Edit10Change(Sender: TObject);
begin
  if editing then
    currentseries.SeriesName := Edit10.text;
end;

procedure TxyEdit.CheckBox1Click(Sender: TObject);
begin
  if editing then currentSeries.active := checkbox1.checked;
end;

procedure TxyEdit.RadioButton7Click(Sender: TObject);
begin
  if editing then
    if TComponent(sender).tag = 2 then
      currentseries.WhichYAxis := FGraph.YAxis_second
    else
      currentseries.WhichYAxis := FGraph.YAxis;
end;

procedure TxyEdit.ComboBox10Change(Sender: TObject);
begin
  button12.enabled := (combobox10.itemindex > 0);
  if not editing then exit;
  with currentseries do
    begin
    holdupdates := true;
    drawline := true;
    case combobox10.itemindex of
      0:drawline := false;
      1:linestyle := psSolid;
      2:linestyle := psDash;
      3:linestyle := psDot;
      4:linestyle := psDashDot;
      5:linestyle := psDashDotDot;
    end;
    holdupdates := false;
    end;
end;

procedure TxyEdit.Button12Click(Sender: TObject);
begin
  cd.color := currentseries.linecolor;
  if cd.execute then currentseries.linecolor := cd.color;
end;

procedure TxyEdit.ComboBox11Change(Sender: TObject);
begin
  button13.enabled := (combobox10.itemindex > 0);
  spinedit15.enabled := (combobox10.itemindex > 0);
  if not editing then exit;
  with currentseries do
    begin
    holdupdates := true;
    drawpoints := true;
    case combobox11.itemindex of
      0:drawpoints := false;
      1:pointshape := ps_Square;
      2:pointshape := ps_Circle;
      3:pointshape := ps_Diamond;
      4:pointshape := ps_Cross;
      5:pointshape := ps_Wide;
    end;
    holdupdates := false;
    end;
end;

procedure TxyEdit.SpinEdit15Change(Sender: TObject);
begin
  if editing then currentseries.pointsize := spinedit15.value;
end;

procedure TxyEdit.Button13Click(Sender: TObject);
begin
  cd.color := currentseries.pointcolor;
  if cd.execute then currentseries.pointcolor := cd.color;
end;

procedure TxyEdit.CheckBox14Click(Sender: TObject);
begin
  edit11.enabled := not checkbox14.checked;
  if editing then
    begin
    currentseries.autozero := checkbox14.checked;
    editing := false;
    edit11.text := floattostrF(currentseries.internalzero,FFFixed,2,4);
    editing := true;
    end;
end;

procedure TxyEdit.Edit11Change(Sender: TObject);
begin
  if editing then currentseries.InternalZero := strtofloat(edit11.text);
end;

procedure TxyEdit.ComboBox12Change(Sender: TObject);
begin
 {$IFDEF STATISTICS}
  combobox13.enabled := combobox12.itemindex > 0;
  button14.enabled := combobox12.itemindex > 0;
  case combobox12.itemindex of
   0..3:begin
     label73.caption := 'not used';
     label74.caption := 'not used';
     end;
   4:begin
     label73.caption := 'Number of Points:';
     label74.caption := 'Gradient at ends:';
     end;
   5:begin
     label73.caption := 'Number of Points:';
     label74.caption := 'Fitting Tension:';
     end;
   6:begin
     label73.caption := 'not used';
     label74.caption := 'alpha';
     end;
  end;
  if not editing then exit;
  with currentseries do
    case combobox12.itemindex of
     0:RegType := rg_none;
     1:RegType := rg_Linear;
     2:RegType := rg_passingBablok;
     3:RegType := rg_quadratic;
     4:RegType := rg_Spline;
     5:RegType := rg_dwls;
     6:RegType := rg_RunningAverage;
    end;
 {$ENDIF}
end;

procedure TxyEdit.ComboBox13Change(Sender: TObject);
begin
{$IFDEF STATISTICS}
 if not editing then exit;
  with currentseries do
    case combobox13.itemindex of
      0:RegressionLineStyle := psSolid;
      1:RegressionLineStyle := psDash;
      2:RegressionLineStyle := psDot;
      3:RegressionLineStyle := psDashDot;
      4:RegressionLineStyle := psDashDotDot;
    end;
{$ENDIF}
end;

procedure TxyEdit.Button14Click(Sender: TObject);
begin
  {$IFDEF STATISTICS}
  cd.color := currentseries.RegressionLineColor;
  if cd.execute then currentseries.RegressionLineColor := cd.color;
  {$ENDIF}
end;

procedure TxyEdit.Edit12Change(Sender: TObject);
begin
{$IFDEF STATISTICS}
 if editing then currentseries.regcontrol1 := strtoint(edit12.text);
{$ENDIF}
end;

procedure TxyEdit.Edit13Change(Sender: TObject);
begin
{$IFDEF STATISTICS}
 if editing then currentseries.regcontrol2 := strtofloat(edit13.text);
{$ENDIF}
end;

procedure TxyEdit.CheckBox2Click(Sender: TObject);
begin
  if not editing then exit;
  if not checkbox2.checked then
    begin
    if messagedlg('This will delete any points with duplicate X Values. Are you sure?',
                mtConfirmation, [mbok,mbcancel],0) <> mrOK then
      begin
      checkbox2.checked := false;
      exit;
      end;
    end;
  FGraph.allowduplicates := checkbox2.checked;
end;

procedure TxyEdit.ComboBox6Change(Sender: TObject);
begin
  with combobox6 do
    begin
    button4.enabled := (itemindex <> 0);
    combobox7.enabled := (itemindex <> 0);
    edit8.enabled := (itemindex = 1);
    edit9.enabled := (itemindex = 1);
    end;
  if not editing then exit;
  case Combobox6.itemindex of
    0:currentseries.boundstype := bt_None;
    1:currentseries.boundstype := bt_AsSet;
    2:currentseries.boundstype := bt_1SD;
    3:currentseries.boundstype := bt_2SD;
    4:currentseries.boundstype := bt_3SD;
    5:currentseries.boundstype := bt_allSD;
  end;
end;

procedure TxyEdit.Edit8Change(Sender: TObject);
begin
  if editing then currentseries.lowerbound := strtofloat(edit8.text);
end;

procedure TxyEdit.Edit9Change(Sender: TObject);
begin
  if editing then currentseries.upperbound := strtofloat(edit9.text);

end;

procedure TxyEdit.Button4Click(Sender: TObject);
begin
  cd.color := currentseries.boundscolor;
  if cd.execute then currentseries.boundscolor := cd.color;
end;

procedure TxyEdit.ComboBox7Change(Sender: TObject);
begin
 if not editing then exit;
  with currentseries do
    case combobox7.itemindex of
      0:BoundsLineStyle := psSolid;
      1:BoundsLineStyle := psDash;
      2:BoundsLineStyle := psDot;
      3:BoundsLineStyle := psDashDot;
      4:BoundsLineStyle := psDashDotDot;
    end;
end;

end.

