unit U_pprot;

interface

uses
   D_Global;
   
function DetectBallCollision( pBackground, pSprite: Pointer ): Byte;

implementation


function DetectBallCollision( pBackground, pSprite: Pointer ): Byte;
begin
asm
      push esi
      push edi
      push ebx

      mov esi, pSprite
      mov edi, pBackground

      mov dh, 1            // dh 1 or 2 half
      mov bl, 1            // left zone bit
      mov bh, 2            // right zone bit
      xor al, al           // result

@tcdb_secondhalf:
		mov dl, BALLHEIGHT/2 // dl is line counter

@tcdb_morelines:
      // left zone
      mov ecx, BALLWIDTH/2
@tcdb_loop1:
      mov ah, [esi]
      cmp ah, 0
      jz @tcdb_next1
      mov ah, [edi]
      test ah, $C0
      jnz @tcdb_next1
      or al, bl

@tcdb_next1:
      inc edi
      inc esi
      dec ecx
      jnz @tcdb_loop1

      // right zone
      mov ecx, BALLWIDTH/2
@tcdb_loop2:
      mov ah, [esi]
      cmp ah, 0
      jz @tcdb_next2
      mov ah,[edi]
      test ah, $C0
      jnz @tcdb_next2
      or al, bh

@tcdb_next2:
      inc edi
      inc esi
      dec ecx
      jnz @tcdb_loop2

@tcdb_nextscan:
      add edi, FIELDWIDTH-BALLWIDTH

      dec dl                 // line counter
		jnz @tcdb_morelines

      shl bl, 2
      shl bh, 2
      inc dh
      cmp dh, 2
      je @tcdb_secondhalf

      mov Result, al

      pop ebx
      pop edi
      pop esi
end;
end;

end.
