unit f_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, WinGImag, D_Global, Dib256, U_pprot, StdCtrls, MMSystem,
  ThdTimer;

type
  TFormPingPong = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Options: TMenuItem;
    Help1: TMenuItem;
    FileNewGameItem: TMenuItem;
    FilePauseItem: TMenuItem;
    HelpContentsItem: TMenuItem;
    FileExitItem: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    HelpAboutItem: TMenuItem;
    OptionsOnePlayerItem: TMenuItem;
    OptionsTwoPlayerItem: TMenuItem;
    GameField: TWinGImage;
    Panel1: TPanel;
    Panel2: TPanel;
    Score1: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Score2: TLabel;
    GameTimer: TThreadedTimer;
    procedure FileExitItemClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GameTimerTimer(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure OptionsTwoPlayerItemClick(Sender: TObject);
    procedure OptionsOnePlayerItemClick(Sender: TObject);
    procedure FilePauseItemClick(Sender: TObject);
    procedure FileNewGameItemClick(Sender: TObject);
    procedure HelpContentsItemClick(Sender: TObject);
  private
      FPlaying: Boolean;
      FNumberOfPlayers: Byte;

      procedure InitializeNewGame;
      procedure BallInCenter( GoalIdPlayer: Byte );
      procedure InitializeGraphics;
      procedure DrawPads_Ball;
      function GetPlayerKeys( IdPlayer: Byte ): Byte;
      procedure MovePad( IdPlayer: Byte; Keys: Byte );
      procedure MoveBall;
  public
    { Public declarations }
  end;

   PadSpriteStorage = array [0..PADWIDTH*PADHEIGHT-1] of char;
   BallSpriteStorage = array [0..BALLWIDTH*BALLHEIGHT-1] of char;

   TPad = record
      PosX, PosY: Integer;
      PosAntX, PosAntY: Integer;
   end;
   TBall = record
      PosX, PosY: Longint;
      PosAntX, PosAntY: Longint;
      VelX, VelY: Longint;
      Status: Byte;
   end;

var
   FormPingPong: TFormPingPong;
   PadSprite: array [0..1] of PadSpriteStorage;
   BallSprite: BallSpriteStorage;
   GameFieldDib: TDib256;
   Pad: array [0..1] of TPad;
   Ball: TBall;
   Goals: array [0..1] of Byte;

implementation

uses f_about, f_pause;

{$R *.DFM}

procedure TFormPingPong.FormCreate(Sender: TObject);
begin
   Randomize;

   try
      InitializeGraphics;
      InitializeNewGame;
      DrawPads_Ball;
   except
      else close;
   end;

   FPlaying := False;
   FNumberOfPlayers := 1;
   GameTimer.Enabled := False;
end;

procedure TFormPingPong.FormDestroy(Sender: TObject);
begin
   GameFieldDib.Free;
end;

procedure TFormPingPong.HelpContentsItemClick(Sender: TObject);
begin
   Application.HelpCommand( HELP_CONTENTS, 0 );
end;

procedure TFormPingPong.HelpAboutItemClick(Sender: TObject);
begin
   GameTimer.Enabled := False;
   AboutBox.ShowModal;
   if (FPlaying = True) then
      GameTimer.Enabled := True;
end;

procedure TFormPingPong.OptionsOnePlayerItemClick(Sender: TObject);
begin
   FNumberOfPlayers := 1;
   OptionsTwoPlayerItem.Checked := False;
   OptionsOnePlayerItem.Checked := True;
end;

procedure TFormPingPong.OptionsTwoPlayerItemClick(Sender: TObject);
begin
   FNumberOfPlayers := 2;
   OptionsTwoPlayerItem.Checked := True;
   OptionsOnePlayerItem.Checked := False;
end;

procedure TFormPingPong.FileExitItemClick(Sender: TObject);
begin
   Close;
end;

procedure TFormPingPong.FilePauseItemClick(Sender: TObject);
begin
   GameTimer.Enabled := False;
   FormPause.Left := Left + (Width div 2) - (FormPause.Width div 2);
   FormPause.Top := Top + (Height div 2) - (FormPause.Height div 2);
   FormPause.ShowModal;
   GameTimer.Enabled := True;
end;


procedure TFormPingPong.FileNewGameItemClick(Sender: TObject);
begin
   if (FPlaying = False) then
   begin
      FPlaying := True;
      FileNewGameItem.Caption := 'Stop Game';
      FilePauseItem.Enabled := True;
      Options.Enabled := False;

      InitializeNewGame;
      DrawPads_Ball;
      GameTimer.Enabled := True;
   end
   else
   begin
      FPlaying := False;
      FileNewGameItem.Caption := '&New Game';
      FilePauseItem.Enabled := False;
      Options.Enabled := True;

      GameTimer.Enabled := False;
   end;
end;


procedure TFormPingPong.InitializeGraphics;
var
   fs: TFileStream;
   pS, pD: PChar;
   X, Y: Integer;
begin
   // Read the sprites off the ball and pad
   fs := TFileStream.Create( FILEDATPAD, fmOpenRead );
   try
      fs.ReadBuffer( PadSprite[0], sizeof(PadSprite[0]) );
   finally
      fs.Free;
   end;

   fs := TFileStream.Create( FILEDATBALL, fmOpenRead );
   try
      fs.ReadBuffer( BallSprite, sizeof(BallSprite) );
   finally
      fs.Free;
   end;

   // Copy pad 1 to pad 2 and invert image
   pS := @PadSprite[0];
   pD := @PadSprite[1];
   for X := 0 to PADWIDTH-1 do
      for Y := 0 to PADHEIGHT-1 do
         (pD + PADWIDTH-1 - X + Y*PADWIDTH)^ := (pS + X + Y*PADWIDTH)^;

   // initialize WinG dimensions
   GameField.WinG.Width := FIELDWIDTH;
   GameField.WinG.Height := FIELDHEIGHT;
   GameField.Width := GameField.WinG.Width;
   GameField.Height := GameField.WinG.Height;
   GameField.View.Mode := All;

   // read GameField Bitmap
   GameFieldDib := TDib256.Create;
   GameFieldDib.LoadFromFile( FILEGAMEFIELD );
end;


procedure TFormPingPong.InitializeNewGame;
var
   Cnt: Integer;
begin
   // initialize position of pads
   for Cnt := 0 to 1 do
   begin
      if (Cnt = 0) then
         Pad[Cnt].PosX := PADDISTANCE - (PADWIDTH div 2)
      else
         Pad[Cnt].PosX := FIELDWIDTH - PADDISTANCE - (PADWIDTH div 2);

      Pad[Cnt].PosY := (FIELDHEIGHT - PADHEIGHT) div 2;
      Pad[Cnt].PosAntX := 0;
      Pad[Cnt].PosAntY := 0;
   end;

   BallInCenter( Random(2) );
   Score1.Caption := '0';
   Score2.Caption := '0';

   // Put GameField Bitmap in WinG
   CopyDIBBits( GameField.WinG.Pixels, GameFieldDib.Pixels,
      GameFieldDib.Width, GameFieldDib.Height, GameField.WinG.WidthBytes,
      GameFieldDib.WidthBytes );
   GameField.Palette.ReadFromRGBQuad( PRGBQUAD(GameFieldDib.ColorTable), 256 );
   GameField.Palette.CreateHandle;
end;


procedure TFormPingPong.BallInCenter( GoalIdPlayer: Byte );
{
   Puts the ball in center of field and initialize it's speed.

   GoalIdPlayer - identifies the player who scored last, so that the ball
                  goes first to him.
}
begin
   Ball.PosX := ((FIELDWIDTH - BALLWIDTH) div 2
      - BALLFROMCENTERX*(GoalIDPlayer*2-1)) shl 8;
   Ball.PosY := ((FIELDHEIGHT - BALLHEIGHT) div 2 + random(BALLFROMCENTERY)
      - (BALLFROMCENTERY div 2)) shl 8;
   Ball.VelX := (BALLVELOCITYMAX - (BALLVELOCITYVAR div 2))
      * (GoalIdPlayer*2-1);
   Ball.VelY := (BALLVELOCITYMAX - (BALLVELOCITYVAR div 2))
      * (random(2)*2-1);
end;


procedure TFormPingPong.DrawPads_Ball;
var
   Cnt: Integer;
   a, b, c: TRect;
begin
   // undraw pads
   for Cnt := 0 to 1 do
   with Pad[Cnt] do
   begin
      if ((PosX = PosAntX) and (PosY = PosAntY)) then
         continue;

      // copy background of old position of pad to the GameField
      CopyDIBBits( PChar(GameField.WinG.Pixels)
         + Pad[Cnt].PosAntX + Pad[Cnt].PosAntY*FIELDWIDTH,
         PChar(GameFieldDib.Pixels)
         + Pad[Cnt].PosAntX + Pad[Cnt].PosAntY*FIELDWIDTH,
         PADWIDTH, PADHEIGHT,
         GameField.WinG.WidthBytes, GameFieldDib.WidthBytes );
   end;

   // undraw ball
   CopyDIBBits( PChar(GameField.WinG.Pixels)
      + (Ball.PosAntX shr 8) + (Ball.PosAntY shr 8)*FIELDWIDTH,
      PChar(GameFieldDib.Pixels)
      + (Ball.PosAntX shr 8) + (Ball.PosAntY shr 8)*FIELDWIDTH,
      BALLWIDTH, BALLHEIGHT,
      GameField.WinG.WidthBytes, GameFieldDib.WidthBytes );

   // realize palette
   SelectPalette( GameField.Canvas.Handle, GameField.Palette.Handle, False );
   RealizePalette( GameField.Canvas.Handle );

   // draw pads
   for Cnt := 0 to 1 do
   with Pad[Cnt] do
   begin
      // copy the pad in new position to the GameField
      TransCopyDIBBits( PChar(GameField.WinG.Pixels)
         + Pad[Cnt].PosX + Pad[Cnt].PosY*FIELDWIDTH, @PadSprite[Cnt],
         PADWIDTH, PADHEIGHT, GameField.WinG.WidthBytes, PADWIDTH, 0 );

      // calc. the rectangle which needs to be updated
      a.Left := Pad[Cnt].PosX;
      a.Top := Pad[Cnt].PosY;
      a.Right := a.Left + PADWIDTH;
      a.Bottom := a.Top + PADHEIGHT;
      b.Left := Pad[Cnt].PosAntX;
      b.Top := Pad[Cnt].PosAntY;
      b.Right := b.Left + PADWIDTH;
      b.Bottom := b.Top + PADHEIGHT;
      UnionRect( c, a, b );

      // draw updated rectangle to screen
      GameField.WinG.BitBlt( GameField.Canvas.Handle,
         c.Left, c.Top, c.Right - c.Left, c.Bottom - c.Top,
         c.Left, c.Top );

      // set new position as old position
      Pad[Cnt].PosAntX := Pad[Cnt].PosX;
      Pad[Cnt].PosAntY := Pad[Cnt].PosY;
   end;

   // Check colisions with walls and pads
   // ATENTION: this has to be right here, after the pads are draw and before
   // the ball is draw
   Ball.Status := DetectBallCollision( PChar(GameField.WinG.Pixels)
      + (Ball.PosX shr 8) + (Ball.PosY shr 8)*FIELDWIDTH, @BallSprite );

   // draw ball
   // copy the ball in new position to the GameField
   TransCopyDIBBits( PChar(GameField.WinG.Pixels)
      + (Ball.PosX shr 8) + (Ball.PosY shr 8)*FIELDWIDTH, @BallSprite,
      BALLWIDTH, BALLHEIGHT, GameField.WinG.WidthBytes, BALLWIDTH, 0 );

   // calc. the rectangle which needs to be updated
   a.Left := Ball.PosX shr 8;
   a.Top := Ball.PosY shr 8;
   a.Right := a.Left + BALLWIDTH;
   a.Bottom := a.Top + BALLHEIGHT;
   b.Left := Ball.PosAntX shr 8;
   b.Top := Ball.PosAntY shr 8;
   b.Right := b.Left + BALLWIDTH;
   b.Bottom := b.Top + BALLHEIGHT;
   UnionRect( c, a, b );

   // draw updated rectangle to screen
   GameField.WinG.BitBlt( GameField.Canvas.Handle,
      c.Left, c.Top, c.Right - c.Left, c.Bottom - c.Top,
      c.Left, c.Top );

   // set new position as old position
   Ball.PosAntX := Ball.PosX;
   Ball.PosAntY := Ball.PosY;
end;


function TFormPingPong.GetPlayerKeys( IdPlayer: Byte ): Byte;
{  Return:  Bit 0 - Key Up
            Bit 1 - Key Down
}
begin
   Result := 0;

   case IdPlayer of
      0: begin
         if ((GetKeyState(P1KEYUP) and $8000) <> 0) then
            Result := 1;
         if ((GetKeyState(P1KEYDOWN) and $8000) <> 0) then
            Result := Result or 2;
         end;
      1: begin
         if (FNumberOfPlayers = 2) then
         begin
            if ((GetKeyState(P2KEYUP) and $8000) <> 0) then
               Result := 1;
            if ((GetKeyState(P2KEYDOWN) and $8000) <> 0) then
               Result := Result or 2;
         end
         else
         begin
            if ((Ball.PosX shr 8) > FIELDWIDTH div 2) and (Ball.VelX > 0) then
               if ((Ball.PosY shr 8) + BALLHEIGHT div 2 < (Pad[1].PosY
                  + PADHEIGHT div 2)) then
                  Result := 1
               else
                  Result := 2
            else
               Result := 0;
         end;
         end;
   end;
end;


procedure TFormPingPong.GameTimerTimer(Sender: TObject);
var
   a: Byte;
   Cnt: Integer;
begin
   for Cnt := 0 to 1 do
   begin
      a := GetPlayerKeys( Cnt );
      MovePad( Cnt, a );
   end;
   MoveBall;

   DrawPads_Ball;
end;


procedure TFormPingPong.MovePad( IdPlayer: Byte; Keys: Byte );
begin
   with Pad[IdPlayer] do
   begin
      if ((Keys and 1) <> 0) then
      begin
         PosY := PosY - PADVELOCITY;
         if PosY < PADUPPERLIM then
            PosY := PADUPPERLIM;
      end;

      if ((Keys and 2) <> 0) then
      begin
         PosY := PosY + PADVELOCITY;
         if PosY > PADBOTTOMLIM then
            PosY := PADBOTTOMLIM;
      end;
   end;
end;


procedure TFormPingPong.MoveBall;
var
   X, Y: Longint;
begin
   with Ball do
   begin
      // calc. new velocity
      X := VelX + Random(BALLVELOCITYVAR) - (BALLVELOCITYVAR div 2);
      if (Abs(X) > BALLVELOCITYMAX)
         or (Abs(X) < BALLVELOCITYMAX - BALLVELOCITYVAR) then
         X := VelX;
      Y := VelY + Random(BALLVELOCITYVAR) - (BALLVELOCITYVAR div 2);
      if (Abs(Y) > BALLVELOCITYMAX) 
         or (Abs(Y) < BALLVELOCITYMAX - BALLVELOCITYVAR) then
         Y := VelY;

      case Status of
         0: begin end;
         1: begin
               VelX := Abs(X);
               VelY := Abs(Y);
            end;
         2: begin
               VelX := -Abs(X);
               VelY := Abs(Y);
            end;
         3: VelY := Abs(Y);
         4: begin
               VelX := Abs(X);
               VelY := -Abs(Y);
            end;
         5: Velx := Abs(X);
         6: begin end;
         7: begin
               VelX := Abs(X);
               VelY := Abs(Y);
            end;
         8: begin
               VelX := -Abs(X);
               VelY := -Abs(Y);
            end;
         9: begin end;
         10: VelX := -Abs(X);
         11: begin
               VelX := -Abs(X);
               VelY := Abs(Y);
            end;
         12: VelY := -Abs(Y);
         13: begin
               VelX := Abs(X);
               VelY := -Abs(Y);
            end;
         14: begin
               VelX := -Abs(X);
               VelY := -Abs(Y);
            end;
         15: begin
               VelX := -X;
               VelY := -Y;
            end;
      end;

      if (Status <> 0) then
         PlaySound( SNDCOLLISION, 0,
            SND_FILENAME + SND_ASYNC + SND_NOWAIT + SND_NODEFAULT );

      PosX := PosX + VelX;
      PosY := PosY + VelY;

      if (PosX <= 0) or (PosX >= 580*256) then
      begin
         if (PosX <= 0) then
         begin
            BallInCenter( 1 );
            Score2.Caption := IntToStr(StrToInt(Score2.Caption)+1);
         end
         else
         begin
            BallInCenter( 0 );
            Score1.Caption := IntToStr(StrToInt(Score1.Caption)+1);
         end;

         PlaySound( SNDGOAL, 0, SND_SYNC + SND_FILENAME + SND_NODEFAULT );
      end;
   end;
end;

end.
