{
  TWindowsList v1.0
  This unit will get a list of actives windows in the system.
  To get it, call one of the functions GetAllWindows,
  GetVisibleWindows or GetInvisibleWindows. This will gather
  windows informations and place it in the TheWindowsList
  StringList. The AcceptEmptyNames will decide if yes or not
  unnamed windows are added to the list.

  I know I haven't used a 'real object method' to do the job
  (The code is repeated in all the 3 Get functions), but it was
  a lot easier that way. I tried another method, but I screwed.
  Anyway, if you decide to rewrite it, let me know.

  In futures version, I will add others windows informations
  line ClientRECT, Classes, etc.

  Special thanks to Franze who helped me a lot, even if he didn't
  find all the bugs, he spent few hours with me looking at it.

    Jerome Tremblay, aka DeathStroke,
    jerome@infose.com
}

unit WindowsListUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TCustomEnumWindowsProc = Procedure(WinHandle : HWND);

  TWindowInfo = class(TObject)  // This object is used to store
  private                       // window's Infos in the TListString
    { Private declarations }
  public
    Handle : HWND;
    { Public declarations }
  end;


  TWindowsList = class(TComponent)
  private
    { Private declarations }
    fWindowsList : TStringList;
    fAcceptEmptyNames : Boolean;
  protected
    { Protected declarations }
    Procedure GetAllWindowsProc(WinHandle : HWND);
    Procedure GetInvisibleWindowsProc(WinHandle : HWND);
    Procedure GetVisibleWindowsProc(WinHandle : HWND);
  public
    { Public declarations }
    Constructor Create(AOwner : TComponent); override;
    Destructor Destroy; override;
    Procedure GetAllWindows;
    Procedure GetInvisibleWindows;
    Procedure GetVisibleWindows;
    Function GetHandle(Idx : Integer): HWND;
  published
    { Published declarations }
    Property TheWindowsList : TStringList read fWindowsList write fWindowsList;
    Property AcceptEmptyNames : Boolean read fAcceptEmptyNames write fAcceptEmptyNames default True;
  end;

procedure Register;

implementation

Constructor TWindowsList.Create(AOwner : TComponent);
Begin
  inherited Create(AOwner);
  fWindowsList := TStringList.Create;
End;

Destructor TWindowsList.Destroy;
Begin
 fWindowsList.Clear;
 fWindowsList.Free;
 inherited Destroy;
End;

Procedure TWindowsList.GetAllWindowsProc(WinHandle : HWND);
Var
  P : Array[0..256] Of Char;
  WinObj : TWindowInfo;
Begin
  P[0] := #0;
  GetWindowText(WinHandle, P, 255);
  WinObj := TWindowInfo.Create;
  WinObj.Handle := WinHandle;
  If (fAcceptEmptyNames Or (P[0] <> #0)) Then
    fWindowsList.AddObject(P, WinObj);
End;  // Procedure

Procedure TWindowsList.GetAllWindows;
Var
  WindowHandle2 : HWND;
Begin
  fWindowsList.Clear;
  WindowHandle2 := FindWindow( Nil, Nil);
  GetAllWindowsProc(WindowHandle2);
  While (WindowHandle2 <> 0) Do  // While there are still windows
    Begin
    WindowHandle2 := GetWindow(WindowHandle2, GW_HWNDNEXT);
    GetAllWindowsProc(WindowHandle2);
    End; // While
End; // Procedure

Procedure TWindowsList.GetInvisibleWindowsProc(WinHandle : HWND);
Var
  P : Array[0..256] Of Char;
  WinObj : TWindowInfo;
Begin
  P[0] := #0;
  GetWindowText(WinHandle, P, 255);
  WinObj := TWindowInfo.Create;
  WinObj.Handle := WinHandle;
  If (fAcceptEmptyNames Or (P[0] > #0)) Then
    If Not(IsWindowVisible(WinHandle))
      Then fWindowsList.AddObject(P, WinObj);
End;  // Procedure

Procedure TWindowsList.GetInvisibleWindows;
Var
  WindowHandle2 : HWND;
Begin
  fWindowsList.Clear;
  WindowHandle2 := FindWindow( Nil, Nil);
  GetInvisibleWindowsProc(WindowHandle2);
  While (WindowHandle2 <> 0) Do  // While there are still windows
    Begin
    WindowHandle2 := GetWindow(WindowHandle2, GW_HWNDNEXT);
    GetInvisibleWindowsProc(WindowHandle2);
    End;
End;

Procedure TWindowsList.GetVisibleWindowsProc(WinHandle : HWND);
Var
  P : Array[0..256] Of Char;
  WinObj : TWindowInfo;
Begin
  P[0] := #0;
  GetWindowText(WinHandle, P, 255);
  WinObj := TWindowInfo.Create;
  WinObj.Handle := WinHandle;
  If (fAcceptEmptyNames Or (P[0] > #0)) Then
    If IsWindowVisible(WinHandle)
      Then fWindowsList.AddObject(P, WinObj);
End;  // Procedure

Procedure TWindowsList.GetVisibleWindows;
Var
  WindowHandle2 : HWND;
Begin
  fWindowsList.Clear;
  WindowHandle2 := FindWindow( Nil, Nil);
  GetVisibleWindowsProc(WindowHandle2);
  While (WindowHandle2 <> 0) Do  // While there are still windows
    Begin
    WindowHandle2 := GetWindow(WindowHandle2, GW_HWNDNEXT);
    GetVisibleWindowsProc(WindowHandle2);
    End;
End;

Function TWindowsList.GetHandle(Idx : Integer) : HWND;
Begin
  Result := TWindowInfo(fWindowsList.Objects[Idx]).Handle;
  // This is called a Typecast. It allows me to access the object
  // directly without having to store it in a temp variable.
  // This is necessary, since in a StringList, all objects are
  // TObject, so there are no properties & methods.
End;

procedure Register;
begin
  RegisterComponents('Samples', [TWindowsList]);
end;

end.
