unit Mmail;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, Smtp,
  SMTPSu,IniFiles, ComCtrls, MailUtil, mailbase;

type
  TMailForm = class(TForm)
    ToolBar: TPanel;
    SendButton: TSpeedButton;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    SendInfoPanel: TPanel;
    ToEdit: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    SubjectEdit: TEdit;
    CancelButton: TSpeedButton;
    Label2: TLabel;
    BodyMemo: TMemo;
    AttachButton: TSpeedButton;
    AttachmentsComboBox: TComboBox;
    Mailer: TSMTP;
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ProgressBar1: TProgressBar;
    procedure ExitButtonClick(Sender: TObject);
    procedure SendButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure SetupButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure AttachButtonClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MailerProgress(Sender: TObject);
    procedure MailerStatusChange(Sender: TObject);
  private
    { Private declarations }
    IniName : string;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  MailForm: TMailForm;

implementation

{$R *.DFM}

procedure TMailForm.EnableControls;
var
  i : Integer;
  SB : TSpeedButton;
begin
  for i:=0 to ToolBar.ControlCount-1 do
  if ToolBar.Controls[i] is TSpeedButton then
  begin
    SB:=ToolBar.Controls[i] as TSpeedButton;
    SB.Enabled:=SB.Tag<>1;
  end;
  SendInfoPanel.Enabled:=true;
  ProgressBar1.Visible:=false;
  BodyMemo.Enabled:=true;
  Cursor:=crDefault;
end;

procedure TMailForm.DisableControls;
var
  i : Integer;
  SB : TSpeedButton;
begin
  for i:=0 to ToolBar.ControlCount-1 do
  if ToolBar.Controls[i] is TSpeedButton then
  begin
    SB:=ToolBar.Controls[i] as TSpeedButton;
    SB.Enabled:=SB.Tag=1;
  end;
  SendInfoPanel.Enabled:=false;
  ProgressBar1.Visible:=true;
  BodyMemo.Enabled:=false;
  Cursor:=crHourGlass;
end;

procedure TMailForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TMailForm.SendButtonClick(Sender: TObject);
begin
  if (Mailer.Server='') or (Mailer.From='') then
    MessageDlg('You might want to enter the information'^M^J+
               'in the Setup dialog box...',mtError,[mbOk],0)
  else
  if ToEdit.Text='' then
    MessageDlg('You might want to enter the recipient''s address first...'
               ,mtError,[mbOk],0)
  else
  with Mailer do
  begin
    Recipient:=ToEdit.Text;
    Subject:=SubjectEdit.Text;
    Body:=BodyMemo.Lines;
    Attachments:=AttachmentsComboBox.Items;
    DisableControls;
    try
      SendSingleMessage;
    finally
      EnableControls;
    end;
  end;
end;

procedure TMailForm.CancelButtonClick(Sender: TObject);
begin
  Mailer.Cancel;
end;

procedure TMailForm.SetupButtonClick(Sender: TObject);
var
  A,N : string;
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=Mailer.Server;
    BreakLine(Mailer.From,A,N);
    UserAddressEdit.Text:=A;
    UserNameEdit.Text:=N;
    LogFileNameEdit.Text:=Mailer.LogFileName;
    EncodeComboBox.ItemIndex:=Ord(Mailer.Encoding);
    CharSetComboBox.ItemIndex:=Ord(Mailer.CharSet);
    ShowModal;
    if ModalResult=mrOk then
    begin
      Mailer.Server:=ServerEdit.Text;
      Mailer.From:=UserAddressEdit.Text;
      Mailer.From:=JoinLines(UserAddressEdit.Text,UserNameEdit.Text);
      Mailer.LogFileName:=LogFileNameEdit.Text;
      Mailer.Encoding:=TEncoding(EncodeComboBox.ItemIndex);
      Mailer.CharSet:=TCharSet(CharSetComboBox.ItemIndex);
    end;
  finally
    free;
  end;
end;

procedure TMailForm.FormCreate(Sender: TObject);
var
  A,N : string;
  i : Integer;
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    Mailer.Server:=ReadString('Setup','Server','');
    A:=ReadString('Setup','EMail Address','');
    N:=ReadString('Setup','Name','');
    Mailer.From:=JoinLines(A,N);
    Mailer.LogFileName:=ReadString('Setup','Log File','');
    Mailer.Encoding:=TEncoding(ReadInteger('Setup','Encoding',0));
    Mailer.CharSet:=TCharSet(ReadInteger('Setup','CharSet',0));
  finally
    free;
  end;
  for i:=1 to ParamCount do
    AttachmentsComboBox.Items.Add(ParamStr(i));
  AttachmentsComboBox.ItemIndex:=0;
end;

procedure TMailForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  A,N : string;
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',Mailer.Server);
    BreakLine(Mailer.From,A,N);
    WriteString('Setup','EMail Address',A);
    WriteString('Setup','Name',N);
    WriteString('Setup','Log File',Mailer.LogFileName);
    WriteInteger('Setup','Encoding',Ord(Mailer.Encoding));
    WriteInteger('Setup','CharSet',Ord(Mailer.CharSet));
  finally
    free;
  end;
end;

procedure TMailForm.AttachButtonClick(Sender: TObject);
begin
  with TOpenDialog.Create(Self) do
  try
    Filter:='All Files (*.*)|*.*';
    Options:=[ofHideReadOnly,ofAllowMultiSelect];
    if Execute then
    begin
      AttachmentsComboBox.Items.Assign(Files);
      AttachmentsComboBox.ItemIndex:=0;
    end
    else
      AttachmentsComboBox.Items.Clear;
  finally
    Free;
  end;
end;

procedure TMailForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if not SendInfoPanel.Enabled then
  begin
    MessageDlg('Transfer in Progress.  Click Cancel button first.',
               mtError,[mbOk],0);
    CanClose:=false;
  end
  else
    CanClose:=true;
end;

procedure TMailForm.MailerProgress(Sender: TObject);
begin
  ProgressBar1.Position:=Mailer.Progress;
end;

procedure TMailForm.MailerStatusChange(Sender : TObject);
var
  s : string;
begin
  case Mailer.Status of
   msIdle : s:='';
   msLogIn : s:='Logging In';
   msLogOut : s:='Logging Out';
   msHeaders : s:='Sending headers';
   msEnvelope : s:='Sending commands';
   msBody : s:='Sending message body';
   msAttachment : s:='Sending attachment(s)';
   msCancel : s:='Canceled';
   msEnCode : s:='Encoding the attachment(s)';
   msConnecting : s:='Connecting to Server';
  end;
  StatusBar1.Panels[0].Text:=s;
end;

end.
