unit Missile;

(*********************************************
TMissile->TSprite

This sprite descends directly from TSprite, and
has its own custom Render method that simply
sets pixels in the video buffer.  This is a re-
usable sprite class that is not specific to any
app.
*********************************************)

interface

uses
  Windows, SysUtils, Classes, Graphics, Controls, DibDrawingSurface,
  Sprite, DIB, DIBSprite, Utility;

type

  TMissile = class( TSprite )
  private
     nLife: word;
     nColor: byte;
     nMaxLife: word;
  protected
  public
     constructor CreateMissile( nMax: word; nColorOffset: byte );
     procedure Move; override;
     procedure Render; override;
  end;

implementation

constructor TMissile.CreateMissile( nMax: word; nColorOffset: byte );
begin
  inherited Create;
  nLife := 0;
  nColor := nColorOffset;
  Priority := 1;
  Speed := 8;
  nMaxLife := nMax;
  MotionType := mtContinuous;
  Width := 3;
  Height := 3;
end;

procedure TMissile.Move;
begin
  Inc( nLife );
  if nLife = nMaxLife then
     Dead := TRUE;
  inherited Move;
end;

procedure TMissile.Render;
var
  n: byte;
begin
  inherited Render;
  n := Random( 16 ) + nColor;
  with ptPhysical, dds do
     begin
        if ( X - 2 >= 0 ) and ( Y - 2 >= 0 ) and
           ( X + 2 < PhysicalWidth ) and ( Y + 2 < PhysicalHeight ) then
           begin
              with DIBCanvas do
                 begin
                    Pixels[X, Y] := n;
                    Pixels[X, Y - 1] := n;
                    Pixels[X, Y + 1] := n;
                    Pixels[X - 1, Y] := n;
                    Pixels[X + 1, Y] := n;
                    Pixels[X - 1, Y - 1] := n;
                    Pixels[X - 1, Y + 1] := n;
                    Pixels[X + 1, Y - 1] := n;
                    Pixels[X + 1, Y + 1] := n;
                    Pixels[X, Y - 2] := n;
                    Pixels[X, Y + 2] := n;
                    Pixels[X - 2, Y] := n;
                    Pixels[X + 2, Y] := n;
                 end;
           end;
     end;
end;

end.
