(*********************************************
TDIBSprite->TSprite

This descendant of TSprite uses a TDIB to render
itself on a TWinGPaintBox.  If the TDIB is segmented
(via the FramesX, FramesY property), the sprite is
properly rendered using its FrameX and FrameY values.

Properties

DIB-
  The TDIB that will be used to render the sprite.
FrameX,FrameY-
  Controls which segment of the DIB is used for
  rendering.  Valid only if the TDIB is segmented
  via its FramesX and FramesY properties.

Events

Methods

CreateDIBSprite-
  A constructor that takes a TDIB as a parameter.
Render-
  The DIBCanvas of the DIB is used to render the
  sprite.
*********************************************)

unit Dibsprite;

interface

uses
  Windows, SysUtils, Classes, Graphics, Controls, DIBDrawingSurface, Sprite, DIB,
  Grafix;

type

  TDIBSprite = class( TSprite )
  private
     FFrameX: integer;
     FFrameY: integer;
     bFrames: boolean;
     Width2, Height2: integer;
  protected
     FDIB: TDIB;
  public
     constructor CreateDIBSprite( dib: TDIB );
     procedure Render; override;
     property DIB: TDIB read FDIB write FDIB;
     property FrameX: integer read FFrameX write FFrameX;
     property FrameY: integer read FFrameY write FFrameY;
  end;

implementation

(***************************************************
Create a TDIBSprite from an existing TDIB, and assign
values to variables to be used later.
***************************************************)
constructor TDIBSprite.CreateDIBSprite( dib: TDIB );
begin
  inherited Create;
  FDIB := dib;
  bFrames := ( dib.FramesX > 0 ) and ( dib.FramesY > 0 );
  if bFrames then
     begin
        Width := dib.DIBCanvas.Width div dib.FramesX;
        Height := dib.DIBCanvas.Height div dib.FramesY;
     end
  else
     begin
        Width := dib.DIBCanvas.Width;
        Height := dib.DIBCanvas.Height;
     end;
  Width2 := Width div 2;
  Height2 := Height div 2;

end;

(***************************************************
Render the sprite by copying a rectangle from the
DIBCanvas of the TDIB to the DIBCanvas of the TDIBDrawingSurface.
If the TDIB is segmented, copy only the appropriate area.
***************************************************)
procedure TDIBSprite.Render;
var
  rectDest, rectSrc: TRect;
begin
  inherited Render;
  if Visible then
     begin
        rectSrc := Rect( FrameX * Width,
           FrameY * Height,
           FrameX * Width + Width - 1,
           FrameY * Height + Height - 1 );

        rectDest := Rect( ptPhysical.X - Width2,
           ptPhysical.Y - Height2,
           ptPhysical.X + Width2 - 1,
           ptPhysical.Y + Height2 - 1 );

        dds.DIBCanvas.CopyRect( rectDest, dib.DIBCanvas, rectSrc );
     end;
end;

end.
