unit Explosion;

(*********************************************
TExplosion->TSprite

A re-usable sprite class that generates an
explosion effect through particles.
*********************************************)

interface

uses
  Windows, SysUtils, Classes, Graphics, Controls, DIBDrawingSurface, Sprite,
  Grafix, Utility;

type

  TExplBits = record
     pt: TPoint;
     x, y: integer;
  end;

  TExplosion = class( TSprite )
  private
     FLife: integer;
     FCol: byte;
     arParticles: array[1..25] of TExplBits;
  protected
  public
     constructor CreateExplosion( pt: TPoint; nLife: integer; nColor: byte );
     procedure Move; override;
     procedure Render; override;
  end;

implementation

constructor TExplosion.CreateExplosion( pt: TPoint; nLife: integer; nColor: byte );
var
  i: integer;
begin
  inherited Create;
  FCol := nColor;
  FLife := nLife;
  ptPosition := pt;
  for i := 1 to 25 do
     with arParticles[i] do
        begin
           pt.X := ptPosition.X;
           pt.Y := ptPosition.Y;
           x := Random( 200 );
           if Random( 100 ) > 50 then
              x := -x;
           y := Random( 200 );
           if Random( 100 ) > 50 then
              y := -y;
        end;
end;

procedure TExplosion.Move;
begin
  inherited Move;
  if FLife > 0 then
     begin
        Dec( FLife );
        if FLife = 0 then
           Dead := TRUE;
     end;
end;

procedure TExplosion.Render;
var
  i: integer;
  x_, y_: integer;
begin
  inherited Render;
  for i := 1 to 25 do
     with arParticles[i] do
        begin
           if Random( 200 ) > Abs( x ) then
              if x < 0 then
                 Dec( pt.X )
              else
                 Inc( pt.X );
           if Random( 200 ) > Abs( y ) then
              if y < 0 then
                 Dec( pt.Y )
              else
                 Inc( pt.Y );
           if ( pt.X >= 0 ) and ( pt.X < dds.PhysicalWidth ) and
              ( pt.Y >= 0 ) and ( pt.Y < dds.PhysicalHeight ) then
              dds.DIBCanvas.Pixels[pt.X, pt.Y] := Random( 16 ) + FCol;
        end;
end;

end.
