unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, HiResTimer, ColorPalette, SpriteEngine, DIBDrawingSurface,
  Explosion, Sprite, PolygonSprite, Missile;

type
  TfrmMain = class(TForm)
    board: TDIBDrawingSurface;
    missiles: TSpriteEngine;
    squares: TSpriteEngine;
    explosions: TSpriteEngine;
    palette: TColorPalette;
    timerMain: THiResTimer;
    Button1: TButton;
    Button2: TButton;
    procedure timerMainTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure boardCustomPaint(Sender: TObject);
    procedure missilesCollision(Sender: TObject; Sprite,
      TargetSprite: TSprite);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    function RandomPos: TPoint;
  public
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.timerMainTimer(Sender: TObject);
begin
  board.DIBRefresh;
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  Randomize;
  timerMain.Enabled := TRUE;
end;

procedure TfrmMain.boardCustomPaint(Sender: TObject);
begin
  squares.ProcessSprites;
  missiles.ProcessSprites;
  explosions.ProcessSprites;
  squares.RenderSprites;
  missiles.RenderSprites;
  explosions.RenderSprites;
  missiles.CollisionDetection( squares );
end;

procedure TfrmMain.missilesCollision(Sender: TObject; Sprite,
  TargetSprite: TSprite);
var
  expl: TExplosion;
begin
  expl := TExplosion.CreateExplosion( Sprite.Position, 60, Random( 255 ) );
  explosions.AddSprite( expl );
  squares.RemoveSprite( TargetSprite );
  missiles.RemoveSprite( Sprite );
end;

procedure TfrmMain.Button1Click(Sender: TObject);
var
  s: TSquareSprite;
begin
  s := TSquareSprite.CreatePolygonSprite( Random( 255 ) );
  s.Position := RandomPos;
  s.Destination := RandomPos;
  s.Speed := Random( 20 );
  s.SpinSpeed := Random( 20 );
  s.Spin := TRotation( Random( Ord( High( TRotation ) ) + 1 ) );
  s.MotionType := mtContinuous;
  squares.AddSprite( s );
end;

function TfrmMain.RandomPos: TPoint;
begin
  Result := Point( Random( board.Width ), Random( board.Height ) );
end;

procedure TfrmMain.Button2Click(Sender: TObject);
var
  m: TMissile;
begin
  m := TMissile.CreateMissile( 200, Random( 255 ) );
  m.Position := RandomPos;
  m.Destination := RandomPos;
  missiles.AddSprite( m );
end;

end.
