
{***************************************************
* Trackbar95 version 1.0
* Copyright (C) January 1997 James Ots
* Everyone is free to use this code as they wish, but
* if you use it commercially then I wouldn't mind a
* little something.
*
* I've added the functionality which Borland forgot to
* put in, which is the following properties:
*  Thumb - set whether the slider exists or not
*  FixedLength - sets whether slider works out its own size (false)
*     or if it uses ThumbSize (true)
*  ThumbSize - the size of the slider
*  SelEnabled - sets whether you have a wide slider (true)
*     or a normal slider (false)
*
* Email me: J.A.Ots@Warwick.ac.uk
****************************************************}

unit Trackbar95;

{$R-}

interface

uses Messages, Windows, SysUtils, CommCtrl, Classes, Controls, Forms,
  Menus, Graphics, StdCtrls, RichEdit, ComCtrls;

type
  TTrackBar95 = class(TTrackBar)
  private
    FFixedLength: Boolean;
    FSelEnabled: Boolean;
    FThumb: Boolean;
    FThumbSize: Integer;

    procedure SetFixedLength(Value: Boolean);
    procedure SetSelEnabled(Value: Boolean);
    procedure SetThumb(Value: Boolean);
    procedure SetThumbSize(Value: Integer);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property FixedLength: boolean read FFixedLength write SetFixedLength;
    property SelEnabled: boolean read FSelEnabled write SetSelEnabled;
    property Thumb: Boolean read FThumb write SetThumb default true;
    property ThumbSize: Integer read FThumbSize write SetThumbSize;
  end;

procedure Register;

implementation

uses Printers, Consts, ComStrs;

constructor TTrackBar95.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FThumb := true;
end;

procedure TTrackBar95.CreateParams(var Params: TCreateParams);
const
  SelectionEnabled: array[false..true] of Longint = (0, TBS_ENABLESELRANGE);
  ThumbEnabled: array[false..true] of Longint = (TBS_NOTHUMB, 0);
  FixedLengthEnabled: array[false..true] of Longint = (0, TBS_FIXEDLENGTH);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or SelectionEnabled[FSelEnabled] or
    ThumbEnabled[FThumb] or FixedLengthEnabled[FFixedLength];
  if not SelEnabled then
    Params.Style := Params.Style and not TBS_ENABLESELRANGE;
end;

procedure TTrackBar95.CreateWnd;
begin
  inherited CreateWnd;
  if HandleAllocated then
    SendMessage(Handle, TBM_SETTHUMBLENGTH, FThumbSize, 0);
end;

procedure TTrackBar95.SetFixedLength(Value : Boolean);
begin
  if Value <> FFixedLength then
  begin
    FFixedLength := Value;
    RecreateWnd;
  end;
end;

procedure TTrackBar95.SetSelEnabled(Value: Boolean);
begin
  if Value <> FSelEnabled then
  begin
    FSelEnabled := Value;
    RecreateWnd;
  end;
end;

procedure TTrackBar95.SetThumb(Value : Boolean);
begin
  if Value <> FThumb then
  begin
    FThumb := Value;
    RecreateWnd;
  end;
end;

procedure TTrackBar95.SetThumbSize(Value : Integer);
begin
  if Value <> FThumbSize then
  begin
    FThumbSize := Value;
    RecreateWnd;
  end;
end;

procedure Register;
begin
  RegisterComponents('Extra95', [TTrackbar95]);
end;

end.
