unit portage;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Tports;

type
  TForm1 = class(TForm)
    port1: Tport;
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure Delay(msecs:integer);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.Delay(msecs:integer);
var
   FirstTickCount:longint;
begin
     FirstTickCount:=GetTickCount;
     repeat    
           Application.ProcessMessages; {allowing access to other 
                                         controls, etc.}
     until ((GetTickCount-FirstTickCount) >= Longint(msecs));
end;

procedure TForm1.Button1Click(Sender: TObject);
var
   freq : integer;
   dura : integer;
   cont : integer;
   h : word;
begin

freq := strtoint(edit1.text);

with port1 do
     begin
          Address := $43; // Prepare timer by sending 10111100 to port 43.
          data := $B6;
          writetoport;
          address := $42; //Divide input frequency by timer ticks per second and
          freq := word(1193180 div freq);  //* write (byte by byte) to timer.
          data := freq;
          writetoport;
          address := $42;
          data := freq shr 8 ;
          writetoport;
          cont := readfromport; // Save speaker control byte.
          address := $61; // Turn on the speaker (with bits 0 and 1).
          data := (cont or $3);
          writetoport;
          delay(strtoint(edit2.text));
          if boolean(freq) then // Turn speaker back on if necessary.
             begin
                  address := $61;
                  data := cont;
                  writetoport;
          end; // end if

     end; // end with

end; // end procedure

procedure TForm1.Button2Click(Sender: TObject);
begin
     Close;
end;

end.
