unit mstrlist;

{26.1.1997: Bug in RestoreOrderInGroups fixed}

{Version 2.2b,  26.1.1997, PostCardWare, Albrecht Mengel, mengel@stat-econ.uni-kiel.de
 See mStrList.txt

 If you have problems/ideas with mStrList, please feel free to email me

**** Bugfix: When ampm is in DateTimeFormat, an error occured, if there was no time entry in
     data found.

**** CHANGED:  TMSortType -> TLSortType, soString -> sString, ... , soDate -> sDate  ******
     This was important, otherwise mStrGrid Users should manually include mStrList to their
     USES list, when using setting mStrGrid1.KeyType values. Sorry! (The compiler will warn you)
     If needed you can typecast list.KeyType:=TLSortType(grid.KeyType) or
     grid.KeyType:=TMSortType(list.KeyType). I'll hold TMSortType and TLSortType compatible.

New Properties for sorting dates: DateTimeFormat:string;
     (Reasons for:
      1. I former used the internal DateTime format, but there are simply too much crashes,
         when the date encountered is not valid
      2. The setting of the global ShortDateFormat has no influence on the interpretation,
         so mStrList interprets selv and is sensible to the own DateTimeFormat.)
     When sorting dates, they are interpreted in the kind as DateTimeFormat is set to.
     Default is the value of ShortDateFormat+' '+LongTimeFormat.
     See mStrList.txt for more description

{$R-}

interface

uses classes;

type

  ShortDateTime_FormatArray=array[1..10] of {7 is enough, but 3 extra delimiters are allowed}
                                 record which:char;
                                        faktor:LongInt;
                                 end;
  TLSortType = (sString,sStringCaseSensitive,sNumeric,sDate);
  TmStrList = class(TStrings)
  private
    fKeyType:TLSortType;
    fKeyLen:Integer;
    fKeyPos:Integer;
    fScipFirst:Integer;
    FList: PStringItemList;
    FCount: Integer;
    FCapacity: Integer;
    FSorted: Boolean;
    FDuplicates: TDuplicates;
    FOnChange: TNotifyEvent;
    FOnChanging: TNotifyEvent;
    fSearchSubstring:Boolean;
    fSortDescending:Boolean;
    fDateTimeFormat:String;
    ShortDateTime_FormatCount:Integer; {Used to store the interpreted actual DateTime format}
    ShortDateTime_FirstFormat:Integer;              {...}
    ShortDateTime_Format:ShortDateTime_FormatArray; {...}
    ShortDate_exists:Boolean;                       {...}
    ShortTime_exists:Boolean;                       {...}
    ShortTime_AMPM:Boolean;
    fShortYearExpand:Boolean;
    fShortYearBorder:Integer;
    procedure SetKeyType(value:TLSortType);
    procedure SetKeyLen(value:Integer);
    procedure SetKeyPos(value:Integer);
    procedure ExchangeItems(Index1, Index2: Integer);
    procedure Grow;
    procedure QuickSort(L, R: Integer);
    procedure InsertItem(Index: Integer; const S: string);
    procedure SetCapacity(NewCapacity: Integer);
    procedure SetSorted(Value: Boolean);
    procedure Sort_Alpha;
    procedure SetDateTimeFormat(value:String);
    procedure Get_ShortDateTimeFormat(format:string);
    function Read_DateTime(x:string):String;
    procedure QuickSortGroup(L,R:integer);
  protected
    procedure Changed; virtual;
    procedure Changing; virtual;
    function Get(Index: Integer): string; override;
    function GetCount: Integer; override;
    function GetObject(Index: Integer): TObject; override;
    procedure Put(Index: Integer; const S: string); override;
    procedure PutObject(Index: Integer; AObject: TObject); override;
    procedure SetUpdateState(Updating: Boolean); override;
  public
    constructor create;
    destructor Destroy; override;
    function Add(const S: string): Integer; override;
    procedure Clear; override;
    procedure Delete(Index: Integer); override;
    procedure Exchange(Index1, Index2: Integer); override;
    function Find(const S: string; var Index: Integer): Boolean; virtual;
    function IndexOf(const S: string): Integer; override;
    procedure Insert(Index: Integer; const S: string); override;
    procedure Sort; virtual;
    property Duplicates: TDuplicates read FDuplicates write FDuplicates;
    property Sorted: Boolean read FSorted write SetSorted;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnChanging: TNotifyEvent read FOnChanging write FOnChanging;
    property KeyType:TLSortType read fKeyType write SetKeyType;
    property KeyLen:Integer read fKeyLen write SetKeyLen;
    property KeyPos:Integer read fKeyPos write SetKeyPos;
    property ScipFirst:Integer read fScipFirst write fScipFirst;
    property SearchSubstring:Boolean read fSearchSubstring write fSearchSubstring;
    property SortDescending:Boolean read fSortDescending write fSortDescending;
    property DateTimeFormat:String read fDateTimeFormat write SetDateTimeFormat;
    property ShortYearExpand:Boolean read fShortYearExpand write fShortYearExpand;
    property ShortYearBorder:Integer read fShortYearBorder write fShortYearBorder;
    procedure RestoreOrderInGroups;
  published
  end;

implementation

uses SysUtils, Consts;

type E_Format_Invalid = class(Exception);

FUNCTION rVAL(CONST von:String):Real;
  {Reads a real value out of the string without an error message.
   Returns 0 if no numeric value}
  VAR bis,err:Integer; nach:Real;
  BEGIN VAL(von,nach,bis);
        IF bis>0 THEN VAL(copy(von,1,bis-1),nach,err);
        rVAL:=nach
  END;{rVAL}

FUNCTION iVAL(CONST von:String):Integer;
  VAR nach,bis,err:Integer;
  BEGIN VAL(von,nach,bis);
        IF bis>0 THEN VAL(copy(von,1,bis-1),nach,err);
        iVAL:=nach
  END;{iVAL}

FUNCTION iVAL_and_del(VAR von:String):Integer;
  VAR nach,bis,err:Integer;
  BEGIN VAL(von,nach,bis);
        IF bis>0
          THEN BEGIN VAL(copy(von,1,bis-1),nach,err);
                     delete(von,1,bis+err)
               END
          ELSE von:='';
        iVAL_and_del:=nach;
  END;{iVAL_and_del}

procedure TmStrList.Get_ShortDateTimeFormat(format:string);
{Interprets given format for further time conversation by read_datetime.
 The format is similar to the format of ShortDateFormat and LongTimeFormat.
 (Use D M Y for day, month, year, and H M (or N) S T AMPM for hours, minutes, seconds,
  1/100 seconds, and 12-hours-system)}
var pos,i:integer;
begin format:=UpperCase(format+' ');
      fillchar(ShortDateTime_Format,sizeof(ShortDateTime_Format),0);
      ShortDate_exists:=false; ShortTime_exists:=false;
      ShortDateTime_FormatCount:=3;
      ShortDateTime_FirstFormat:=1; {If no date exists}
      pos:=0;
      i:=0;
      {Scan Date}
      if format[1]<>'H' then {Scip, if only time is specified}
      begin for i:=1 to 3 do
             with ShortDateTime_Format[i] do
              begin {get next part of format}
                    inc(pos);
                    which:=format[pos];
                    if not (which in ['D','M','Y']) then
                       raise E_Format_Invalid.Create('"'+which+'" in '+format+' (Date format part) is invalid');
                    case which of
                      'D':faktor:=1;
                      'M':faktor:=35; {Reserve space for day no. 32..35}
                      'Y':faktor:=500;{Reserve space for month no. 13}
                    end; {results in 1/1/1800 -> 900036; 1/1/2100 -> 1050036}
                    {search delimiter}
                    repeat inc(pos);
                    until format[pos]<>which;
              end;
            ShortDate_exists:=true;
            ShortDateTime_FirstFormat:=4;
            i:=3;
      end;
      {Scan time}
      repeat inc(i);
       with ShortDateTime_Format[i] do
        begin {get next part of format}
              inc(pos);
              if pos>length(format) then break;
              which:=format[pos];
              if copy(format,pos,4)='AMPM'
              then begin faktor:=0;
                         ShortTime_AMPM:=true;
                         inc(pos,3)
                   end
              else begin if not (which in ['H','M','N','S','T']) then
                           raise E_Format_Invalid.Create('"'+which+'" in '+format+' (Time format part) is invalid');
                         case which of
                           'T':faktor:=1;
                           'S':faktor:=100;
                           'M','N':faktor:=6000;
                           'H':faktor:=360000;
                   end   end;
              inc(ShortDateTime_FormatCount);
              ShortTime_exists:=true;
              {search delimiter}
              repeat inc(pos);
              until format[pos]<>which;
        end
      until false;
end;

function TmStrList.Read_DateTime(x:string):String;
{Results a sortable string: 7 digits date and 7 digits time}
var sum:LongInt; i,value,hours:integer; sav,erg:string[100]; ti:string[7];
    is_am:boolean;
begin sav:=x;
      if ShortDate_exists
      then begin sum:=0;
                 for i:=1 to 3 do
                  with ShortDateTime_Format[i] do
                   begin value:=iVAL_and_del(x);
                         if (which='Y') and fShortYearExpand then
                         if value<fShortYearBorder then inc(value,2000) else
                         if value<100 then inc(value,1900);
                         sum:=sum+value*faktor;
                   end;
                 str(sum:7,erg)
           end
      else erg:='';
      if ShortTime_exists then
      if x<>'' then
      begin sum:=0; hours:=0; is_am:=true;
            for i:=ShortDateTime_FirstFormat to ShortDateTime_FormatCount do
             with ShortDateTime_Format[i] do
              if not ShortTime_AMPM
              then sum:=sum+iVAL_and_del(x)*faktor
              else begin ti:=UpperCase(copy(x,1,2));
                         if ((ti='AM') or (ti='PM')) and (which<>'A') then {ignore it}
                         else case which of
                              'H':begin value:=iVAL_and_del(x);
                                        hours:=value;
                                        sum:=sum+value*faktor;
                                  end;
                              'A':if ti='AM'
                                   then system.delete(x,1,2) else
                                  if ti='PM'
                                   then begin system.delete(x,1,2);
                                              is_am:=false
                                        end
                                   else raise E_Format_Invalid.Create('"'+sav+'" AM or PM expected.'+
                                              ' DateTimeFormat='+fDateTimeFormat);
                              else sum:=sum+iVAL_and_del(x)*faktor
                              end
                   end;
            if ShortTime_AMPM then
             if is_am then if hours=12 then dec(sum,360000*12) else
                      else if hours<12 then inc(sum,360000*12);
            str(sum:7,ti);
            erg:=erg+ti
      end;
      read_datetime:=erg
end;

constructor TmStrList.create;
begin fKeyPos:=1;
      fKeyLen:=MaxInt;
      fDateTimeFormat:=ShortDateFormat+' '+LongTimeFormat;
      fShortYearExpand:=true;
      fShortYearBorder:=10; {0..9 -> 200x; 10..99 -> 19xx}
      Get_ShortDateTimeFormat(fDateTimeFormat)
end;

procedure TmStrList.SetDateTimeFormat(value:String);
begin if value<>fDateTimeFormat then
      begin fDateTimeFormat:=value;
            Get_ShortDateTimeFormat(value)
end   end;

procedure TmStrList.SetKeyType(value:TLSortType);
begin if value<>fKeyType then
      begin fKeyType:=value;
            if FSorted and (fCount>1)  then
             begin Changing;
                   QuickSort(fScipFirst,fCount-1);
                   if fKeyType=sNumeric then Sort_Alpha;
                   Changed;
end   end    end;

procedure TmStrList.SetKeyLen(value:Integer);
begin if value<>fKeyLen then
      begin if value<1 then value:=1;
            {showmessage('Keylen: '+inttostr(fKeylen)+' -> '+inttostr(value));}
            fKeyLen:=value;
            if FSorted and (fCount>1)  then
             begin Changing;
                   QuickSort(fScipFirst,fCount-1);
                   if fKeyType=sNumeric then Sort_Alpha;
                   Changed;
end   end    end;

procedure TmStrList.SetKeyPos(value:Integer);
begin if value<>fKeyPos then
      begin if value<1 then value:=1;
            fKeyPos:=value;
            if FSorted and (fCount>1) then
             begin Changing;
                   QuickSort(fScipFirst,fCount-1);
                   if fKeyType=sNumeric then Sort_Alpha;
                   Changed;
end   end    end;

procedure TmStrList.QuickSort(L, R: Integer);
var I, J: Integer;
    P: string; Pr:Real;
begin
  case fKeyType of
   sString:   repeat I := L; J := R;
                     P := copy(FList^[(L + R) shr 1].FString,fKeyPos,fKeyLen);
                     repeat if fSortDescending
                            then begin while AnsiCompareText(copy(FList^[I].FString,fKeyPos,fKeyLen),P)>0 do Inc(I);
                                       while AnsiCompareText(copy(FList^[J].FString,fKeyPos,fKeyLen),P)<0 do Dec(J);
                                 end
                            else begin while AnsiCompareText(copy(FList^[I].FString,fKeyPos,fKeyLen),P)<0 do Inc(I);
                                       while AnsiCompareText(copy(FList^[J].FString,fKeyPos,fKeyLen),P)>0 do Dec(J);
                                 end;
                            if I <= J then begin
                               ExchangeItems(I, J);
                               Inc(I);      Dec(J);
                            end;
                     until I > J;
                     if L < J then QuickSort(L, J);
                     L := I;
              until I >= R;
   sStringCaseSensitive:
              repeat I := L; J := R;
                     P := copy(FList^[(L + R) shr 1].FString,fKeyPos,fKeyLen);
                     repeat if fSortDescending
                            then begin while copy(FList^[I].FString,fKeyPos,fKeyLen)>P do Inc(I);
                                       while copy(FList^[J].FString,fKeyPos,fKeyLen)<P do Dec(J);
                                 end
                            else begin while copy(FList^[I].FString,fKeyPos,fKeyLen)<P do Inc(I);
                                       while copy(FList^[J].FString,fKeyPos,fKeyLen)>P do Dec(J);
                                 end;
                            if I <= J then begin
                               ExchangeItems(I, J);
                               Inc(I);      Dec(J);
                            end;
                     until I > J;
                     if L < J then QuickSort(L, J);
                     L := I;
              until I >= R;
   sNumeric:  repeat I := L; J := R;
                     Pr:= Rval(copy(FList^[(L + R) shr 1].FString,fKeyPos,fKeyLen));
                     repeat if fSortDescending
                            then begin while Rval(copy(FList^[I].FString,fKeyPos,fKeyLen))>Pr do Inc(I);
                                       while Rval(copy(FList^[J].FString,fKeyPos,fKeyLen))<Pr do Dec(J);
                                 end
                            else begin while Rval(copy(FList^[I].FString,fKeyPos,fKeyLen))<Pr do Inc(I);
                                       while Rval(copy(FList^[J].FString,fKeyPos,fKeyLen))>Pr do Dec(J);
                                 end;
                            if I <= J then begin
                               ExchangeItems(I, J);
                               Inc(I);      Dec(J);
                            end;
                     until I > J;
                     if L < J then QuickSort(L, J);
                     L := I;
              until I >= R;
   sDate:  repeat I := L; J := R;
                     P:=read_datetime(copy(FList^[(L + R) shr 1].FString,fKeyPos,fKeyLen));
                     repeat if fSortDescending
                            then begin while read_datetime(copy(FList^[I].FString,fKeyPos,fKeyLen))>P do Inc(I);
                                       while read_datetime(copy(FList^[J].FString,fKeyPos,fKeyLen))<P do Dec(J);
                                 end
                            else begin while read_datetime(copy(FList^[I].FString,fKeyPos,fKeyLen))<P do Inc(I);
                                       while read_datetime(copy(FList^[J].FString,fKeyPos,fKeyLen))>P do Dec(J);
                                 end;
                            if I <= J then begin
                               ExchangeItems(I, J);
                               Inc(I);      Dec(J);
                            end;
                     until I > J;
                     if L < J then QuickSort(L, J);
                     L := I;
              until I >= R;
  end
end;

procedure TmStrList.QuickSortGroup(L,R:integer);
var I,J,P:Integer;
begin repeat I := L; J := R;
             P:=Integer(FList^[(L + R) shr 1].FObject);
             repeat while Integer(FList^[I].FObject)<P do Inc(I);
                    while Integer(FList^[J].FObject)>P do Dec(J);
                    if I <= J then
                     begin ExchangeItems(I, J);
                           Inc(I);      Dec(J);
                     end;
             until I > J;
             if L < J then QuickSortGroup(L, J);
             L := I;
      until I >= R;
end;

procedure TmStrList.RestoreOrderInGroups;
label ThisWasLastGroup;
var first,last,fini:integer; S:string; R:real;
begin first:=fScipFirst;
      fini:=fCount-1; {Just for having a warning away ->} R:=0;
      repeat last:=succ(first);
             if first>=fini then break; {There is only one element to compare}
             {Get first value}
             case fKeyType of
              sString,sStringCaseSensitive:S:=copy(FList^[first].FString,fKeyPos,fKeyLen);
              sNumeric:R:=Rval(copy(FList^[first].FString,fKeyPos,fKeyLen));
              sDate:S:=read_datetime(copy(FList^[first].FString,fKeyPos,fKeyLen));
             end;
             {Look for group change}
             case fKeyType of
              sString:while AnsiCompareText(copy(FList^[last].FString,fKeyPos,fKeyLen),S)=0 do
                        begin Inc(last);
                              if last>fini then goto ThisWasLastGroup
                        end;
              sStringCaseSensitive:while copy(FList^[last].FString,fKeyPos,fKeyLen)=S do
                        begin Inc(last);
                              if last>fini then goto ThisWasLastGroup
                        end;
              sNumeric:while Rval(copy(FList^[last].FString,fKeyPos,fKeyLen))=R do
                        begin Inc(last);
                              if last>fini then goto ThisWasLastGroup
                        end;
              sDate:while read_datetime(copy(FList^[last].FString,fKeyPos,fKeyLen))=S do
                        begin Inc(last);
                              if last>fini then goto ThisWasLastGroup
                        end;
             end;
             dec(last);
             {Sort by original position (hidden in Object)}
             if first<>last then QuickSortGroup(first,last);
             {Next Group}
             first:=succ(last)
      until false;
   ThisWasLastGroup:   
      dec(last);
      {Sort by original position (hidden in Object)}
      if first<>last then QuickSortGroup(first,last);
end;

procedure ListError(Ident: Integer);
begin
  raise EListError.CreateRes(Ident);
end;

procedure ListIndexError;
begin
  ListError(SListIndexError);
end;

destructor TmStrList.Destroy;
begin
  FOnChange := nil;
  FOnChanging := nil;
  if FCount <> 0 then Finalize(FList^[0], FCount);
  FCount := 0;
  SetCapacity(0);
end;

function TmStrList.Add(const S: string): Integer;
begin
  if not Sorted then
    Result := FCount
  else
    if Find(S, Result) then
      case Duplicates of
        dupIgnore: Exit;
        dupError: ListError(SDuplicateString);
      end;
  InsertItem(Result, S);
end;

procedure TmStrList.Changed;
begin
  if {!(FUpdateCount = 0) and} Assigned(FOnChange) then FOnChange(Self);
end;

procedure TmStrList.Changing;
begin
  if {!(FUpdateCount = 0) and} Assigned(FOnChanging) then FOnChanging(Self);
end;

procedure TmStrList.Clear;
begin
  if FCount <> 0 then
  begin
    Changing;
    Finalize(FList^[0], FCount);
    FCount := 0;
    SetCapacity(0);
    Changed;
  end;
end;

procedure TmStrList.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then ListIndexError;
  Changing;
  Finalize(FList^[Index]);
  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(TStringItem));
  Changed;
end;

procedure TmStrList.Exchange(Index1, Index2: Integer);
begin
  if (Index1 < 0) or (Index1 >= FCount) or
    (Index2 < 0) or (Index2 >= FCount) then ListIndexError;
  Changing;
  ExchangeItems(Index1, Index2);
  Changed;
end;

procedure TmStrList.ExchangeItems(Index1, Index2: Integer);
var
  Temp: Integer;
  Item1, Item2: PStringItem;
begin
  Item1 := @FList^[Index1];
  Item2 := @FList^[Index2];
  Temp := Integer(Item1^.FString);
  Integer(Item1^.FString) := Integer(Item2^.FString);
  Integer(Item2^.FString) := Temp;
  Temp := Integer(Item1^.FObject);
  Integer(Item1^.FObject) := Integer(Item2^.FObject);
  Integer(Item2^.FObject) := Temp;
end;

function TmStrList.Get(Index: Integer): string;
begin
  if (Index < 0) or (Index >= FCount) then ListIndexError;
  Result := FList^[Index].FString;
end;

function TmStrList.GetCount: Integer;
begin
  Result := FCount;
end;

function TmStrList.GetObject(Index: Integer): TObject;
begin
  if (Index < 0) or (Index >= FCount) then ListIndexError;
  Result := FList^[Index].FObject;
end;

procedure TmStrList.Grow;
var
  Delta: Integer;
begin
  if FCapacity > 8 then Delta := 16 else
    if FCapacity > 4 then Delta := 8 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;

function TmStrList.IndexOf(const S: string): Integer;
var i:integer; SearchReal:Real; SearchKey:String;
begin if not Sorted
      then begin SearchReal:=0;
                 {Suchwort konvertieren}
                 case fKeyType of
                   sNumeric:SearchReal:=Rval(S);
                   sString:if fSearchSubstring then SearchKey:=UpperCase(S)
                                               else SearchKey:=S;
                   sDate:SearchKey:=read_datetime(S);
                   else SearchKey:=S
                 end;
                 {Suchen}
                 if fSearchSubstring
                 then case fKeyType of
                       sString,
                       sDate:for i:=0 to FCount-1 do
                                if read_datetime(copy(FList^[i].FString,fKeyPos,fKeyLen))=SearchKey
                                then begin Result:=i; exit end;
                       sStringCaseSensitive:for i:=0 to FCount-1 do
                                if pos(SearchKey,FList^[i].FString)>0
                                then begin Result:=i; exit end;
                       sNumeric:for i:=0 to FCount-1 do
                                if Rval(copy(FList^[i].FString,fKeyPos,fKeyLen))=SearchReal
                                then begin Result:=i; exit end;
                      end
                 else case fKeyType of
                       sString:for i:=0 to FCount-1 do
                                if AnsiCompareText(copy(FList^[i].FString,fKeyPos,fKeyLen),SearchKey)=0
                                then begin Result:=i; exit end;
                       sStringCaseSensitive:for i:=0 to FCount-1 do
                                if copy(FList^[i].FString,fKeyPos,fKeyLen)=SearchKey
                                then begin Result:=i; exit end;
                       sNumeric:for i:=0 to FCount-1 do
                                if Rval(copy(FList^[i].FString,fKeyPos,fKeyLen))=SearchReal
                                then begin Result:=i; exit end;
                       sDate:for i:=0 to FCount-1 do
                                if read_datetime(copy(FList^[i].FString,fKeyPos,fKeyLen))=SearchKey
                                then begin Result:=i; exit end;
                      end;
                 {Nicht gefunden}
                 Result:=-1
           end
      else if not Find(S, Result) then Result := -1;
end;

function cmp(x,y:string):integer;
begin if x<y then cmp:=-1 else
      if x=y then cmp:=0
             else cmp:=1
end;

function TmStrList.Find(const S: string; var Index: Integer): Boolean;
var L, H, I, C: Integer; R, Real_C:real; Date_C:String;
begin Result:=False;
      L:=0;
      H:=FCount-1;
  case fKeyType of
   sString:             while L<=H do
                        begin I:=(L+H) shr 1;
                              C:=AnsiCompareText(copy(FList^[I].FString,fKeyPos,fKeyLen),S);
                              if C<0 then L:=I+1
                                     else begin H:=I-1;
                                                if C=0 then begin Result:=True;
                                                                  if Duplicates<>dupAccept then L:=I;
                        end               end               end;
   sStringCaseSensitive:while L<=H do
                        begin I:=(L+H) shr 1;
                              C:=cmp(copy(FList^[I].FString,fKeyPos,fKeyLen),S);
                              if C<0 then L:=I+1
                                     else begin H:=I-1;
                                                if C=0 then begin Result:=True;
                                                                  if Duplicates<>dupAccept then L:=I;
                        end               end               end;
   sNumeric:            begin Real_C:=Rval(S);
                              while L<=H do
                              begin I:=(L+H) shr 1;
                                    R:=Rval(copy(FList^[I].FString,fKeyPos,fKeyLen))-Real_C;
                                    if R<0 then L:=I+1
                                           else begin H:=I-1;
                                                      if R=0 then begin Result:=True;
                                                                        if Duplicates<>dupAccept then L:=I;
                        end   end               end               end;
   sDate:               begin Date_C:=Read_DateTime(S);
                              while L<=H do
                              begin I:=(L+H) shr 1;
                                    C:=cmp(Read_DateTime(copy(FList^[I].FString,fKeyPos,fKeyLen)),Date_C);
                                    if C<0 then L:=I+1
                                           else begin H:=I-1;
                                                      if C=0 then begin Result:=True;
                                                                        if Duplicates<>dupAccept then L:=I;
  end                   end   end               end               end;
  Index := L;
end;

procedure TmStrList.Insert(Index: Integer; const S: string);
begin
  if Sorted then ListError(SSortedListError);
  if (Index < 0) or (Index > FCount) then ListIndexError;
  InsertItem(Index, S);
end;

procedure TmStrList.InsertItem(Index: Integer; const S: string);
begin
  Changing;
  if FCount = FCapacity then Grow;
  if Index < FCount then
    System.Move(FList^[Index], FList^[Index + 1],
      (FCount - Index) * SizeOf(TStringItem));
  with FList^[Index] do
  begin
    Pointer(FString) := nil;
    FObject := nil;
    FString := S;
  end;
  Inc(FCount);
  Changed;
end;

procedure TmStrList.Put(Index: Integer; const S: string);
begin
  if Sorted then ListError(SSortedListError);
  if (Index < 0) or (Index >= FCount) then ListIndexError;
  Changing;
  FList^[Index].FString := S;
  Changed;
end;

procedure TmStrList.PutObject(Index: Integer; AObject: TObject);
begin
  if (Index < 0) or (Index >= FCount) then ListIndexError;
  Changing;
  FList^[Index].FObject := AObject;
  Changed;
end;

procedure TmStrList.SetCapacity(NewCapacity: Integer);
begin
  ReallocMem(FList, NewCapacity * SizeOf(TStringItem));
  FCapacity := NewCapacity;
end;

procedure TmStrList.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    if Value then Sort;
    FSorted := Value;
  end;
end;

procedure TmStrList.SetUpdateState(Updating: Boolean);
begin
  if Updating then Changing else Changed;
end;

procedure TmStrList.Sort;
begin
  if not Sorted and (FCount > 1) then
  begin
    Changing;
    QuickSort(fScipFirst, FCount - 1);
    if fKeyType=sNumeric then Sort_Alpha;
    Changed;
  end;
end;

procedure TmStrList.Sort_Alpha;
var anfang,ende:integer; found:boolean;
begin {soNumeric : post sort Alphas}
      anfang:=fScipFirst;
      found:=false;
      while anfang<fCount do
       if rval(copy(FList^[anfang].FString,fKeyPos,fKeyLen))<>0
        then inc(anfang)
        else begin found:=true;
                   break
             end;
      if not found then exit;
      ende:=anfang+1;
      while ende<fCount do
       if rval(copy(FList^[ende].FString,fKeyPos,fKeyLen))=0
        then inc(ende)
        else break;
      if anfang<ende-1 then
      begin fKeyType:=sString;
            QuickSort(anfang,ende-1);
            fKeyType:=sNumeric
end   end;

end.
