unit Reorder_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, mStrGrid, Buttons;

type
  TForm1 = class(TForm)
    mStrGrid1: TmStrGrid;
    ListBox1: TListBox;
    QuitBtn: TBitBtn;
    ReorderBtn: TBitBtn;
    UndoBtn: TBitBtn;
    MixGridBtn: TBitBtn;
    MixListBoxBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure QuitBtnClick(Sender: TObject);
    procedure MixGridBtnClick(Sender: TObject);
    procedure MixListBoxBtnClick(Sender: TObject);
    procedure UndoBtnClick(Sender: TObject);
    procedure ReorderBtnClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var r,c:integer; new:string;
begin with mstrgrid1 do
begin {Fill top left}
      cells[0,0]:='XXX';
      {Fill top row}
      for r:=1 to RowCount-1 do
       cells[0,r]:=chr(64+r);
      {Fill left column}
      for c:=1 to ColCount-1 do
       cells[c,0]:=chr(96+c);
      {Fill inner left column without repeated values}
      for r:=1 to RowCount-1 do
       begin repeat new:=inttostr(round(random(1000)));
             until not FindFirstInCol(new,1{searchCol},c,c);
             cells[1,r]:=new
       end;
      {Fill inner rest}
      for r:=1 to RowCount-1 do
       for c:=2 to ColCount-1 do
        cells[c,r]:=inttostr(round(random(1000)));
      {Copy first data row to listbox}
      for r:=FixedRows to RowCount-1 do
        ListBox1.items.add(cells[1,r]);
      MixListBoxBtnClick(Sender);
end end;

procedure TForm1.MixGridBtnClick(Sender: TObject);
var i,newpos:integer; tmp:string;
begin with mStrGrid1 do
       for i:=FixedRows to RowCount-1 do
        begin newpos:=trunc(random(RowCount-FixedRows))+FixedRows;
              tmp:=cells[1,i]; cells[1,i]:=cells[1,newpos]; cells[1,newpos]:=tmp
end     end;

procedure TForm1.MixListBoxBtnClick(Sender: TObject);
var i,newpos:integer; tmp:string;
begin with ListBox1,items do
       for i:=0 to Count-1 do
        begin newpos:=trunc(random(Count-1))+1;
              tmp:=items[i]; items[i]:=items[newpos]; items[newpos]:=tmp
end     end;

procedure TForm1.QuitBtnClick(Sender: TObject);
begin close end;

procedure TForm1.UndoBtnClick(Sender: TObject);
begin mStrGrid1.UndoSort end;

procedure TForm1.ReorderBtnClick(Sender: TObject);
begin mStrGrid1.ReorderCompleteRows(1,ListBox1.items) end;

end.
