(*******************************************************************************
  Class: TMultiLineBtn
  Author: Bill Menees
  Written: 10/31/96
  bmenees@usit.net
  http://www.public.usit.net/bmenees

  Information:
  TMultiLineBtn is a descendent of TButton that allows multi-line captions.
  I'm placing it in the public domain.  Do with it as you like.
*******************************************************************************)
unit MLButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TMultiLineBtn = class(TButton)
  private
    fMultiLine: Boolean;
    procedure SetMultiLine(Value: Boolean);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property MultiLine: Boolean read fMultiLine write SetMultiLine default True;
  end;

procedure Register;

implementation

{$R MLButton.Res}

constructor TMultiLineBtn.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     fMultiLine:=True;
end;

procedure TMultiLineBtn.SetMultiLine(Value: Boolean);
begin
     if fMultiLine<>Value then
     begin
          fMultiLine:=Value;
          RecreateWnd;
     end;
end;

procedure TMultiLineBtn.CreateParams(var Params: TCreateParams);
begin
     inherited CreateParams(Params);
     if MultiLine then
        Params.Style:=Params.Style or BS_MULTILINE
     else
         Params.Style:=Params.Style and not BS_MULTILINE;
end;

procedure Register;
begin
  RegisterComponents('Additional', [TMultiLineBtn]);
end;

end.
